/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.generator.impl.module;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.ResolvedTypeWithMembers;
import com.fasterxml.classmate.members.ResolvedField;
import com.github.victools.jsonschema.generator.Module;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigBuilder;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;

public class ConstantValueModule
implements Module {
    private static List<?> extractConstantFieldValue(ResolvedField field, ResolvedType fieldType, ResolvedTypeWithMembers declaringType) {
        if (field.isStatic() && field.isFinal() && !((Field)field.getRawMember()).isEnumConstant()) {
            ((Field)field.getRawMember()).setAccessible(true);
            try {
                return Collections.singletonList(((Field)field.getRawMember()).get(null));
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException(ex);
            }
        }
        return null;
    }

    private static Boolean isNullableConstantField(ResolvedField field, ResolvedType fieldType, ResolvedTypeWithMembers declaringType) {
        List<?> constantValues = ConstantValueModule.extractConstantFieldValue(field, fieldType, declaringType);
        if (constantValues == null) {
            return null;
        }
        return constantValues.get(0) == null;
    }

    @Override
    public void applyToConfigBuilder(SchemaGeneratorConfigBuilder builder) {
        builder.forFields().withEnumResolver(ConstantValueModule::extractConstantFieldValue).withNullableCheck(ConstantValueModule::isNullableConstantField);
    }
}

