/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.generator;

import com.fasterxml.classmate.AnnotationConfiguration;
import com.fasterxml.classmate.MemberResolver;
import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.ResolvedTypeWithMembers;
import com.fasterxml.classmate.TypeResolver;
import com.fasterxml.classmate.members.RawField;
import com.fasterxml.classmate.members.RawMethod;
import com.fasterxml.classmate.members.ResolvedField;
import com.fasterxml.classmate.members.ResolvedMember;
import com.fasterxml.classmate.members.ResolvedMethod;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.stream.Stream;

public abstract class TypeContext {
    private final TypeResolver typeResolver;
    private final MemberResolver memberResolver;
    private final AnnotationConfiguration annotationConfig;

    protected TypeContext(TypeResolver typeResolver, AnnotationConfiguration annotationConfig) {
        this.typeResolver = typeResolver;
        this.memberResolver = new MemberResolver(typeResolver);
        this.annotationConfig = annotationConfig;
    }

    public ResolvedType resolve(Type type) {
        return this.typeResolver.resolve(type, new Type[0]);
    }

    public ResolvedTypeWithMembers resolveWithMembers(ResolvedType mainType) {
        return this.memberResolver.resolve(mainType, this.annotationConfig, null);
    }

    public ResolvedField resolveMember(RawField rawField) {
        return this.resolveMember(rawField, this.resolveWithMembers(rawField.getDeclaringType()));
    }

    public ResolvedField resolveMember(RawField rawField, ResolvedTypeWithMembers declaringType) {
        ResolvedField[] resolvedFields = rawField.isStatic() ? declaringType.getStaticFields() : declaringType.getMemberFields();
        ResolvedField result = (ResolvedField)this.findMember((ResolvedMember[])resolvedFields, rawField.getRawMember());
        return result;
    }

    public ResolvedMethod resolveMember(RawMethod rawMethod) {
        return this.resolveMember(rawMethod, this.resolveWithMembers(rawMethod.getDeclaringType()));
    }

    public ResolvedMethod resolveMember(RawMethod rawMethod, ResolvedTypeWithMembers declaringType) {
        ResolvedMethod[] resolvedMethods = rawMethod.isStatic() ? declaringType.getStaticMethods() : declaringType.getMemberMethods();
        ResolvedMethod result = (ResolvedMethod)this.findMember((ResolvedMember[])resolvedMethods, rawMethod.getRawMember());
        return result;
    }

    private <R extends ResolvedMember<? extends J>, J extends Member> R findMember(R[] resolvedMembers, J javaMember) {
        return (R)((ResolvedMember)Stream.of(resolvedMembers).filter(resolvedMethod -> resolvedMethod.getRawMember().equals(javaMember)).findAny().orElse(null));
    }

    public boolean isContainerType(ResolvedType type) {
        return type.isArray() || type.isInstanceOf(Collection.class);
    }

    public ResolvedType getContainerItemType(ResolvedType containerType) {
        ResolvedType itemType = containerType.getArrayElementType();
        if (itemType == null) {
            itemType = (ResolvedType)containerType.typeParametersFor(Collection.class).get(0);
        }
        return itemType;
    }
}

