/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.generator;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.ResolvedTypeWithMembers;
import com.fasterxml.classmate.members.ResolvedMember;
import com.github.victools.jsonschema.generator.ConfigFunction;
import com.github.victools.jsonschema.generator.InstanceAttributeOverride;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;

public class SchemaGeneratorConfigPart<O extends ResolvedMember<?>> {
    private final List<InstanceAttributeOverride<O>> instanceAttributeOverrides = new ArrayList<InstanceAttributeOverride<O>>();
    private final List<BiPredicate<O, ResolvedTypeWithMembers>> ignoreChecks = new ArrayList<BiPredicate<O, ResolvedTypeWithMembers>>();
    private final List<ConfigFunction<O, ResolvedType, Boolean>> nullableChecks = new ArrayList<ConfigFunction<O, ResolvedType, Boolean>>();
    private final List<ConfigFunction<O, ResolvedType, ResolvedType>> targetTypeOverrideResolvers = new ArrayList<ConfigFunction<O, ResolvedType, ResolvedType>>();
    private final List<ConfigFunction<O, String, String>> propertyNameOverrideResolvers = new ArrayList<ConfigFunction<O, String, String>>();
    private final List<ConfigFunction<O, ResolvedType, String>> titleResolvers = new ArrayList<ConfigFunction<O, ResolvedType, String>>();
    private final List<ConfigFunction<O, ResolvedType, String>> descriptionResolvers = new ArrayList<ConfigFunction<O, ResolvedType, String>>();
    private final List<ConfigFunction<O, ResolvedType, Collection<?>>> enumResolvers = new ArrayList();
    private final List<ConfigFunction<O, ResolvedType, Integer>> stringMinLengthResolvers = new ArrayList<ConfigFunction<O, ResolvedType, Integer>>();
    private final List<ConfigFunction<O, ResolvedType, Integer>> stringMaxLengthResolvers = new ArrayList<ConfigFunction<O, ResolvedType, Integer>>();
    private final List<ConfigFunction<O, ResolvedType, String>> stringFormatResolvers = new ArrayList<ConfigFunction<O, ResolvedType, String>>();
    private final List<ConfigFunction<O, ResolvedType, BigDecimal>> numberInclusiveMinimumResolvers = new ArrayList<ConfigFunction<O, ResolvedType, BigDecimal>>();
    private final List<ConfigFunction<O, ResolvedType, BigDecimal>> numberExclusiveMinimumResolvers = new ArrayList<ConfigFunction<O, ResolvedType, BigDecimal>>();
    private final List<ConfigFunction<O, ResolvedType, BigDecimal>> numberInclusiveMaximumResolvers = new ArrayList<ConfigFunction<O, ResolvedType, BigDecimal>>();
    private final List<ConfigFunction<O, ResolvedType, BigDecimal>> numberExclusiveMaximumResolvers = new ArrayList<ConfigFunction<O, ResolvedType, BigDecimal>>();
    private final List<ConfigFunction<O, ResolvedType, BigDecimal>> numberMultipleOfResolvers = new ArrayList<ConfigFunction<O, ResolvedType, BigDecimal>>();
    private final List<ConfigFunction<O, ResolvedType, Integer>> arrayMinItemsResolvers = new ArrayList<ConfigFunction<O, ResolvedType, Integer>>();
    private final List<ConfigFunction<O, ResolvedType, Integer>> arrayMaxItemsResolvers = new ArrayList<ConfigFunction<O, ResolvedType, Integer>>();
    private final List<ConfigFunction<O, ResolvedType, Boolean>> arrayUniqueItemsResolvers = new ArrayList<ConfigFunction<O, ResolvedType, Boolean>>();

    private static <O extends ResolvedMember<?>, P, R> R getFirstDefinedValue(List<ConfigFunction<O, P, R>> resolvers, O origin, P secondParameter, ResolvedTypeWithMembers declaringType) {
        return resolvers.stream().map(resolver -> resolver.apply(origin, secondParameter, declaringType)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public SchemaGeneratorConfigPart<O> withInstanceAttributeOverride(InstanceAttributeOverride<O> override) {
        this.instanceAttributeOverrides.add(override);
        return this;
    }

    public List<InstanceAttributeOverride<O>> getInstanceAttributeOverrides() {
        return Collections.unmodifiableList(this.instanceAttributeOverrides);
    }

    public SchemaGeneratorConfigPart<O> withIgnoreCheck(BiPredicate<O, ResolvedTypeWithMembers> check) {
        this.ignoreChecks.add(check);
        return this;
    }

    public boolean shouldIgnore(O origin, ResolvedTypeWithMembers declaringType) {
        return this.ignoreChecks.stream().anyMatch(check -> check.test(origin, declaringType));
    }

    public SchemaGeneratorConfigPart<O> withNullableCheck(ConfigFunction<O, ResolvedType, Boolean> check) {
        this.nullableChecks.add(check);
        return this;
    }

    public Boolean isNullable(O origin, ResolvedType originType, ResolvedTypeWithMembers declaringType) {
        Set result = this.nullableChecks.stream().map(check -> (Boolean)check.apply(origin, originType, declaringType)).filter(Objects::nonNull).collect(Collectors.toSet());
        return result.isEmpty() ? null : Boolean.valueOf(result.stream().anyMatch(value -> value));
    }

    public SchemaGeneratorConfigPart<O> withTargetTypeOverrideResolver(ConfigFunction<O, ResolvedType, ResolvedType> resolver) {
        this.targetTypeOverrideResolvers.add(resolver);
        return this;
    }

    public ResolvedType resolveTargetTypeOverride(O origin, ResolvedType defaultType, ResolvedTypeWithMembers declaringType) {
        return (ResolvedType)SchemaGeneratorConfigPart.getFirstDefinedValue(this.targetTypeOverrideResolvers, origin, defaultType, declaringType);
    }

    public SchemaGeneratorConfigPart<O> withPropertyNameOverrideResolver(ConfigFunction<O, String, String> resolver) {
        this.propertyNameOverrideResolvers.add(resolver);
        return this;
    }

    public String resolvePropertyNameOverride(O origin, String defaultName, ResolvedTypeWithMembers declaringType) {
        return (String)SchemaGeneratorConfigPart.getFirstDefinedValue(this.propertyNameOverrideResolvers, origin, defaultName, declaringType);
    }

    public SchemaGeneratorConfigPart<O> withTitleResolver(ConfigFunction<O, ResolvedType, String> resolver) {
        this.titleResolvers.add(resolver);
        return this;
    }

    public String resolveTitle(O origin, ResolvedType originType, ResolvedTypeWithMembers declaringType) {
        return (String)SchemaGeneratorConfigPart.getFirstDefinedValue(this.titleResolvers, origin, originType, declaringType);
    }

    public SchemaGeneratorConfigPart<O> withDescriptionResolver(ConfigFunction<O, ResolvedType, String> resolver) {
        this.descriptionResolvers.add(resolver);
        return this;
    }

    public String resolveDescription(O origin, ResolvedType originType, ResolvedTypeWithMembers declaringType) {
        return (String)SchemaGeneratorConfigPart.getFirstDefinedValue(this.descriptionResolvers, origin, originType, declaringType);
    }

    public SchemaGeneratorConfigPart<O> withEnumResolver(ConfigFunction<O, ResolvedType, Collection<?>> resolver) {
        this.enumResolvers.add(resolver);
        return this;
    }

    public Collection<?> resolveEnum(O origin, ResolvedType originType, ResolvedTypeWithMembers declaringType) {
        return (Collection)SchemaGeneratorConfigPart.getFirstDefinedValue(this.enumResolvers, origin, originType, declaringType);
    }

    public SchemaGeneratorConfigPart<O> withStringMinLengthResolver(ConfigFunction<O, ResolvedType, Integer> resolver) {
        this.stringMinLengthResolvers.add(resolver);
        return this;
    }

    public Integer resolveStringMinLength(O origin, ResolvedType originType, ResolvedTypeWithMembers declaringType) {
        return (Integer)SchemaGeneratorConfigPart.getFirstDefinedValue(this.stringMinLengthResolvers, origin, originType, declaringType);
    }

    public SchemaGeneratorConfigPart<O> withStringMaxLengthResolver(ConfigFunction<O, ResolvedType, Integer> resolver) {
        this.stringMaxLengthResolvers.add(resolver);
        return this;
    }

    public Integer resolveStringMaxLength(O origin, ResolvedType originType, ResolvedTypeWithMembers declaringType) {
        return (Integer)SchemaGeneratorConfigPart.getFirstDefinedValue(this.stringMaxLengthResolvers, origin, originType, declaringType);
    }

    public SchemaGeneratorConfigPart<O> withStringFormatResolver(ConfigFunction<O, ResolvedType, String> resolver) {
        this.stringFormatResolvers.add(resolver);
        return this;
    }

    public String resolveStringFormat(O origin, ResolvedType originType, ResolvedTypeWithMembers declaringType) {
        return (String)SchemaGeneratorConfigPart.getFirstDefinedValue(this.stringFormatResolvers, origin, originType, declaringType);
    }

    public SchemaGeneratorConfigPart<O> withNumberInclusiveMinimumResolver(ConfigFunction<O, ResolvedType, BigDecimal> resolver) {
        this.numberInclusiveMinimumResolvers.add(resolver);
        return this;
    }

    public BigDecimal resolveNumberInclusiveMinimum(O origin, ResolvedType originType, ResolvedTypeWithMembers declaringType) {
        return (BigDecimal)SchemaGeneratorConfigPart.getFirstDefinedValue(this.numberInclusiveMinimumResolvers, origin, originType, declaringType);
    }

    public SchemaGeneratorConfigPart<O> withNumberExclusiveMinimumResolver(ConfigFunction<O, ResolvedType, BigDecimal> resolver) {
        this.numberExclusiveMinimumResolvers.add(resolver);
        return this;
    }

    public BigDecimal resolveNumberExclusiveMinimum(O origin, ResolvedType originType, ResolvedTypeWithMembers declaringType) {
        return (BigDecimal)SchemaGeneratorConfigPart.getFirstDefinedValue(this.numberExclusiveMinimumResolvers, origin, originType, declaringType);
    }

    public SchemaGeneratorConfigPart<O> withNumberInclusiveMaximumResolver(ConfigFunction<O, ResolvedType, BigDecimal> resolver) {
        this.numberInclusiveMaximumResolvers.add(resolver);
        return this;
    }

    public BigDecimal resolveNumberInclusiveMaximum(O origin, ResolvedType originType, ResolvedTypeWithMembers declaringType) {
        return (BigDecimal)SchemaGeneratorConfigPart.getFirstDefinedValue(this.numberInclusiveMaximumResolvers, origin, originType, declaringType);
    }

    public SchemaGeneratorConfigPart<O> withNumberExclusiveMaximumResolver(ConfigFunction<O, ResolvedType, BigDecimal> resolver) {
        this.numberExclusiveMaximumResolvers.add(resolver);
        return this;
    }

    public BigDecimal resolveNumberExclusiveMaximum(O origin, ResolvedType originType, ResolvedTypeWithMembers declaringType) {
        return (BigDecimal)SchemaGeneratorConfigPart.getFirstDefinedValue(this.numberExclusiveMaximumResolvers, origin, originType, declaringType);
    }

    public SchemaGeneratorConfigPart<O> withNumberMultipleOfResolver(ConfigFunction<O, ResolvedType, BigDecimal> resolver) {
        this.numberMultipleOfResolvers.add(resolver);
        return this;
    }

    public BigDecimal resolveNumberMultipleOf(O origin, ResolvedType originType, ResolvedTypeWithMembers declaringType) {
        return (BigDecimal)SchemaGeneratorConfigPart.getFirstDefinedValue(this.numberMultipleOfResolvers, origin, originType, declaringType);
    }

    public SchemaGeneratorConfigPart<O> withArrayMinItemsResolver(ConfigFunction<O, ResolvedType, Integer> resolver) {
        this.arrayMinItemsResolvers.add(resolver);
        return this;
    }

    public Integer resolveArrayMinItems(O origin, ResolvedType originType, ResolvedTypeWithMembers declaringType) {
        return (Integer)SchemaGeneratorConfigPart.getFirstDefinedValue(this.arrayMinItemsResolvers, origin, originType, declaringType);
    }

    public SchemaGeneratorConfigPart<O> withArrayMaxItemsResolver(ConfigFunction<O, ResolvedType, Integer> resolver) {
        this.arrayMaxItemsResolvers.add(resolver);
        return this;
    }

    public Integer resolveArrayMaxItems(O origin, ResolvedType originType, ResolvedTypeWithMembers declaringType) {
        return (Integer)SchemaGeneratorConfigPart.getFirstDefinedValue(this.arrayMaxItemsResolvers, origin, originType, declaringType);
    }

    public SchemaGeneratorConfigPart<O> withArrayUniqueItemsResolver(ConfigFunction<O, ResolvedType, Boolean> resolver) {
        this.arrayUniqueItemsResolvers.add(resolver);
        return this;
    }

    public Boolean resolveArrayUniqueItems(O origin, ResolvedType originType, ResolvedTypeWithMembers declaringType) {
        return (Boolean)SchemaGeneratorConfigPart.getFirstDefinedValue(this.arrayUniqueItemsResolvers, origin, originType, declaringType);
    }
}

