/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.generator.impl.module;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.victools.jsonschema.generator.CustomDefinition;
import com.github.victools.jsonschema.generator.CustomDefinitionProvider;
import com.github.victools.jsonschema.generator.JavaType;
import com.github.victools.jsonschema.generator.Module;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigBuilder;
import com.github.victools.jsonschema.generator.impl.ReflectionTypeUtils;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Stream;

public class SimpleTypeModule
implements Module {
    private final Map<Class<?>, String> fixedJsonSchemaTypes = new HashMap();

    public static SimpleTypeModule forPrimitiveTypes() {
        SimpleTypeModule module = new SimpleTypeModule();
        module.withObjectType(Object.class);
        Stream.of(String.class, Character.class, Character.TYPE, CharSequence.class).forEach(module::withStringType);
        Stream.of(Boolean.class, Boolean.TYPE).forEach(module::withBooleanType);
        Stream.of(Integer.class, Integer.TYPE, Long.class, Long.TYPE, Short.class, Short.TYPE, Byte.class, Byte.TYPE).forEach(module::withIntegerType);
        Stream.of(Double.class, Double.TYPE, Float.class, Float.TYPE).forEach(module::withNumberType);
        return module;
    }

    public static SimpleTypeModule forPrimitiveAndAdditionalTypes() {
        SimpleTypeModule module = SimpleTypeModule.forPrimitiveTypes();
        Stream.of(LocalDate.class, LocalDateTime.class, LocalTime.class, ZonedDateTime.class, OffsetDateTime.class, OffsetTime.class, Instant.class, ZoneId.class, Date.class, Calendar.class, UUID.class).forEach(module::withStringType);
        module.withIntegerType(BigInteger.class);
        Stream.of(BigDecimal.class, Number.class).forEach(module::withNumberType);
        return module;
    }

    private SimpleTypeModule with(Class<?> javaType, String jsonSchemaTypeValue) {
        this.fixedJsonSchemaTypes.put(javaType, jsonSchemaTypeValue);
        return this;
    }

    public final SimpleTypeModule withObjectType(Class<?> javaType) {
        return this.with(javaType, "object");
    }

    public final SimpleTypeModule withStringType(Class<?> javaType) {
        return this.with(javaType, "string");
    }

    public final SimpleTypeModule withBooleanType(Class<?> javaType) {
        return this.with(javaType, "boolean");
    }

    public final SimpleTypeModule withIntegerType(Class<?> javaType) {
        return this.with(javaType, "integer");
    }

    public final SimpleTypeModule withNumberType(Class<?> javaType) {
        return this.with(javaType, "number");
    }

    private <F> Boolean isNullableType(F fieldOrMethod, JavaType type) {
        Class<?> rawType = ReflectionTypeUtils.getRawType(type.getResolvedType());
        if (rawType != null && rawType.isPrimitive()) {
            return Boolean.FALSE;
        }
        return null;
    }

    @Override
    public void applyToConfigBuilder(SchemaGeneratorConfigBuilder builder) {
        builder.forFields().withNullableCheck(this::isNullableType);
        builder.forMethods().withNullableCheck(this::isNullableType);
        builder.with(new SimpleTypeDefinitionProvider(builder.getObjectMapper()));
    }

    private class SimpleTypeDefinitionProvider
    implements CustomDefinitionProvider {
        private final ObjectMapper objectMapper;

        SimpleTypeDefinitionProvider(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
        }

        @Override
        public CustomDefinition provideCustomSchemaDefinition(JavaType javaType) {
            Type genericType = javaType.getResolvedType();
            if (!(genericType instanceof Class)) {
                return null;
            }
            String jsonSchemaTypeValue = (String)SimpleTypeModule.this.fixedJsonSchemaTypes.get(genericType);
            if (jsonSchemaTypeValue == null) {
                return null;
            }
            ObjectNode customSchema = this.objectMapper.createObjectNode().put("type", jsonSchemaTypeValue);
            return new CustomDefinition(customSchema, true);
        }
    }
}

