/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.generator.impl.module;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.victools.jsonschema.generator.CustomDefinition;
import com.github.victools.jsonschema.generator.CustomDefinitionProvider;
import com.github.victools.jsonschema.generator.JavaType;
import com.github.victools.jsonschema.generator.Module;
import com.github.victools.jsonschema.generator.SchemaGeneratorConfigBuilder;
import com.github.victools.jsonschema.generator.impl.AttributeCollector;
import com.github.victools.jsonschema.generator.impl.ReflectionTypeUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.EnumSet;
import java.util.List;
import java.util.stream.Collectors;

public class EnumModule
implements Module {
    private final boolean treatAsString;

    public static EnumModule asStrings() {
        return new EnumModule(true);
    }

    public static EnumModule asObjects() {
        return new EnumModule(false);
    }

    public EnumModule(boolean treatAsString) {
        this.treatAsString = treatAsString;
    }

    @Override
    public void applyToConfigBuilder(SchemaGeneratorConfigBuilder builder) {
        if (this.treatAsString) {
            builder.with(new EnumAsStringDefinitionProvider(builder.getObjectMapper()));
        } else {
            builder.forMethods().withIgnoreCheck(method -> method.getDeclaringClass() == Enum.class && !"name".equals(method.getName())).withNullableCheck((method, type) -> method.getDeclaringClass() == Enum.class ? Boolean.FALSE : null).withEnumResolver(EnumModule::extractEnumValues);
            builder.forFields().withIgnoreCheck(field -> field.isEnumConstant());
        }
    }

    private static List<String> extractEnumValues(Method method, JavaType returnType) {
        if (method.getDeclaringClass() == Enum.class) {
            Type actualEnumType = returnType.getParentTypeVariables().resolveGenericTypePlaceholder(Enum.class.getTypeParameters()[0]).getResolvedType();
            return EnumModule.extractEnumValues((Class)actualEnumType);
        }
        return null;
    }

    private static <E extends Enum<E>> List<String> extractEnumValues(Class<E> enumType) {
        return EnumSet.allOf(enumType).stream().map(Enum::name).collect(Collectors.toList());
    }

    private static class EnumAsStringDefinitionProvider
    implements CustomDefinitionProvider {
        private final ObjectMapper objectMapper;

        EnumAsStringDefinitionProvider(ObjectMapper objectMapper) {
            this.objectMapper = objectMapper;
        }

        @Override
        public CustomDefinition provideCustomSchemaDefinition(JavaType javaType) {
            Class<?> rawType = ReflectionTypeUtils.getRawType(javaType.getResolvedType());
            if (rawType != null && rawType.isEnum()) {
                ObjectNode customNode = this.objectMapper.createObjectNode().put("type", "string");
                new AttributeCollector(this.objectMapper).setEnum(customNode, EnumModule.extractEnumValues(rawType));
                return new CustomDefinition(customNode);
            }
            return null;
        }
    }
}

