/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.generator;

import com.github.victools.jsonschema.generator.JavaType;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TypeVariableContext {
    private static final Logger logger = LoggerFactory.getLogger(TypeVariableContext.class);
    public static final TypeVariableContext EMPTY_SCOPE = new TypeVariableContext();
    private final Map<String, JavaType> typeVariablesByName;
    private final TypeVariableContext parentContext;

    public static TypeVariableContext forType(JavaType targetType) {
        return TypeVariableContext.forType(targetType.getResolvedType(), targetType.getParentTypeVariables());
    }

    public static TypeVariableContext forType(Type targetType, TypeVariableContext parentTypeVariables) {
        TypeVariableContext result;
        if (targetType instanceof Class && ((Class)targetType).getTypeParameters().length > 0) {
            TypeVariable<Class<T>>[] genericParams = ((Class)targetType).getTypeParameters();
            result = new TypeVariableContext(genericParams, EMPTY_SCOPE);
        } else if (targetType instanceof ParameterizedType) {
            ParameterizedType parameterizedTargetType = (ParameterizedType)targetType;
            TypeVariable<Class<T>>[] genericParams = ((Class)parameterizedTargetType.getRawType()).getTypeParameters();
            HashMap<String, JavaType> typeVariables = new HashMap<String, JavaType>();
            Type[] typeArguments = parameterizedTargetType.getActualTypeArguments();
            for (int index = 0; index < genericParams.length; ++index) {
                typeVariables.put(genericParams[index].getName(), new JavaType(typeArguments[index], parentTypeVariables));
            }
            result = new TypeVariableContext(typeVariables, parentTypeVariables);
        } else {
            result = targetType instanceof GenericArrayType ? parentTypeVariables : EMPTY_SCOPE;
        }
        return result;
    }

    public static TypeVariableContext forMethod(Method targetMethod, TypeVariableContext parentTypeVariables) {
        TypeVariable<Method>[] genericParams = targetMethod.getTypeParameters();
        TypeVariableContext result = genericParams.length == 0 ? parentTypeVariables : new TypeVariableContext(genericParams, parentTypeVariables);
        return result;
    }

    private TypeVariableContext() {
        this(Collections.emptyMap(), null);
    }

    private TypeVariableContext(Map<String, JavaType> typeVariablesByName, TypeVariableContext parentContext) {
        this.typeVariablesByName = typeVariablesByName;
        this.parentContext = parentContext;
    }

    private TypeVariableContext(TypeVariable<?>[] genericParams, TypeVariableContext baseTypeVariables) {
        this.typeVariablesByName = new HashMap<String, JavaType>(baseTypeVariables.typeVariablesByName);
        for (TypeVariable<?> singleParameter : genericParams) {
            Type typeArgument = (Type)((Object)Stream.of(singleParameter.getBounds()).findFirst().orElse((Type)((Object)Object.class)));
            this.typeVariablesByName.put(singleParameter.getName(), new JavaType(typeArgument, this));
        }
        this.parentContext = baseTypeVariables.parentContext;
    }

    public JavaType resolveGenericTypePlaceholder(Type targetType) {
        Type actualTargetType = targetType;
        while (actualTargetType instanceof WildcardType) {
            logger.debug("resolving wildcard type's upper bound ({})", (Object)actualTargetType);
            actualTargetType = (Type)((Object)Stream.of(((WildcardType)actualTargetType).getUpperBounds()).findFirst().orElse((Type)((Object)Object.class)));
        }
        JavaType result = actualTargetType instanceof TypeVariable ? this.resolveTypeVariable((TypeVariable)actualTargetType) : new JavaType(actualTargetType, this);
        return result;
    }

    private JavaType resolveTypeVariable(TypeVariable<?> typeVariable) {
        String variableName = typeVariable.getName();
        logger.debug("attempting to resolve type variable {}", (Object)variableName);
        if (this.typeVariablesByName.containsKey(variableName)) {
            TypeVariableContext nextContext;
            JavaType resolvedType = this.typeVariablesByName.get(variableName);
            TypeVariableContext resolvedContext = resolvedType.getParentTypeVariables();
            if (resolvedContext == this) {
                HashMap<String, JavaType> typeVariables = new HashMap<String, JavaType>(resolvedContext.typeVariablesByName);
                typeVariables.remove(variableName);
                nextContext = new TypeVariableContext(typeVariables, resolvedContext.parentContext);
            } else {
                nextContext = resolvedContext;
            }
            return nextContext.resolveGenericTypePlaceholder(resolvedType.getDeclaredType());
        }
        if (this.parentContext != null) {
            logger.debug("looking-up type variable {} in parent context", (Object)variableName);
            return this.parentContext.resolveGenericTypePlaceholder(typeVariable);
        }
        throw new IllegalStateException(variableName + " is an undefined variable in this context. Maybe wrong context was applied?");
    }
}

