/*
 * Decompiled with CFR 0.152.
 */
package com.github.victools.jsonschema.generator.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Method;

public final class ReflectionGetterUtils {
    private ReflectionGetterUtils() {
    }

    public static Method findGetterForField(Field field) {
        String capitalisedFieldName = field.getName().substring(0, 1).toUpperCase() + field.getName().substring(1);
        Method getter = null;
        try {
            getter = field.getDeclaringClass().getDeclaredMethod("get" + capitalisedFieldName, new Class[0]);
        }
        catch (NoSuchMethodException ex1) {
            try {
                getter = field.getDeclaringClass().getDeclaredMethod("is" + capitalisedFieldName, new Class[0]);
            }
            catch (NoSuchMethodException ex2) {
                return null;
            }
        }
        if (getter == null || (getter.getModifiers() & 1) == 0) {
            return null;
        }
        return getter;
    }

    public static boolean hasGetter(Field field) {
        return ReflectionGetterUtils.findGetterForField(field) != null;
    }

    public static Field findFieldForGetter(Method method) {
        if ((method.getModifiers() & 1) == 0) {
            return null;
        }
        String methodName = method.getName();
        String fieldName = methodName.startsWith("get") && methodName.length() > 3 && Character.isUpperCase(methodName.charAt(3)) ? methodName.substring(3, 4).toLowerCase() + methodName.substring(4) : (methodName.startsWith("is") && methodName.length() > 2 && Character.isUpperCase(methodName.charAt(2)) ? methodName.substring(2, 3).toLowerCase() + methodName.substring(3) : null);
        if (fieldName != null) {
            try {
                return method.getDeclaringClass().getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
        }
        return null;
    }

    public static boolean isGetter(Method method) {
        return ReflectionGetterUtils.findFieldForGetter(method) != null;
    }
}

