/*
 * Decompiled with CFR 0.152.
 */
package com.vicpinm.autosubscription;

import android.app.Activity;
import android.app.Application;
import android.os.Bundle;
import com.vicpinm.autosubscription.UnsubscribeListener;
import com.vicpinm.autosubscription.anotations.AutoSubscription;
import io.reactivex.disposables.Disposable;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Set;

public class Unsubscriber {
    public static void with(Application application) {
        application.registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(){

            public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
            }

            public void onActivityStarted(Activity activity) {
            }

            public void onActivityResumed(Activity activity) {
            }

            public void onActivityPaused(Activity activity) {
            }

            public void onActivityStopped(Activity activity) {
            }

            public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
            }

            public void onActivityDestroyed(Activity activity) {
                Unsubscriber.unlink(activity);
            }
        });
    }

    public static void unlink(Object instance) {
        for (Field f : Unsubscriber.findUnsubscribeFields(instance.getClass())) {
            try {
                boolean accesibility = f.isAccessible();
                f.setAccessible(true);
                Object o = f.get(instance);
                if (o instanceof Disposable) {
                    ((Disposable)o).dispose();
                } else if (o instanceof UnsubscribeListener) {
                    ((UnsubscribeListener)o).onUnsubscribe();
                } else {
                    Unsubscriber.unlink(o);
                }
                f.setAccessible(accesibility);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    public static Set<Field> findUnsubscribeFields(Class c) {
        HashSet<Field> set = new HashSet<Field>();
        while (c != null) {
            for (Field field : c.getDeclaredFields()) {
                if (!field.isAnnotationPresent(AutoSubscription.class)) continue;
                set.add(field);
            }
            c = c.getSuperclass();
        }
        return set;
    }
}

