/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.vod;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.view.SurfaceView;
import com.vhall.android.exoplayer2.text.Cue;
import com.vhall.framework.VhallSDK;
import com.vhall.framework.connect.IVHService;
import com.vhall.framework.utils.FileUtil;
import com.vhall.logmanager.L;
import com.vhall.logmanager.LogInfo;
import com.vhall.logmanager.LogReporter;
import com.vhall.message.ConnectServer;
import com.vhall.player.Constants;
import com.vhall.player.MPlayer;
import com.vhall.player.VHPlayer;
import com.vhall.player.VHPlayerListener;
import com.vhall.player.stream.play.IVHAudioPlayer;
import com.vhall.player.stream.play.IVHVideoPlayer;
import com.vhall.player.vod.VodPlayer;
import com.vhall.player.vod.VodPlayerView;
import com.vhall.vod.VHVodApi;
import com.vhall.vod.datas.SrtSubtitle;
import com.vhall.vod.datas.SubtitleInfo;
import com.vhall.vod.decoders.SrtDecoder;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import javax.net.ssl.HttpsURLConnection;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Response;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class VHVodPlayer
implements VHPlayer,
IVHService {
    private static final String TAG = "VHVodPlayer";
    private MPlayer mPlayer;
    private Context mContext;
    private SurfaceView mSurfaceView;
    private VodPlayerView vodPlayerView;
    private String mRecordId = "";
    private String mAccessToken = "";
    private VHPlayerListener mListener;
    private Handler mDispatcher;
    private boolean mLoading = false;
    private boolean mInit = false;
    private String mDefaultURLS = "";
    private String mDispatchURL = "";
    private String mStreamType = "hls_domainname";
    private String waterMarkUrl = "";
    private int waterMarkGravity = 0;
    private float waterMarkAlpha = 1.0f;
    private String curePointUrl = "";
    private SubtitleInfo subtitleInfo;
    private SrtSubtitle srtSubtitle;
    private SubtitleCallback subtitleCallback;
    private SubtitleThread subtitleThread;
    private boolean subtitleReady = false;
    private boolean subtitleReset = false;
    private boolean enable_projection_screen = true;
    private String mCDNPriority = "";

    public String getChannelId() {
        return this.mRecordId;
    }

    public String getAccessToken() {
        return this.mAccessToken;
    }

    public void onConnectStateChanged(ConnectServer.State state, int serverType) {
    }

    public void onMessage(String msg) {
    }

    public VHVodPlayer(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("context must not null");
        }
        this.mContext = context;
        this.initPlayer();
        this.mDispatcher = new Handler(Looper.getMainLooper());
    }

    private void initPlayer() {
        if (this.mPlayer == null) {
            this.mPlayer = new MPlayer(this.mContext, 2);
            this.mPlayer.setListener(new VHPlayerListener(){

                public void onStateChanged(Constants.State state) {
                    switch (state) {
                        case START: {
                            VHVodPlayer.this.subtitleReset = false;
                        }
                    }
                    if (VHVodPlayer.this.mListener != null) {
                        VHVodPlayer.this.mListener.onStateChanged(state);
                    }
                }

                public void onEvent(int i, String s) {
                    if (VHVodPlayer.this.mListener != null) {
                        VHVodPlayer.this.mListener.onEvent(i, s);
                    }
                }

                public void onError(int i, int i1, String s) {
                    if (VHVodPlayer.this.mListener != null) {
                        VHVodPlayer.this.mListener.onError(i, i1, s);
                    }
                }
            });
        }
    }

    private void sendEvent(final int event, final String msg) {
        if (this.mListener != null) {
            this.mDispatcher.post(new Runnable(){

                @Override
                public void run() {
                    VHVodPlayer.this.mListener.onEvent(event, msg);
                }
            });
        }
    }

    private void sendError(final int event, final String msg) {
        if (this.mListener != null) {
            this.mDispatcher.post(new Runnable(){

                @Override
                public void run() {
                    VHVodPlayer.this.mListener.onError(event, 0, msg);
                }
            });
        }
    }

    public void init(final String recordId, final String token) {
        if (this.mPlayer == null) {
            this.initPlayer();
            if (this.mSurfaceView != null) {
                this.mPlayer.setDisplay(this.mSurfaceView);
            } else if (this.vodPlayerView != null) {
                this.mPlayer.setDisplay(this.vodPlayerView);
            }
        }
        this.mInit = false;
        if (this.mLoading) {
            return;
        }
        this.mLoading = true;
        VHVodApi.getWatchPlaybackInfo(recordId, token, new Callback(){

            public void onFailure(Call call, IOException e) {
                VHVodPlayer.this.mLoading = false;
                VHVodPlayer.this.trackInitEvent("-1");
                VHVodPlayer.this.sendError(-1, "error network,please try later\uff01");
            }

            public void onResponse(Call call, Response response) throws IOException {
                VHVodPlayer.this.mLoading = false;
                String result = response.body().string();
                if (VHVodPlayer.this.getData(result, recordId)) {
                    VHVodPlayer.this.mRecordId = recordId;
                    VHVodPlayer.this.mAccessToken = token;
                    if (!TextUtils.isEmpty((CharSequence)VHVodPlayer.this.curePointUrl) && VHVodPlayer.this.curePointUrl.endsWith("cuepoint.msg")) {
                        FileUtil.getCuePointFile((String)VHVodPlayer.this.curePointUrl, (Context)VHVodPlayer.this.mContext, (FileUtil.FileCallback)new FileUtil.FileCallback(){

                            public void onFile(File file) {
                                String baseUrl = VHVodPlayer.this.curePointUrl.substring(0, VHVodPlayer.this.curePointUrl.indexOf("/", VHVodPlayer.this.curePointUrl.indexOf("//") + 2));
                                VHVodPlayer.this.sendEvent(-259, VHVodPlayer.this.getUsrData(baseUrl, file));
                            }
                        });
                    }
                    if (VHVodPlayer.this.subtitleInfo != null) {
                        ArrayList<String> languages = new ArrayList<String>();
                        for (SubtitleInfo.SrtBean srtBean : ((VHVodPlayer)VHVodPlayer.this).subtitleInfo.srt) {
                            languages.add(srtBean.lang);
                        }
                        VHVodPlayer.this.sendEvent(-263, new JSONArray(languages).toString());
                        SubtitleInfo.SrtBean srtBean = VHVodPlayer.this.subtitleInfo.getCurrentSrt();
                        ((VHVodPlayer)VHVodPlayer.this).subtitleInfo.currentLang = srtBean.lang;
                        if (srtBean != null) {
                            FileUtil.getSubtitleFile((String)srtBean.url, (Context)VHVodPlayer.this.mContext, (FileUtil.FileCallback)new FileUtil.FileCallback(){

                                public void onFile(File file) {
                                    SrtDecoder srtDecoder = new SrtDecoder();
                                    String str = FileUtil.readFile2ByteArray((File)file);
                                    if (!TextUtils.isEmpty((CharSequence)str)) {
                                        VHVodPlayer.this.srtSubtitle = srtDecoder.decode(str.getBytes());
                                        VHVodPlayer.this.onSubtitleDecoded();
                                    }
                                }
                            });
                        }
                    }
                    VHVodPlayer.this.mInit = true;
                    VHVodPlayer.this.sendEvent(-256, "init success");
                    VHVodPlayer.this.initService();
                }
            }
        });
    }

    private void initService() {
        VhallSDK.getInstance().join((IVHService)this);
    }

    public void setSubtitle(String language) {
        if (language == this.subtitleInfo.currentLang) {
            return;
        }
        this.subtitleReady = false;
        this.subtitleThread = null;
        this.srtSubtitle = null;
        SubtitleInfo.SrtBean srtBean = this.subtitleInfo.getSrt(language);
        this.subtitleInfo.currentLang = srtBean.lang;
        if (srtBean != null) {
            FileUtil.getSubtitleFile((String)srtBean.url, (Context)this.mContext, (FileUtil.FileCallback)new FileUtil.FileCallback(){

                public void onFile(File file) {
                    SrtDecoder srtDecoder = new SrtDecoder();
                    String str = FileUtil.readFile2ByteArray((File)file);
                    if (!TextUtils.isEmpty((CharSequence)str)) {
                        VHVodPlayer.this.srtSubtitle = srtDecoder.decode(str.getBytes());
                        VHVodPlayer.this.onSubtitleDecoded();
                    }
                }
            });
        }
    }

    private void onSubtitleUI(final Cue cue) {
        if (this.subtitleCallback != null) {
            this.subtitleCallback.onSubtitle(cue == null ? null : cue.text.toString());
        }
        if (this.vodPlayerView != null && this.vodPlayerView.getSubtitleView() != null) {
            this.vodPlayerView.getSubtitleView().post(new Runnable(){

                @Override
                public void run() {
                    VHVodPlayer.this.vodPlayerView.getSubtitleView().setText((CharSequence)(cue == null ? "" : cue.text.toString()));
                }
            });
        }
    }

    private void onSubtitleDecoded() {
        this.subtitleReady = true;
        this.subtitleThread = new SubtitleThread();
        this.subtitleThread.start();
    }

    public void setSubtitleCallback(SubtitleCallback callback) {
        this.subtitleCallback = callback;
    }

    private String getUsrData(String baseUrl, File file) {
        if (file == null || file.length() <= 0L) {
            return null;
        }
        String dataStr = FileUtil.readFile2String((File)file);
        if (TextUtils.isEmpty((CharSequence)dataStr)) {
            return null;
        }
        if (dataStr.startsWith("\ufeff")) {
            dataStr = dataStr.substring(1);
        }
        try {
            JSONObject obj = new JSONObject(dataStr);
            JSONArray jsonArray = obj.optJSONArray("usrdata");
            if (jsonArray == null) {
                return null;
            }
            for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject jsonObject = (JSONObject)jsonArray.get(i);
                if (!jsonObject.has("picurl")) continue;
                jsonObject.put("picurl", (Object)(baseUrl + jsonObject.getString("picurl")));
            }
            return jsonArray.toString();
        }
        catch (JSONException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Constants.State getState() {
        if (this.mPlayer != null) {
            return this.mPlayer.getState();
        }
        return null;
    }

    public void setDisplay(SurfaceView surfaceView) {
        if (surfaceView == null) {
            return;
        }
        this.mSurfaceView = surfaceView;
        if (this.mPlayer != null) {
            this.mPlayer.setDisplay(this.mSurfaceView);
        }
    }

    public void setDisplay(VodPlayerView vodPlayerView) {
        if (vodPlayerView == null) {
            return;
        }
        this.vodPlayerView = vodPlayerView;
        if (this.mPlayer != null) {
            this.mPlayer.setDisplay(vodPlayerView);
        }
    }

    public void start() {
        if (this.mInit) {
            if (this.waterMarkGravity != 0 && this.vodPlayerView != null && this.vodPlayerView.getWaterMark() == null) {
                this.setWaterMark();
            }
            this.mPlayer.setLogParam(LogInfo.getInstance().toString());
            this.mPlayer.setStreamType(this.mStreamType);
            this.mPlayer.startPlay(this.mDispatchURL, this.mDefaultURLS, this.mCDNPriority);
        } else if (this.mListener != null) {
            this.mListener.onError(-2, 0, "\u8bf7\u5148\u521d\u59cb\u5316");
        }
    }

    public void prepare() {
        if (this.mInit) {
            if (this.waterMarkGravity != 0 && this.vodPlayerView != null && this.vodPlayerView.getWaterMark() == null) {
                this.setWaterMark();
            }
            this.mPlayer.setLogParam(LogInfo.getInstance().toString());
            this.mPlayer.setStreamType(this.mStreamType);
            this.mPlayer.prepare(this.mDispatchURL, this.mDefaultURLS);
        } else if (this.mListener != null) {
            this.mListener.onError(-2, 0, "\u8bf7\u5148\u521d\u59cb\u5316");
        }
    }

    public void startPlay(String s) {
        if (this.mPlayer != null) {
            this.mPlayer.startPlay(s);
        }
    }

    public void prepare(String streamUrl) {
        if (this.mPlayer != null) {
            this.mPlayer.prepare(streamUrl);
        }
    }

    public void stop() {
        if (this.mPlayer != null) {
            this.mPlayer.stop();
        }
    }

    public void pause() {
        if (this.mPlayer != null) {
            this.mPlayer.pause();
        }
    }

    public void resume() {
        if (this.mPlayer != null) {
            this.mPlayer.resume();
        }
    }

    public void release() {
        this.mInit = false;
        VhallSDK.getInstance().leave((IVHService)this);
        if (this.mPlayer != null) {
            this.mPlayer.release();
            this.mSurfaceView = null;
            this.vodPlayerView = null;
            this.mPlayer = null;
        }
    }

    public void seekto(long l) {
        if (this.mPlayer != null) {
            this.mPlayer.seekto(l);
        }
        this.subtitleReset = true;
    }

    public void mute() {
        this.mPlayer.mute();
    }

    public void unmute() {
        this.mPlayer.unmute();
    }

    public void addExtraLogParam(String s) {
        LogInfo.getInstance().setExtraData(s);
    }

    public void setLogParam(String s) {
    }

    public void setVideoPlayer(IVHVideoPlayer ivhVideoPlayer) {
    }

    public void setAudioPlayer(IVHAudioPlayer ivhAudioPlayer) {
    }

    public void setDPI(String dpi) {
        this.mPlayer.setDefinition(dpi);
    }

    public float setSpeed(float i) {
        if (this.mPlayer != null) {
            return this.mPlayer.setSpeed(i);
        }
        return 1.0f;
    }

    public long getPosition() {
        return this.mPlayer == null ? 0L : this.mPlayer.getPosition();
    }

    public long getDuration() {
        return this.mPlayer == null ? 0L : this.mPlayer.getDuration();
    }

    public boolean isPlaying() {
        return this.mPlayer.getState() == Constants.State.START;
    }

    public void setListener(VHPlayerListener vhPlayerListener) {
        this.mListener = vhPlayerListener;
    }

    public void setDrawMode(int i) {
        this.mPlayer.setDrawMode(i);
    }

    public boolean isFreeSeekAble() {
        if (this.mPlayer != null) {
            return this.mPlayer.isFreeSeekAble();
        }
        return true;
    }

    public void setFreeSeekAble(boolean isFree) {
        if (this.mPlayer != null) {
            this.mPlayer.setFreeSeekAble(isFree);
        }
    }

    public long getBufferedPosition() {
        if (this.mPlayer != null && this.mPlayer.mPlayer instanceof VodPlayer) {
            VodPlayer vodPlayer = (VodPlayer)this.mPlayer.mPlayer;
            return vodPlayer.getContentBufferedPosition();
        }
        return 0L;
    }

    public String getOriginalUrl() {
        if (this.mPlayer != null) {
            return this.mPlayer.getOriginalUrl();
        }
        return null;
    }

    private boolean getData(String json, String recordId) {
        boolean success = false;
        try {
            JSONObject result = new JSONObject(json);
            String msg = result.optString("msg");
            int code = result.optInt("code");
            if (code == 200) {
                JSONObject projectionScreen;
                String uri;
                int gravity;
                String serverTag;
                JSONObject server;
                JSONObject data = result.optJSONObject("data");
                JSONObject logObj = data.optJSONObject("log_info");
                this.curePointUrl = data.optString("cue_point");
                String defTag = data.has("safe_definition") && !data.isNull("safe_definition") ? "safe_definition" : "definition";
                String definition = data.optString(defTag);
                if (definition.isEmpty() || definition.equalsIgnoreCase("[]")) {
                    definition = data.optString("definition");
                }
                if (null == (server = data.optJSONObject(serverTag = data.has("safe_server") && !data.isNull("safe_server") ? "safe_server" : "default_server"))) {
                    server = data.optJSONObject("default_server");
                }
                String dispatch_server = data.optString("dispatch_server");
                JSONObject waterMark = data.optJSONObject("watermark");
                String url = waterMark.optString("url");
                if (!TextUtils.isEmpty((CharSequence)url)) {
                    this.waterMarkUrl = url;
                }
                if ((gravity = waterMark.optInt("position")) > 0) {
                    this.waterMarkGravity = gravity;
                }
                LogInfo.getInstance().roomId = recordId;
                if (logObj != null) {
                    LogInfo.getInstance().initBaseData(logObj);
                }
                if (!TextUtils.isEmpty((CharSequence)(uri = server.getString("uri")))) {
                    this.mStreamType = uri.endsWith(".mp4") ? "mp4_domainname" : "hls_domainname";
                }
                String rand = server.optString("rand");
                this.mDispatchURL = dispatch_server + "/api/dispatch_replay?webinar_id=" + VhallSDK.getInstance().getAPP_ID() + "&rand=" + rand + "&uid=id&uri=" + uri + "&quality=" + definition + "&bu=1";
                result.put("data", (Object)server);
                this.mDefaultURLS = result.toString();
                L.i((String)TAG, (String)("mDefaultURLS:" + this.mDefaultURLS));
                JSONObject subtitleObject = data.optJSONObject("subtitle_info");
                if (subtitleObject != null) {
                    this.subtitleInfo = new SubtitleInfo();
                    this.subtitleInfo.srt = new ArrayList<SubtitleInfo.SrtBean>();
                    JSONArray srtArray = subtitleObject.getJSONArray("srt");
                    for (int i = 0; i < srtArray.length(); ++i) {
                        JSONObject srtBeanObj = (JSONObject)srtArray.get(i);
                        SubtitleInfo.SrtBean srtBean = new SubtitleInfo.SrtBean();
                        srtBean.is_default = srtBeanObj.optInt("is_default");
                        srtBean.remark = srtBeanObj.optString("remark");
                        srtBean.lang = srtBeanObj.optString("lang");
                        if (!TextUtils.isEmpty((CharSequence)srtBean.remark)) {
                            srtBean.lang = srtBean.remark + "_" + srtBean.lang;
                        }
                        srtBean.url = srtBeanObj.optString("url");
                        this.subtitleInfo.srt.add(srtBean);
                    }
                }
                if ((projectionScreen = data.optJSONObject("projection_screen")) != null) {
                    this.enable_projection_screen = projectionScreen.optBoolean("enable", true);
                }
                this.mCDNPriority = data.optString("cdn_priority", "");
                success = true;
                this.trackInitEvent();
            } else {
                this.trackInitEvent(code + ":" + msg);
                this.sendError(-1, msg);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.trackInitEvent("-2");
            this.sendError(-1, e.getMessage());
        }
        return success;
    }

    public String getCurePoint() {
        return this.curePointUrl;
    }

    public boolean getProjectionScreen() {
        return this.enable_projection_screen;
    }

    public void setWaterMark(String url, int gravity, float alpha) {
        if (!TextUtils.isEmpty((CharSequence)url)) {
            this.waterMarkUrl = url;
        }
        if (gravity > 0) {
            this.waterMarkGravity = gravity;
        }
        this.waterMarkAlpha = alpha;
    }

    private void setWaterMark() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    URL url = new URL(VHVodPlayer.this.waterMarkUrl);
                    HttpURLConnection conn = VHVodPlayer.this.waterMarkUrl.contains("https") ? (HttpsURLConnection)url.openConnection() : (HttpURLConnection)url.openConnection();
                    conn.setConnectTimeout(5000);
                    conn.setReadTimeout(5000);
                    Bitmap bitmap = BitmapFactory.decodeStream((InputStream)conn.getInputStream());
                    BitmapDrawable drawable = new BitmapDrawable(VHVodPlayer.this.mContext.getResources(), bitmap);
                    VHVodPlayer.this.mDispatcher.post(new Runnable((Drawable)drawable){
                        final /* synthetic */ Drawable val$drawable;
                        {
                            this.val$drawable = drawable;
                        }

                        @Override
                        public void run() {
                            if (VHVodPlayer.this.vodPlayerView != null && VHVodPlayer.this.vodPlayerView.getWaterMark() == null) {
                                VHVodPlayer.this.vodPlayerView.setWaterMark(this.val$drawable);
                                VHVodPlayer.this.vodPlayerView.setWaterMarkAlpha(VHVodPlayer.this.waterMarkAlpha);
                                switch (VHVodPlayer.this.waterMarkGravity) {
                                    case 1: {
                                        VHVodPlayer.this.vodPlayerView.setWaterMarkGravity(3);
                                        break;
                                    }
                                    case 2: {
                                        VHVodPlayer.this.vodPlayerView.setWaterMarkGravity(5);
                                        break;
                                    }
                                    case 3: {
                                        VHVodPlayer.this.vodPlayerView.setWaterMarkGravity(85);
                                        break;
                                    }
                                    case 4: {
                                        VHVodPlayer.this.vodPlayerView.setWaterMarkGravity(83);
                                    }
                                }
                            }
                        }
                    });
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }).start();
    }

    private void trackInitEvent(String error) {
        JSONObject params = new JSONObject();
        try {
            params.put("recordId", (Object)this.mRecordId);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        LogReporter.getInstance().setErr(error);
        LogReporter.getInstance().onCollection("2004", false, params);
    }

    private void trackInitEvent() {
        JSONObject params = new JSONObject();
        try {
            params.put("recordId", (Object)this.mRecordId);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        LogReporter.getInstance().onCollection("2004", params);
    }

    private class SubtitleThread
    extends Thread {
        private int index = -1;
        private long nextTime = -1L;
        private boolean notifyUI = false;

        private SubtitleThread() {
        }

        @Override
        public void run() {
            super.run();
            block0: while (VHVodPlayer.this.subtitleReady) {
                if ((VHVodPlayer.this.vodPlayerView == null || VHVodPlayer.this.vodPlayerView.getSubtitleView() == null) && VHVodPlayer.this.subtitleCallback == null || VHVodPlayer.this.mPlayer == null) continue;
                if (VHVodPlayer.this.subtitleReset) {
                    this.index = -1;
                    this.nextTime = -1L;
                    if (this.notifyUI) continue;
                    this.notifyUI = true;
                    VHVodPlayer.this.onSubtitleUI(null);
                    continue;
                }
                long playerTime = VHVodPlayer.this.mPlayer.getPosition();
                if (this.index == -1) {
                    this.notifyUI = false;
                    if (playerTime < ((VHVodPlayer)VHVodPlayer.this).srtSubtitle.times[0]) {
                        this.index = 0;
                        this.nextTime = ((VHVodPlayer)VHVodPlayer.this).srtSubtitle.times[0];
                        VHVodPlayer.this.onSubtitleUI(null);
                        continue;
                    }
                    for (int i = 0; i < ((VHVodPlayer)VHVodPlayer.this).srtSubtitle.count - 1; ++i) {
                        if (playerTime < ((VHVodPlayer)VHVodPlayer.this).srtSubtitle.times[i] || playerTime >= ((VHVodPlayer)VHVodPlayer.this).srtSubtitle.times[i + 1]) continue;
                        this.index = i;
                        this.nextTime = ((VHVodPlayer)VHVodPlayer.this).srtSubtitle.times[i + 1];
                        if (VHVodPlayer.this.srtSubtitle == null) continue block0;
                        Cue cue = ((VHVodPlayer)VHVodPlayer.this).srtSubtitle.cues[this.index];
                        VHVodPlayer.this.onSubtitleUI(cue);
                        continue block0;
                    }
                    continue;
                }
                if (VHVodPlayer.this.srtSubtitle == null || playerTime < this.nextTime || VHVodPlayer.this.srtSubtitle == null) continue;
                Cue cue = ((VHVodPlayer)VHVodPlayer.this).srtSubtitle.cues[this.index];
                VHVodPlayer.this.onSubtitleUI(cue);
                if (this.index < ((VHVodPlayer)VHVodPlayer.this).srtSubtitle.count - 1) {
                    ++this.index;
                }
                this.nextTime = ((VHVodPlayer)VHVodPlayer.this).srtSubtitle.times[this.index];
            }
        }
    }

    public static interface SubtitleCallback {
        public void onSubtitle(String var1);
    }
}

