/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.ops;

import android.text.TextUtils;
import com.vhall.framework.VHAPI;
import com.vhall.framework.VhallSDK;
import java.io.File;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.FormBody;
import okhttp3.MultipartBody;
import okhttp3.Request;
import okhttp3.RequestBody;

public class VHOPSApi {
    private static final String TAG = "VHOPSApi";
    public static final String TYPE_DOCUMENT = "service_document";
    private static String formatter = "%s?k=%s&id=%s&s=%s&bu=%d&token=%s";

    public static void sendDocumentMsg(String content, String accessToken, String channelId, String roomid, Callback callback) {
        FormBody.Builder builder = VHAPI.getBaseBuilder((String)accessToken).add("body", content).add("type", TYPE_DOCUMENT).add("channel_id", channelId);
        if (!TextUtils.isEmpty((CharSequence)roomid)) {
            builder.add("room_id", roomid);
        }
        Call call = VHAPI.getOkHttpClient().newCall(VHAPI.getRequest((String)"v2/document/send", (RequestBody)builder.build()));
        if (callback == null) {
            call.enqueue((Callback)new VHAPI.DefaultCallback());
        } else {
            call.enqueue(callback);
        }
    }

    public static void getWatchDoc(String channelId, String accessToken, Callback callback) {
        FormBody.Builder builder = VHAPI.getBaseBuilder((String)accessToken).add("channel_id", channelId);
        Call call = VHAPI.getOkHttpClient().newCall(VHAPI.getRequest((String)"v2/document/get-watch-info", (RequestBody)builder.build()));
        if (callback == null) {
            call.enqueue((Callback)new VHAPI.DefaultCallback());
        } else {
            call.enqueue(callback);
        }
    }

    protected static void getDocInfo(String documentId, String accessToken, Callback callback) {
        FormBody.Builder builder = VHAPI.getBaseBuilder((String)accessToken).add("document_id", documentId);
        Call call = VHAPI.getOkHttpClient().newCall(VHAPI.getRequest((String)"v2/document/get-info", (RequestBody)builder.build()));
        if (callback == null) {
            call.enqueue((Callback)new VHAPI.DefaultCallback());
        } else {
            call.enqueue(callback);
        }
    }

    public static void sendSpecial(String roomId, String channelId, String accessToken, Callback callback) {
        FormBody.Builder builder = VHAPI.getBaseBuilder((String)accessToken).add("room_id", roomId).add("channel_id", channelId);
        Call call = VHAPI.getOkHttpClient().newCall(VHAPI.getRequest((String)"v2/message/send-special", (RequestBody)builder.build()));
        if (callback == null) {
            call.enqueue((Callback)new VHAPI.DefaultCallback());
        } else {
            call.enqueue(callback);
        }
    }

    protected static void docGetLogInfo(String accessToken, Callback callback) {
        FormBody.Builder builder = VHAPI.getBaseBuilder((String)accessToken);
        Call call = VHAPI.getOkHttpClient().newCall(VHAPI.getRequest((String)"v2/document/get-log-info", (RequestBody)builder.build()));
        if (callback == null) {
            call.enqueue((Callback)new VHAPI.DefaultCallback());
        } else {
            call.enqueue(callback);
        }
    }

    public static void resetWatchInfo(String channelId, String accessToken, Callback callback) {
        FormBody.Builder builder = VHAPI.getBaseBuilder((String)accessToken).add("channel_id", channelId);
        Call call = VHAPI.getOkHttpClient().newCall(VHAPI.getRequest((String)"v2/document/reset-watch-info", (RequestBody)builder.build()));
        if (callback == null) {
            call.enqueue((Callback)new VHAPI.DefaultCallback());
        } else {
            call.enqueue(callback);
        }
    }

    protected static void uploadLog(String k, String id, String s, int bu, String token) {
        String url = String.format(formatter, VhallSDK.getInstance().mLogHost, k, id, s, bu, token);
        Request request = new Request.Builder().url(url).build();
        VHAPI.getOkHttpClient().newCall(request).enqueue((Callback)new VHAPI.DefaultCallback());
    }

    protected static void upload(String filePath, String rename, String accessToken, VHAPI.ProgressRequestBody.ProgressListener listener, Callback callback) {
        File file = new File(filePath);
        String fileName = TextUtils.isEmpty((CharSequence)rename) ? file.getName() : rename;
        MultipartBody.Builder builder = VHAPI.getMultipartBodyBuild((String)accessToken).addFormDataPart("document", fileName, (RequestBody)new VHAPI.ProgressRequestBody("application/octet-stream", file, listener));
        Call call = VHAPI.getOkHttpClient().newCall(VHAPI.getRequest((String)"v2/document/upload", (RequestBody)builder.build()));
        if (callback == null) {
            call.enqueue((Callback)new VHAPI.DefaultCallback());
        } else {
            call.enqueue(callback);
        }
    }
}

