package com.vhall.ops;

import android.text.TextUtils;
import android.util.Log;

import com.vhall.framework.VHAPI;
import com.vhall.framework.VhallSDK;

import java.io.File;

import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.FormBody;
import okhttp3.MultipartBody;
import okhttp3.Request;

import static com.vhall.framework.VHAPI.getBaseBuilder;
import static com.vhall.framework.VHAPI.getMultipartBodyBuild;
import static com.vhall.framework.VHAPI.getOkHttpClient;
import static com.vhall.framework.VHAPI.getRequest;

/**
 * Created by zwp on 2019/7/18
 */
public class VHOPSApi {
    private static final String TAG = "VHOPSApi";
    //    public static final String TYPE_DOCUMENT = "Document";
    public static final String TYPE_DOCUMENT = "service_document";

    public static void sendDocumentMsg(String content, String accessToken, String channelId, String roomid, Callback callback) {
        FormBody.Builder builder = getBaseBuilder(accessToken)
                .add("body", content)
                .add("type", TYPE_DOCUMENT)
                .add("channel_id", channelId);
        if (!TextUtils.isEmpty(roomid))
            builder.add("room_id", roomid);
        Call call = getOkHttpClient().newCall(getRequest("v2/document/send", builder.build()));
        if (callback == null)
            call.enqueue(new VHAPI.DefaultCallback());
        else
            call.enqueue(callback);
    }


    /**
     * 获取频道当前演示文档信息（多文档）
     *
     * @param channelId
     * @param accessToken
     * @param callback
     */
    public static void getWatchDoc(String channelId, String accessToken, Callback callback) {
        FormBody.Builder builder = getBaseBuilder(accessToken)
                .add("channel_id", channelId);
        Call call = getOkHttpClient().newCall(getRequest("v2/document/get-watch-info", builder.build()));
        if (callback == null)
            call.enqueue(new VHAPI.DefaultCallback());
        else
            call.enqueue(callback);
    }

    /**
     * 获取文档信息
     *
     * @param documentId
     * @param accessToken
     * @param callback
     */
    protected static void getDocInfo(String documentId, String accessToken, Callback callback) {
        FormBody.Builder builder = getBaseBuilder(accessToken)
                .add("document_id", documentId);
        Call call = getOkHttpClient().newCall(getRequest("v2/document/get-info", builder.build()));
        if (callback == null)
            call.enqueue(new VHAPI.DefaultCallback());
        else
            call.enqueue(callback);
    }


    /**
     * 断流消息重推
     *
     * @param roomId      直播id
     * @param channelId   文档id
     * @param accessToken
     * @param callback
     */
    public static void sendSpecial(String roomId, String channelId, String accessToken, Callback callback) {
        FormBody.Builder builder = getBaseBuilder(accessToken)
                .add("room_id", roomId)
                .add("channel_id", channelId);
        Call call = getOkHttpClient().newCall(getRequest("v2/message/send-special", builder.build()));
        if (callback == null) {
            call.enqueue(new VHAPI.DefaultCallback());
        } else {
            call.enqueue(callback);
        }
    }


    /**
     * 获取日志上报字符串
     *
     * @param accessToken
     * @param callback
     */
    protected static void docGetLogInfo(String accessToken, Callback callback) {
        FormBody.Builder builder = getBaseBuilder(accessToken);
        Call call = getOkHttpClient().newCall(getRequest("v2/document/get-log-info", builder.build()));
        if (callback == null)
            call.enqueue(new VHAPI.DefaultCallback());
        else
            call.enqueue(callback);
    }

    /**
     * 文档演示重置
     */
    public static void resetWatchInfo(String channelId, String accessToken, Callback callback) {
        FormBody.Builder builder = getBaseBuilder(accessToken)
                .add("channel_id", channelId);
        Call call = getOkHttpClient().newCall(getRequest("v2/document/reset-watch-info", builder.build()));
        if (callback == null)
            call.enqueue(new VHAPI.DefaultCallback());
        else
            call.enqueue(callback);
    }

    private static String formatter = "%s?k=%s&id=%s&s=%s&bu=%d&token=%s";

    /**
     * @param k     日志key值
     * @param id    纪录标识
     * @param s     sessionid
     * @param bu    business unit （paas=1， saas=0, edu=2）
     * @param token
     */
    protected static void uploadLog(String k, String id, String s, int bu, String token) {
//        String defURL = TextUtils.isEmpty(VhallSDK.getInstance().mLogHost) ? DEFAULT_LOG_URL : VhallSDK.getInstance().mLogHost;
        String url = String.format(formatter, VhallSDK.getInstance().mLogHost, k, id, s, bu, token);
        Request request = new Request.Builder().url(url).build();
        getOkHttpClient().newCall(request).enqueue(new VHAPI.DefaultCallback());
    }


    /**
     * 文件上传
     *
     * @param filePath
     * @param accessToken
     * @param listener
     * @param callback
     */
    protected static void upload(String filePath, String rename, String accessToken, VHAPI.ProgressRequestBody.ProgressListener listener, Callback callback) {
        File file = new File(filePath);
        String fileName;
        if (TextUtils.isEmpty(rename)) {
            fileName = file.getName();
        } else {
            fileName = rename;
        }
        MultipartBody.Builder builder = getMultipartBodyBuild(accessToken)
                .addFormDataPart("document", fileName, new VHAPI.ProgressRequestBody("application/octet-stream", file, listener));

        Call call = getOkHttpClient().newCall(getRequest("v2/document/upload", builder.build()));

        if (callback == null) {
            call.enqueue(new VHAPI.DefaultCallback());
        } else {
            call.enqueue(callback);
        }
    }
}
