/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.ims;

import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import com.vhall.framework.VHAPI;
import com.vhall.framework.VhallSDK;
import com.vhall.framework.connect.IVHService;
import com.vhall.framework.connect.VhallConnectService;
import com.vhall.ims.VHIMApi;
import com.vhall.ims.message.IVHMessage;
import com.vhall.logmanager.L;
import com.vhall.logmanager.LogReporter;
import com.vhall.message.ConnectServer;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.List;
import okhttp3.Call;
import okhttp3.Response;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class VHIM
implements IVHService {
    private static final String TAG = "VHIM";
    private String mChannelId;
    private String mAccessToken;
    private OnMessageListener mMessageListener;
    private VhallConnectService.OnConnectStateChangedListener mOnConnectChangedListener;
    private Handler mHandler;
    public static final String TYPE_CUSTOM = "service_custom";
    public static final String TYPE_CHAT = "service_im";
    public static final String TYPE_ONLINE = "service_online";
    public static final String TYPE_JOIN = "Join";
    public static final String TYPE_LEAVE = "Leave";
    public static final String TYPE_TEXT = "text";
    public static final String TYPE_IMAGE = "image";
    public static final String TYPE_LINK = "link";
    public static final String TYPE_VIDEO = "video";
    public static final String TYPE_VOICE = "voice";
    public static final String TYPE_DISABLE = "disable";
    public static final String TYPE_DISABLE_ALL = "disable_all";
    public static final String TYPE_PERMIT = "permit";
    public static final String TYPE_PERMIT_ALL = "permit_all";

    public void setOnMessageListener(OnMessageListener listener) {
        this.mMessageListener = listener;
    }

    public void setOnConnectChangedListener(VhallConnectService.OnConnectStateChangedListener listener) {
        this.mOnConnectChangedListener = listener;
    }

    public VHIM(String channelId, String accessToken) {
        this.mChannelId = channelId;
        this.mAccessToken = accessToken;
        this.mHandler = new Handler(Looper.getMainLooper());
        this.trackInitEvent();
    }

    public boolean join() {
        return VhallSDK.getInstance().join((IVHService)this);
    }

    public boolean leave() {
        this.mMessageListener = null;
        this.mOnConnectChangedListener = null;
        return VhallSDK.getInstance().leave((IVHService)this);
    }

    public String getChannelId() {
        return this.mChannelId;
    }

    public String getAccessToken() {
        return this.mAccessToken;
    }

    public void onConnectStateChanged(ConnectServer.State state, int serverType) {
        if (this.mOnConnectChangedListener != null) {
            this.mOnConnectChangedListener.onStateChanged(state, serverType);
        }
    }

    public void onMessage(String msg) {
        if (TextUtils.isEmpty((CharSequence)msg)) {
            return;
        }
        try {
            JSONObject obj = new JSONObject(msg);
            String textStr = obj.optString(TYPE_TEXT);
            if (!TextUtils.isEmpty((CharSequence)textStr)) {
                msg = URLDecoder.decode(textStr);
            }
            L.e((String)TAG, (String)("onMessage: " + msg));
            JSONObject msgObj = new JSONObject(msg);
            if (this.mMessageListener != null) {
                if (msgObj.has("event") && msgObj.optString("event").equals(TYPE_JOIN)) {
                    this.mMessageListener.onChannelStatus(msg);
                } else if (!"service_document".equals(msgObj.optString("service_type"))) {
                    this.mMessageListener.onMessage(msg);
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public void sendMsg(String msg, Callback callback) {
        JSONObject obj = new JSONObject();
        try {
            obj.put("type", (Object)TYPE_TEXT);
            obj.put("text_content", (Object)msg);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        VHAPI.sendMsg((String)obj.toString(), (String)this.mAccessToken, (String)TYPE_CHAT, (String)this.mChannelId, (String)"", (okhttp3.Callback)new SendCallback(callback));
    }

    public void sendMsg(IVHMessage message, Callback callback) {
        if (message.getBody() != null) {
            String accessToken = message.getAccessToken();
            String channelId = message.getChannelId();
            VHAPI.sendMsg((String)message.getBody().getBodyStr(), (String)(TextUtils.isEmpty((CharSequence)accessToken) ? this.mAccessToken : accessToken), (String)message.getMessageType(), (String)(TextUtils.isEmpty((CharSequence)channelId) ? this.mChannelId : channelId), (String)message.getRoomId(), (String)message.getNoAudit(), (String)message.getContext(), (okhttp3.Callback)new SendCallback(callback));
        } else {
            L.e((String)TAG, (String)"body is null,please check your message ");
        }
    }

    public void sendMsgWithContext(String msg, String context, Callback callback) {
        this.sendMsg(msg, TYPE_CHAT, context, callback);
    }

    public void sendMsg(String msg, String type, String context, Callback callback) {
        JSONObject obj = new JSONObject();
        try {
            if (!TextUtils.isEmpty((CharSequence)type)) {
                obj.put("type", (Object)type);
            } else {
                obj.put("type", (Object)TYPE_TEXT);
            }
            switch (type) {
                case "text": {
                    obj.put("text_content", (Object)msg);
                    break;
                }
                case "image": {
                    obj.put("image_url", (Object)msg);
                    break;
                }
                case "link": {
                    obj.put("link_url", (Object)msg);
                    break;
                }
                case "video": {
                    obj.put("video_url", (Object)msg);
                    break;
                }
                case "voice": {
                    obj.put("voice_url", (Object)msg);
                    break;
                }
                case "disable": {
                    obj.put("target_id", (Object)msg);
                    break;
                }
                case "disable_all": {
                    break;
                }
                case "permit": {
                    obj.put("target_id", (Object)msg);
                    break;
                }
                case "permit_all": {
                    break;
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        if (TextUtils.isEmpty((CharSequence)context)) {
            VHAPI.sendMsg((String)obj.toString(), (String)this.mAccessToken, (String)TYPE_CHAT, (String)this.mChannelId, (String)"", (okhttp3.Callback)new SendCallback(callback));
        } else {
            VHAPI.sendMsg((String)obj.toString(), (String)this.mAccessToken, (String)TYPE_CHAT, (String)this.mChannelId, (String)"", (String)"0", (String)context, (okhttp3.Callback)new SendCallback(callback));
        }
    }

    public void sendMsg(String msg, String type, Callback callback) {
        this.sendMsg(msg, type, "", callback);
    }

    public void sendImageText(String text, List<String> imageUrls, Callback callback) {
        JSONObject obj = new JSONObject();
        try {
            JSONArray array = new JSONArray(imageUrls);
            obj.put("type", (Object)TYPE_IMAGE);
            obj.put("text_content", (Object)text);
            obj.put("image_urls", (Object)array);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        VHAPI.sendMsg((String)obj.toString(), (String)this.mAccessToken, (String)TYPE_CHAT, (String)this.mChannelId, (String)"", (okhttp3.Callback)new SendCallback(callback));
    }

    public void sendCustomMsg(String data, Callback callback) {
        VHAPI.sendMsg((String)data, (String)this.mAccessToken, (String)TYPE_CUSTOM, (String)this.mChannelId, (String)"", (okhttp3.Callback)new SendCallback(callback));
    }

    public void setChannelMsg(String type, String targetId, Callback callback) {
        VHIMApi.setChannel(this.mChannelId, type, targetId, this.mAccessToken, new SendCallback(callback));
    }

    public void getUserList(int curPage, int pageSize, ResultCallback callback) {
        VHIMApi.getUserIdList(this.mChannelId, this.mAccessToken, curPage, pageSize, new GetCallback(callback));
    }

    public void getHistoryList(String type, int curPage, int pageSize, String filterStatus, String startTime, String endTime, String msgType, String auditStatus, ResultCallback callback) {
        VHIMApi.getHistoryList(this.mChannelId, type, curPage, pageSize, filterStatus, startTime, endTime, msgType, auditStatus, this.mAccessToken, new GetCallback(callback));
    }

    private void trackInitEvent() {
        JSONObject params = new JSONObject();
        try {
            params.put("channelId", (Object)this.mChannelId);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        LogReporter.getInstance().onCollection("2006", params);
    }

    private class GetCallback
    implements okhttp3.Callback {
        private ResultCallback callback;

        public GetCallback(ResultCallback callback) {
            this.callback = callback;
        }

        public void onFailure(Call call, IOException e) {
            if (this.callback != null) {
                VHIM.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        GetCallback.this.callback.onFailure(-1, "error network,please try later\uff01");
                    }
                });
            }
        }

        public void onResponse(Call call, Response response) throws IOException {
            if (this.callback != null) {
                final String result = response.body().string();
                VHIM.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (!TextUtils.isEmpty((CharSequence)result)) {
                            try {
                                JSONObject resultObj = new JSONObject(result);
                                int code = resultObj.optInt("code");
                                JSONObject data = resultObj.optJSONObject("data");
                                if (code == 200) {
                                    GetCallback.this.callback.onSuccess(data.toString());
                                } else {
                                    String msg = resultObj.optString("msg");
                                    GetCallback.this.callback.onFailure(code, msg);
                                }
                            }
                            catch (JSONException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                });
            }
        }
    }

    private class SendCallback
    implements okhttp3.Callback {
        private Callback callback;

        public SendCallback(Callback callback) {
            this.callback = callback;
        }

        public void onFailure(Call call, IOException e) {
            if (this.callback != null) {
                VHIM.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        SendCallback.this.callback.onFailure(-1, "error network,please try later\uff01");
                    }
                });
            }
        }

        public void onResponse(Call call, Response response) throws IOException {
            if (this.callback != null) {
                final String result = response.body().string();
                VHIM.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (!TextUtils.isEmpty((CharSequence)result)) {
                            try {
                                JSONObject resultObj = new JSONObject(result);
                                int code = resultObj.optInt("code");
                                if (code == 200) {
                                    SendCallback.this.callback.onSuccess();
                                } else {
                                    String msg = resultObj.optString("msg");
                                    SendCallback.this.callback.onFailure(code, msg);
                                }
                            }
                            catch (JSONException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                });
            }
        }
    }

    public static interface ResultCallback {
        public void onSuccess(String var1);

        public void onFailure(int var1, String var2);
    }

    public static interface OnMessageListener {
        public void onMessage(String var1);

        public void onChannelStatus(String var1);
    }

    public static interface Callback {
        public void onSuccess();

        public void onFailure(int var1, String var2);
    }
}

