package com.vhall.ims.message;


import com.vhall.framework.VhallSDK;
import com.vhall.ims.VHIM;

public interface IVHMessage {

    IBody getBody();


    String getAccessToken();

    /**
     * 消息类型
     * @see VHIM#TYPE_CUSTOM VHIM#TYPE_CHAT VHIM#TYPE_ONLINE VHIM#TYPE_JOIN VHIM#TYPE_LEAVE
     * @return
     */
    String getMessageType();

    //消息渠道id
    String getChannelId();

    String getRoomId();

    //是否只能审核 "0"  "1"
    String getNoAudit();

    //上下文信息
    String getContext();



    class Builder{
        private IBody IBody;
        private String accessToken;
        private String messageType = VHIM.TYPE_CHAT;
        private String channelId;
        private String roomId = "";
        private String noAudit = "0";
        private String context = VhallSDK.getInstance().getmUserInfo();


        /**
         * 设置消息相关内容
         * @param IBody
         * @return
         */
        public Builder setIBody(IBody IBody) {
            this.IBody = IBody;
            return this;
        }

        /**
         * 访问token 可以不填写
         * @param accessToken
         * @return
         */
        public Builder setAccessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }
        /**
         * 消息类型
         * @param messageType 消息类型
         * @see VHIM#TYPE_CUSTOM VHIM#TYPE_CHAT VHIM#TYPE_ONLINE VHIM#TYPE_JOIN VHIM#TYPE_LEAVE
         * @return
         */
        public Builder setMessageType(String messageType) {
            this.messageType = messageType;
            return this;
        }

        /**
         * ch_chatid 渠道id 可以不填写
         * @param channelId
         * @return
         */
        public Builder setChannelId(String channelId) {
            this.channelId = channelId;
            return this;
        }

        /**
         * 房间ID
         * @param roomId
         * @return
         */
        public Builder setRoomId(String roomId) {
            this.roomId = roomId;
            return this;
        }

        /**
         * 是否开启消息智能审核
         * @param noAudit
         * @return
         */
        public Builder setNoAudit(String noAudit) {
            this.noAudit = noAudit;
            return this;
        }

        /**
         * 设置上下文信息
         * @param context
         * @return
         */
        public Builder setContext(String context) {
            this.context = context;
            return this;
        }


        public IVHMessage build(){
            return new IVHMessage(){
                @Override
                public IBody getBody() {
                    return IBody;
                }

                @Override
                public String getAccessToken() {
                    return accessToken;
                }

                @Override
                public String getMessageType() {
                    return messageType;
                }

                @Override
                public String getChannelId() {
                    return channelId;
                }

                @Override
                public String getRoomId() {
                    return roomId;
                }

                @Override
                public String getNoAudit() {
                    return noAudit;
                }

                @Override
                public String getContext() {
                    return context;
                }
            };
        }
    }












}
