package com.vhall.ims.message;

import android.text.TextUtils;
import com.vhall.ims.VHIM;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.List;

//消息体
public interface IBody {

    //定义消息类型
    String TYPE_KEY = "type";
    //文本语句
    String TEXT_CONTENT_KEY = "text_content";
    //图片链接
    String IMAGE_URL_KEY = "image_url";
    //多张图片 通过传递jsonArray 实现
    String IMAGE_URLS_KEY = "image_urls";
    //链接地址
    String LINK_URL_KEY = "link_url";
    //视频链接
    String VIDEO_URL_KEY = "video_url";
    //语音链接
    String VOICE_URL_KEY = "voice_url";
    //userId
    String TARGET_ID_KEY = "target_id";

    //消息类型
    String getType();

    //文字相关
    String getTextContent();

    //图片
    String getImageUrl();

    List<String> getImageUrls();

    //链接
    String getLinkUrl();

    //视频
    String getVideoUrl();

    //获取语音
    String getVoiceUrl();

    //目标userId
    String getTargetId();

    String getBodyStr();


    class Builder{
        private String type = VHIM.TYPE_TEXT;
        private String textContent;
        private String imageUrl;
        private List<String> imageUrls;
        private String linkUrl;
        private String videoUrl;
        private String voiceUrl;
        private String targetId;

        /**
         *
         * @see VHIM#TYPE_TEXT,VHIM#TYPE_IMAGE,VHIM#TYPE_LINK ...
         * @param type 消息体类型
         * @return
         */
        public Builder setType(String type){
            this.type = type;
            return this;
        }

        public Builder setTextContent(String textContent) {
            this.textContent = textContent;
            return this;
        }

        public Builder setImageUrl(String imageUrl) {
            this.imageUrl = imageUrl;
            return this;
        }

        public Builder setImageUrls(List<String> imageUrls) {
            if(this.imageUrls == null){
                this.imageUrls = new ArrayList<>();
            }
            if(imageUrls != null && imageUrls.size() > 0){
                this.imageUrls.addAll(imageUrls);
            }
            return this;
        }

        public Builder setLinkUrl(String linkUrl) {
            this.linkUrl = linkUrl;
            return this;
        }

        public Builder setVideoUrl(String videoUrl) {
            this.videoUrl = videoUrl;
            return this;
        }

        public Builder setVoiceUrl(String voiceUrl) {
            this.voiceUrl = voiceUrl;
            return this;
        }

        public Builder setTargetId(String targetId) {
            this.targetId = targetId;
            return this;
        }

        public IBody build(){
            return new IBody(){
                @Override
                public String getType() {
                    return type;
                }

                @Override
                public String getTextContent() {
                    return textContent;
                }

                @Override
                public String getImageUrl() {
                    return imageUrl;
                }

                @Override
                public List<String> getImageUrls() {
                    return imageUrls;
                }

                @Override
                public String getLinkUrl() {
                    return linkUrl;
                }

                @Override
                public String getVideoUrl() {
                    return videoUrl;
                }

                @Override
                public String getVoiceUrl() {
                    return voiceUrl;
                }

                @Override
                public String getTargetId() {
                    return targetId;
                }

                @Override
                public String getBodyStr() {
                    return toBodyJsonStr();
                }
            };
        }
        public String toBodyJsonStr(){
            JSONObject message = new JSONObject();
            try {
                if(TextUtils.isEmpty(type)){
                    message.put(TYPE_KEY,VHIM.TYPE_TEXT);
                }else{
                    message.put(TYPE_KEY,type);
                }

                if(!TextUtils.isEmpty(textContent)){
                    message.put(TEXT_CONTENT_KEY,textContent);
                }
                if(!TextUtils.isEmpty(imageUrl)){
                    message.put(IMAGE_URL_KEY,imageUrl);
                }
                if(imageUrls!=null && imageUrls.size()>0){
                    JSONArray array = new JSONArray();
                    for (String url:imageUrls){
                        array.put(url);
                    }
                    message.put(IMAGE_URLS_KEY,array);
                }
                if(!TextUtils.isEmpty(linkUrl)){
                    message.put(LINK_URL_KEY,linkUrl);
                }
                if(!TextUtils.isEmpty(videoUrl)){
                    message.put(VIDEO_URL_KEY,videoUrl);
                }
                if(!TextUtils.isEmpty(voiceUrl)){
                    message.put(VOICE_URL_KEY,voiceUrl);
                }
                if(!TextUtils.isEmpty(targetId)){
                    message.put(TARGET_ID_KEY,targetId);
                }
            } catch (JSONException e) {
                e.printStackTrace();
            }
            return message.toString();
        }
    }

}