/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.rtc.vrtc;

import android.content.Context;
import android.media.projection.MediaProjection;
import android.text.TextUtils;
import android.view.SurfaceView;
import com.vhall.framework.common.ICallback;
import com.vhall.ilss.VHRoomListener;
import com.vhall.logmanager.VLog;
import com.vhall.rtc.Utils;
import com.vhall.rtc.VRTCParams;
import com.vhall.rtc.VhallRTC;
import com.vhall.rtc.absrtc.ISwitchFocusModeListener;
import com.vhall.rtc.absrtc.IVHRTC;
import com.vhall.rtc.absrtc.IVHRTCRenderView;
import com.vhall.rtc.vrtc.VRTCVideoEncodeCompat;
import com.vhall.vhallrtc.client.FinishCallback;
import com.vhall.vhallrtc.client.IFocusModeChangeListener;
import com.vhall.vhallrtc.client.Room;
import com.vhall.vhallrtc.client.Stream;
import com.vhall.vhallrtc.client.VHRenderView;
import com.vhall.vhallrtc.common.AppRTCAudioManager;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;
import org.vhwebrtc.SurfaceViewRenderer;

public class VhallVRTCImpl
implements IVHRTC {
    private final String TAG = "VhallVRTC";
    private Context mContext;
    private VhallRTC mVhallRTC;
    private Stream mLocalStream;
    private VHRenderView mLocalRenderView;
    private boolean mAutoPublish;
    private boolean mAutoSubscribe;
    private VHRoomListener mRoomListener = null;
    private Room mRoom = null;
    private boolean mCameraFacingFront = true;
    private JSONObject mMixConfig = null;
    private JSONObject _bgColorJSON = null;
    private JSONObject _boardJSON = null;

    public VhallVRTCImpl(Context context, VRTCParams.VRTCRoomParamsInner roomParams) {
        this.mContext = context;
        this.mVhallRTC = new VhallRTC(context, roomParams.softEchoCanceller, true);
    }

    @Override
    public void enterRoom(VRTCParams.VRTCRoomParamsInner roomParams, boolean autoPublish, boolean autoSubscribe, String attribute, VHRoomListener roomListener) {
        if (null != this.mVhallRTC) {
            this.mAutoPublish = autoPublish;
            this.mAutoSubscribe = autoSubscribe;
            this.mRoomListener = roomListener;
            this.mVhallRTC.setListener((Room.RoomDelegate)new VRTCRoomDelegate());
            this.mVhallRTC.setCameraListener(new VhallRTC.IOnCameraListener(){

                public void onCameraError(String err) {
                    if (null != VhallVRTCImpl.this.mRoomListener) {
                        VhallVRTCImpl.this.mRoomListener.onCameraError(0, err);
                    }
                }

                public void onFirstFrame() {
                    if (null != VhallVRTCImpl.this.mRoomListener) {
                        VhallVRTCImpl.this.mRoomListener.onFirstFrameAvailable(true, null, 0, 0);
                    }
                }
            });
            this.mVhallRTC.enterRoom(roomParams.inavToken, attribute);
        } else {
            VLog.e((String)"VhallVRTC", (String)"please init first");
        }
    }

    @Override
    public void startLocalPreview(IVHRTCRenderView renderView, VRTCParams.VRTCVideoEncodeParam videoParam, VRTCParams.VRTCStreamParam streamParam, boolean isFrontCamera) {
        this.mLocalStream = this.initLocalStream(videoParam, streamParam);
        this.mLocalRenderView = this.initRenderView(renderView);
        if (null != this.mLocalRenderView) {
            this.mLocalStream.removeAllRenderView();
            this.mLocalStream.addRenderView(this.mLocalRenderView);
        }
    }

    @Override
    public void startRemoteView(IVHRTCRenderView renderView, String streamId) {
        VHRenderView remoteRenderView = this.initRenderView(renderView);
        if (null != remoteRenderView && null != this.mRoom) {
            Stream remoteStream = this.mRoom.getRemoteStreamById(streamId);
            if (null != remoteStream) {
                remoteStream.removeAllRenderView();
                remoteStream.addRenderView(remoteRenderView);
            }
        } else {
            VLog.e((String)"VhallVRTC", (String)"Room#startRemoteView Room is null");
        }
    }

    @Override
    public void createScreenShareStream(MediaProjection mediaProjection, VRTCParams.VRTCVideoEncodeParam videoParam, VRTCParams.VRTCStreamParam streamParam) {
        VRTCParams.VRTCVideoEncodeParam encodeParam;
        if (null == mediaProjection) {
            VLog.e((String)"VhallVRTC", (String)"createScreenShareStream erroor, mediaProjection is null!");
            return;
        }
        if (null == videoParam) {
            encodeParam = new VRTCParams.VRTCVideoEncodeParam();
            encodeParam.videoResolution = 20;
            encodeParam.videoFps = 5;
            encodeParam.minVideoBitrate = 800;
            encodeParam.videoBitrate = 900;
            encodeParam.maxVideoBitrate = 1000;
            encodeParam.resolutionStrategy = 3;
        } else {
            encodeParam = videoParam;
        }
        this.mLocalStream = this.initScreenShareStream(mediaProjection, encodeParam, streamParam);
    }

    @Override
    public void stopScreenShare() {
        this.leaveRoom();
    }

    @Override
    public String getUserIdByStreamId(String streamId) {
        Stream stream = this.mRoom.getRemoteStreamById(streamId);
        return null != stream ? stream.userId : null;
    }

    @Override
    public void publish() {
        if (null != this.mVhallRTC) {
            this.mVhallRTC.publish();
        }
    }

    @Override
    public void unPublish() {
        if (null != this.mVhallRTC) {
            this.mVhallRTC.unpublish();
        }
    }

    @Override
    public void subscribe(String streamId) {
        Stream targetStream;
        if (null != this.mRoom && null != (targetStream = this.mRoom.getRemoteStreamById(streamId))) {
            this.mRoom.subscribe(targetStream);
        }
    }

    @Override
    public void unSubscribe(String streamId) {
        Stream targetStream;
        if (null != this.mRoom && null != (targetStream = this.mRoom.getRemoteStreamById(streamId))) {
            this.mRoom.unsubscribe(targetStream);
        }
    }

    @Override
    public void leaveRoom() {
        if (null != this.mVhallRTC) {
            this.mVhallRTC.leaveRoom();
        }
    }

    @Override
    public void muteVideo(String streamId, boolean mute) {
        Stream targetStream = null;
        if (TextUtils.isEmpty((CharSequence)streamId)) {
            targetStream = this.mLocalStream;
        } else if (null != this.mRoom) {
            targetStream = this.mRoom.getRemoteStreamById(streamId);
        }
        if (null != targetStream) {
            if (mute) {
                targetStream.muteVideo(new FinishCallback(){

                    public void onFinish(int i, String s) {
                        VLog.d((String)"VhallVRTC", (String)("muteVideo, code:" + i + ", message:" + s));
                    }
                });
            } else {
                targetStream.unmuteVideo(new FinishCallback(){

                    public void onFinish(int i, String s) {
                        VLog.d((String)"VhallVRTC", (String)("unmuteVideo, code:" + i + ", message:" + s));
                    }
                });
            }
        } else {
            VLog.e((String)"VhallVRTC", (String)"target stream does not exists");
        }
    }

    @Override
    public void muteAudio(String streamId, boolean mute) {
        Stream targetStream = null;
        if (TextUtils.isEmpty((CharSequence)streamId)) {
            targetStream = this.mLocalStream;
        } else if (null != this.mRoom) {
            targetStream = this.mRoom.getRemoteStreamById(streamId);
        }
        if (null != targetStream) {
            if (mute) {
                targetStream.muteAudio(new FinishCallback(){

                    public void onFinish(int i, String s) {
                        VLog.d((String)"VhallVRTC", (String)("muteAudio(, code:" + i + ", message:" + s));
                    }
                });
            } else {
                targetStream.unmuteAudio(new FinishCallback(){

                    public void onFinish(int i, String s) {
                        VLog.d((String)"VhallVRTC", (String)("unmuteAudio(, code:" + i + ", message:" + s));
                    }
                });
            }
        } else {
            VLog.e((String)"VhallVRTC", (String)"target stream does not exists");
        }
    }

    @Override
    public void switchCamera() {
        boolean bl = this.mCameraFacingFront = !this.mCameraFacingFront;
        if (null != this.mLocalStream) {
            this.mLocalStream.switchCamera();
        }
    }

    @Override
    public boolean isFrontCamera() {
        return this.mCameraFacingFront;
    }

    @Override
    public void setMirror(boolean isMirror) {
        if (null != this.mLocalRenderView) {
            this.mLocalRenderView.setMirror(isMirror);
        }
    }

    @Override
    public void switchAutoFocusMode(boolean enableAuto, final ISwitchFocusModeListener switchFocusModeListener) {
        if (null != this.mLocalStream) {
            this.mLocalStream.switchAutoFocusMode(enableAuto, new IFocusModeChangeListener(){

                public void onComplete(boolean result, String errMsg) {
                    if (null != switchFocusModeListener) {
                        switchFocusModeListener.onComplete(result, errMsg);
                    }
                }
            });
        }
    }

    @Override
    public void release() {
        this.mVhallRTC.setListener(null);
        if (null != this.mVhallRTC) {
            this.mVhallRTC.release();
            this.mVhallRTC = null;
        }
        this.mLocalStream = null;
        if (null != this.mLocalRenderView) {
            this.mLocalRenderView.release();
            this.mLocalRenderView = null;
        }
    }

    @Override
    public void setDataReport(JSONObject data) {
        if (null != this.mRoom) {
            this.mRoom.setReportLogData(data);
        }
    }

    @Override
    public void setMixBackgroundImage(VRTCParams.VRTCBroadcastParamInner broadcastParam, String url, int cropType, final ICallback callback) {
        if (null != this.mVhallRTC) {
            FinishCallback finishCallback = new FinishCallback(){

                public void onFinish(int code, String msg) {
                    if (null != callback) {
                        if (200 == code) {
                            callback.onSuccess();
                        } else {
                            callback.onFailure(code, msg);
                        }
                    }
                }
            };
            if (!TextUtils.isEmpty((CharSequence)url)) {
                this.mVhallRTC.setRoomBroadCastBackgroundImage(url, cropType, finishCallback);
            } else {
                this.mVhallRTC.resetRoomBroadCastBackgroundImage(finishCallback);
            }
        }
    }

    @Override
    public void setMixPlaceholderImage(String url, final ICallback callback) {
        if (null != this.mVhallRTC) {
            FinishCallback finishCallback = new FinishCallback(){

                public void onFinish(int code, String msg) {
                    if (null != callback) {
                        if (200 == code) {
                            callback.onSuccess();
                        } else {
                            callback.onFailure(code, msg);
                        }
                    }
                }
            };
            if (!TextUtils.isEmpty((CharSequence)url)) {
                this.mVhallRTC.setRoomBroadCastPlaceholderImage(url, finishCallback);
            } else {
                this.mVhallRTC.resetRoomBroadCastPlaceholderImage(finishCallback);
            }
        }
    }

    @Override
    public void docCloudRender(String appId, String channelId, boolean start, final ICallback callback) {
        if (null != this.mRoom) {
            JSONObject config = new JSONObject();
            try {
                config.put("appId", (Object)appId);
                config.put("channelId", (Object)channelId);
                FinishCallback finishCallback = new FinishCallback(){

                    public void onFinish(int code, String msg) {
                        if (null != callback) {
                            if (200 == code) {
                                callback.onSuccess();
                            } else {
                                callback.onFailure(code, msg);
                            }
                        }
                    }
                };
                if (start) {
                    this.mRoom.startDocCloudRender(config, finishCallback);
                } else {
                    this.mRoom.stopDocCloudRender(config, finishCallback);
                }
            }
            catch (JSONException exception) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    public void setScaleType(int scaleType) {
        SurfaceViewRenderer.VHRenderViewScalingMode scalingMode;
        switch (scaleType) {
            default: {
                scalingMode = SurfaceViewRenderer.VHRenderViewScalingMode.kVHRenderViewScalingModeNone;
                break;
            }
            case 1: {
                scalingMode = SurfaceViewRenderer.VHRenderViewScalingMode.kVHRenderViewScalingModeAspectFit;
                break;
            }
            case 2: {
                scalingMode = SurfaceViewRenderer.VHRenderViewScalingMode.kVHRenderViewScalingModeAspectFill;
            }
        }
        if (null != this.mLocalRenderView) {
            this.mLocalRenderView.setScalingMode(scalingMode);
        }
    }

    @Override
    public void setVideoResolution(int videoProfile) {
        if (null != this.mLocalStream) {
            VRTCParams.VRTCVideoEncodeParam encodeParam = new VRTCParams.VRTCVideoEncodeParam();
            encodeParam.videoResolution = videoProfile;
            VRTCVideoEncodeCompat.compat(encodeParam);
            this.mLocalStream.ChangeCarameFormat(encodeParam.videoWidth, encodeParam.videoHeight, encodeParam.videoFps);
        }
    }

    @Override
    public void setDefaultAudioDevice(Object object) {
        if (null != this.mVhallRTC && object instanceof AppRTCAudioManager.AudioDevice) {
            this.mVhallRTC.setDefaultAudioDevice((AppRTCAudioManager.AudioDevice)object);
        }
    }

    @Override
    public void broadcastRoom(VRTCParams.VRTCBroadcastParamInner broadcastParam, String accessToken, ICallback callback) {
        if (null == broadcastParam || null == broadcastParam.broadcastParam) {
            this.stopBroadcastRoom(callback);
        } else {
            this.startBroadcastRoom(broadcastParam, callback);
        }
    }

    @Override
    public void setMixLayoutMainScreen(String streamId, final ICallback callback) {
        if (null != this.mRoom && null != this.mLocalStream) {
            this.mRoom.setMixLayoutMainScreen(TextUtils.isEmpty((CharSequence)streamId) ? this.mLocalStream.streamId : streamId, new FinishCallback(){

                public void onFinish(int code, String message) {
                    if (null != callback) {
                        if (code != 200) {
                            callback.onFailure(code, message);
                        } else {
                            callback.onSuccess();
                        }
                    }
                }
            });
        }
    }

    @Override
    public void setMixLayoutMode(VRTCParams.VRTCBroadcastParamInner broadcastParam, int layoutMode, final ICallback callback) {
        if (null != this.mVhallRTC) {
            this.mVhallRTC.setMixLayoutMode(layoutMode, null, new FinishCallback(){

                public void onFinish(int code, String message) {
                    if (null != callback) {
                        if (code != 200) {
                            callback.onFailure(code, message);
                        } else {
                            callback.onSuccess();
                        }
                    }
                }
            });
            if (null != this.mMixConfig) {
                if (layoutMode >= 1000) {
                    try {
                        this.mMixConfig.remove("layoutMode");
                        this.mMixConfig.put("adaptiveLayoutMode", layoutMode - 1000);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                } else {
                    try {
                        this.mMixConfig.put("layoutMode", layoutMode);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    @Override
    public void setMixBackgroundColor(VRTCParams.VRTCBroadcastParamInner broadcastParam, String hexColor, final ICallback callback) {
        block6: {
            if (null != this.mRoom) {
                if (TextUtils.isEmpty((CharSequence)hexColor)) {
                    hexColor = "0x333338";
                }
                try {
                    if (null != this.mMixConfig) {
                        this.mMixConfig.put("backgroundColor", (Object)Utils.compatColor2HexStyle(hexColor));
                        this.mRoom.configRoomBroadCast(this.mMixConfig, null, new FinishCallback(){

                            public void onFinish(int i, String s) {
                                if (null != callback) {
                                    if (200 == i) {
                                        callback.onSuccess();
                                    } else {
                                        callback.onFailure(i, s);
                                    }
                                }
                            }
                        });
                        break block6;
                    }
                    this._bgColorJSON = new JSONObject();
                    this._bgColorJSON.put("backgroundColor", (Object)Utils.compatColor2HexStyle(hexColor));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            } else {
                VLog.d((String)"VhallVRTC", (String)"Room is null");
            }
        }
    }

    @Override
    public void setMixBorderColor(VRTCParams.VRTCBroadcastParam.Border border, ICallback callback) {
        if (null != border) {
            this.setRoomBroadCastBorderColor(border, callback);
        } else {
            this.setRoomBroadCastBorderColor(null, callback);
        }
    }

    private void setRoomBroadCastBorderColor(VRTCParams.VRTCBroadcastParam.Border borderConfig, final ICallback callback) {
        boolean transparent;
        boolean enable = null != borderConfig && borderConfig.exist;
        int width = null == borderConfig ? 0 : borderConfig.width;
        String hexColor = null == borderConfig ? null : borderConfig.color;
        boolean bl = transparent = null != borderConfig && borderConfig.transparent;
        if (null != this.mRoom) {
            if (!enable) {
                try {
                    if (null != this.mMixConfig) {
                        JSONObject border = new JSONObject();
                        border.put("exist", false);
                        this.mMixConfig.put("border", (Object)border);
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            } else {
                if (width > 8) {
                    width = 8;
                } else if (width < 1) {
                    width = 0;
                }
                try {
                    JSONObject border = new JSONObject();
                    border.put("exist", true);
                    border.put("width", width);
                    border.put("color", (Object)Utils.compatColor2HexStyle(hexColor));
                    border.put("transparency", transparent ? 100 : 0);
                    if (null != this.mMixConfig) {
                        this.mMixConfig.put("border", (Object)border);
                    } else {
                        this._boardJSON = new JSONObject();
                        this._boardJSON.put("border", (Object)border);
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            if (null != this.mMixConfig) {
                this.mRoom.configRoomBroadCast(this.mMixConfig, null, new FinishCallback(){

                    public void onFinish(int i, String s) {
                        if (null != callback) {
                            if (200 == i) {
                                callback.onSuccess();
                            } else {
                                callback.onFailure(i, s);
                            }
                        }
                    }
                });
            }
        } else {
            VLog.d((String)"VhallVRTC", (String)"Room is null");
        }
    }

    private void startBroadcastRoom(VRTCParams.VRTCBroadcastParamInner broadcastParam, final ICallback callback) {
        if (null != this.mVhallRTC) {
            final JSONObject tempConfig = new JSONObject();
            try {
                tempConfig.put("profile", (Object)broadcastParam.compat_profile_json);
                if (broadcastParam.isAdaptiveLayoutMode) {
                    tempConfig.remove("layoutMode");
                    tempConfig.put("adaptiveLayoutMode", (Object)String.valueOf(broadcastParam.compat_layout_mode));
                } else {
                    tempConfig.remove("adaptiveLayoutMode");
                    tempConfig.put("layoutMode", (Object)String.valueOf(broadcastParam.compat_layout_mode));
                }
                tempConfig.put("layoutMode", broadcastParam.compat_layout_mode);
                tempConfig.put("precast_pic_exist", broadcastParam.broadcastParam.precast_pic_exist);
                String bgColor = Utils.compatColor2HexStyle(broadcastParam.broadcastParam.backgroundColor);
                if (!TextUtils.isEmpty((CharSequence)bgColor)) {
                    tempConfig.put("backgroundColor", (Object)broadcastParam.broadcastParam.backgroundColor);
                }
                if (null != broadcastParam.broadcastParam.border) {
                    VRTCParams.VRTCBroadcastParam.Border tempBrder = broadcastParam.broadcastParam.border.copy();
                    tempBrder.color = tempBrder.convertColor2VRTCStyle();
                    tempConfig.put("border", (Object)tempBrder.convertToJson());
                }
                tempConfig.put("publishUrl", (Object)broadcastParam.pushUrl);
                if (broadcastParam.broadcastParam.nickName) {
                    JSONObject nickNameConfig = new JSONObject();
                    nickNameConfig.put("display", true);
                    tempConfig.put("nickName", (Object)nickNameConfig);
                }
                tempConfig.put("crop_type", broadcastParam.broadcastParam.cropType);
                this.boundPreConfigColor(tempConfig);
                this.mVhallRTC.configRoomBroadCast(tempConfig, null, new FinishCallback(){

                    public void onFinish(int code, String message) {
                        VhallVRTCImpl.this.mMixConfig = tempConfig;
                        if (code != 200) {
                            if (callback != null) {
                                callback.onFailure(code, message);
                            }
                        } else if (callback != null) {
                            callback.onSuccess();
                        }
                    }
                });
            }
            catch (JSONException e) {
                e.printStackTrace();
                if (callback != null) {
                    callback.onFailure(10003, e.getMessage());
                }
            }
        } else {
            VLog.d((String)"VhallVRTC", (String)"please init VHInteractiveV2 first");
        }
    }

    private void boundPreConfigColor(JSONObject baseConfig) {
        if (null != this._bgColorJSON) {
            try {
                baseConfig.put("backgroundColor", this._bgColorJSON.opt("backgroundColor"));
                this._bgColorJSON = null;
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        if (null != this._boardJSON) {
            try {
                baseConfig.put("border", this._boardJSON.opt("border"));
                this._boardJSON = null;
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    private void stopBroadcastRoom(final ICallback callback) {
        if (null != this.mVhallRTC) {
            this.mVhallRTC.stopRoomBroadCast(null, new FinishCallback(){

                public void onFinish(int code, String message) {
                    if (code != 200) {
                        if (callback != null) {
                            callback.onFailure(code, message);
                        }
                    } else if (callback != null) {
                        callback.onSuccess();
                    }
                }
            });
        }
    }

    private VHRenderView initRenderView(IVHRTCRenderView renderView) {
        if (null == renderView) {
            return null;
        }
        VHRenderView tempRenderView = new VHRenderView(this.mContext);
        tempRenderView.init(null, null);
        renderView.bindSurfaceView((SurfaceView)tempRenderView);
        return tempRenderView;
    }

    private Stream initLocalStream(VRTCParams.VRTCVideoEncodeParam videoParam, VRTCParams.VRTCStreamParam streamParam) {
        VRTCVideoEncodeCompat.compat(videoParam);
        JSONObject option = new JSONObject();
        try {
            if (videoParam.videoResolutionMode == 0) {
                option.put("videoWidth", videoParam.videoWidth);
                option.put("videoHeight", videoParam.videoHeight);
            } else {
                option.put("videoWidth", videoParam.videoHeight);
                option.put("videoHeight", videoParam.videoWidth);
            }
            option.put("videoFps", videoParam.videoFps);
            option.put("minBitrateKbps", videoParam.minVideoBitrate);
            option.put("currentBitrateKbps", videoParam.videoBitrate);
            option.put("maxBitrateKbps", videoParam.maxVideoBitrate);
            option.put("streamType", streamParam.streamType);
            if (!TextUtils.isEmpty((CharSequence)streamParam.nickName)) {
                option.put("nickName", (Object)streamParam.nickName);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return this.mVhallRTC.createLocalStream(option, streamParam.attributes);
    }

    private Stream initScreenShareStream(MediaProjection mediaProjection, VRTCParams.VRTCVideoEncodeParam videoParam, VRTCParams.VRTCStreamParam streamParam) {
        VRTCVideoEncodeCompat.compat(videoParam);
        JSONObject option = new JSONObject();
        try {
            option.put("videoWidth", videoParam.videoWidth);
            option.put("videoHeight", videoParam.videoHeight);
            option.put("videoFps", 5);
            option.put("minBitrateKbps", videoParam.minVideoBitrate);
            option.put("currentBitrateKbps", videoParam.videoBitrate);
            option.put("maxBitrateKbps", videoParam.maxVideoBitrate);
            option.put("streamType", Stream.VhallStreamType.VhallStreamTypeScreen.getValue());
            if (!TextUtils.isEmpty((CharSequence)streamParam.nickName)) {
                option.put("nickName", (Object)streamParam.nickName);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return this.mVhallRTC.createScreenLocalStream(mediaProjection, option, streamParam.attributes);
    }

    private class VRTCRoomDelegate
    implements Room.RoomDelegate {
        private VRTCRoomDelegate() {
        }

        public void onDidConnect(Room room, JSONObject jsonObject) {
            ArrayList internalStreams;
            VhallVRTCImpl.this.mRoom = room;
            VLog.d((String)"VhallVRTC", (String)"---> VRTCRoomDelegate#onDidConnect");
            if (null != VhallVRTCImpl.this.mRoomListener) {
                VhallVRTCImpl.this.mRoomListener.onDidConnect(jsonObject);
            }
            if (VhallVRTCImpl.this.mAutoPublish && null != VhallVRTCImpl.this.mVhallRTC) {
                VhallVRTCImpl.this.mVhallRTC.publish();
            }
            if (VhallVRTCImpl.this.mAutoSubscribe) {
                this.subscribeStreams(room, room.getRemoteStreams());
            }
            if ((internalStreams = room.getRemoteInternalStreams()) != null && !internalStreams.isEmpty()) {
                for (Stream stream : internalStreams) {
                    VhallVRTCImpl.this.mRoomListener.onDidInternalStreamAdded(stream.userId, stream.streamId);
                }
            }
        }

        private void subscribeStreams(Room room, List<Stream> streams) {
            if (null != streams && !streams.isEmpty()) {
                for (int i = 0; i < streams.size(); ++i) {
                    room.subscribe(streams.get(i));
                }
            }
        }

        public void onDidError(Room room, Room.VHRoomErrorStatus vhRoomErrorStatus, String errMsg) {
            VLog.e((String)"VhallVRTC", (String)("---> VRTCRoomDelegate#onDidError, Room.VHRoomErrorStatus=" + vhRoomErrorStatus.getValue()));
            if (null != VhallVRTCImpl.this.mRoomListener) {
                VhallVRTCImpl.this.mRoomListener.onDidError(0, errMsg, null);
            }
        }

        public void onDidPublishStream(Room room, Stream stream) {
            VLog.d((String)"VhallVRTC", (String)"---> VRTCRoomDelegate#onDidPublishStream");
            if (null != VhallVRTCImpl.this.mRoomListener) {
                VhallVRTCImpl.this.mRoomListener.onDidPublishStream(stream.userId, stream.streamId);
            }
        }

        public void onDidInternalStreamAdded(Room room, Stream stream) {
            VLog.d((String)"VhallVRTC", (String)"---> VRTCRoomDelegate#onDidInternalStreamAdded");
            if (null != VhallVRTCImpl.this.mRoomListener) {
                VhallVRTCImpl.this.mRoomListener.onDidInternalStreamAdded(stream.userId, stream.streamId);
            }
        }

        public void onDidInternalStreamRemoved(Room room, Stream stream) {
            VLog.d((String)"VhallVRTC", (String)"---> VRTCRoomDelegate#onDidInternalStreamRemoved");
            if (null != VhallVRTCImpl.this.mRoomListener) {
                VhallVRTCImpl.this.mRoomListener.onDidInternalStreamRemoved(stream.userId, stream.streamId);
            }
        }

        public void onDidInternalStreamFailed(Room room, Stream stream, JSONObject jsonObject) {
            VLog.d((String)"VhallVRTC", (String)"---> VRTCRoomDelegate#onDidInternalStreamFailed");
            if (null != VhallVRTCImpl.this.mRoomListener) {
                VhallVRTCImpl.this.mRoomListener.onDidInternalStreamFailed(stream.userId, stream.streamId, jsonObject);
            }
        }

        public void onDidUnPublishStream(Room room, Stream stream) {
            VLog.d((String)"VhallVRTC", (String)"---> VRTCRoomDelegate#onDidUnPublishStream");
            if (null != VhallVRTCImpl.this.mRoomListener) {
                VhallVRTCImpl.this.mRoomListener.onDidUnPublishStream(stream.userId, stream.streamId);
            }
        }

        public void onDidSubscribeStream(Room room, Stream stream) {
            VLog.d((String)"VhallVRTC", (String)"---> VRTCRoomDelegate#onDidSubscribeStream");
            if (null != VhallVRTCImpl.this.mRoomListener) {
                VhallVRTCImpl.this.mRoomListener.onDidSubscribeStream(stream.userId, stream.streamId);
            }
        }

        public void onDidUnSubscribeStream(Room room, Stream stream) {
            VLog.d((String)"VhallVRTC", (String)"---> VRTCRoomDelegate#onDidUnSubscribeStream");
            if (null != VhallVRTCImpl.this.mRoomListener) {
                VhallVRTCImpl.this.mRoomListener.onDidUnSubscribeStream(stream.userId, stream.streamId);
            }
        }

        public void onDidChangeStatus(Room room, Room.VHRoomStatus vhRoomStatus) {
            if (vhRoomStatus == Room.VHRoomStatus.VHRoomStatusDisconnected && null != VhallVRTCImpl.this.mRoomListener) {
                VhallVRTCImpl.this.mRoomListener.onDidExitRoom();
            }
        }

        public void onDidAddStream(Room room, Stream stream) {
            VLog.d((String)"VhallVRTC", (String)"---> VRTCRoomDelegate#onDidAddStream");
            if (VhallVRTCImpl.this.mAutoSubscribe) {
                room.subscribe(stream);
            }
            if (null != VhallVRTCImpl.this.mRoomListener) {
                VhallVRTCImpl.this.mRoomListener.onDidAddStream(stream.userId, stream.streamId);
            }
        }

        public void onDidRemoveStream(Room room, Stream stream) {
            VLog.d((String)"VhallVRTC", (String)"---> VRTCRoomDelegate#onDidRemoveStream");
            if (null != VhallVRTCImpl.this.mRoomListener) {
                VhallVRTCImpl.this.mRoomListener.onDidRemoveStream(stream.userId, stream.streamId);
            }
        }

        public void onDidUpdateOfStream(Stream stream, JSONObject jsonObject) {
            VLog.d((String)"VhallVRTC", (String)"---> VRTCRoomDelegate#onDidUpdateOfStream");
            if (null != VhallVRTCImpl.this.mRoomListener) {
                VhallVRTCImpl.this.mRoomListener.onDidUpdateOfStream(stream.streamId, jsonObject);
                if (null != jsonObject && jsonObject.has("muteStream")) {
                    JSONObject obj = jsonObject.optJSONObject("muteStream");
                    JSONObject msgV2 = new JSONObject();
                    try {
                        if (obj.has("video")) {
                            msgV2.put("video", obj.optBoolean("video", true));
                        }
                        if (obj.has("audio")) {
                            msgV2.put("audio", obj.optBoolean("audio", true));
                        }
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                    VhallVRTCImpl.this.mRoomListener.onDidUpdateOfStreamV2(stream.streamId, msgV2);
                }
            }
        }

        public void onReconnect(int total, int current) {
            VLog.d((String)"VhallVRTC", (String)("---> VRTCRoomDelegate#onReconnect: total = " + total + " current " + current));
            if (null != VhallVRTCImpl.this.mRoomListener) {
                VhallVRTCImpl.this.mRoomListener.onReconnect(total, current);
            }
        }

        public void onStreamMixed(JSONObject jsonObject) {
            VLog.d((String)"VhallVRTC", (String)"---> VRTCRoomDelegate#onStreamMixed");
            if (null != VhallVRTCImpl.this.mRoomListener) {
                VhallVRTCImpl.this.mRoomListener.onStreamMixed(jsonObject);
            }
        }
    }
}

