/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.rtc.vrtc;

import com.vhall.rtc.VRTCParams;

class VRTCVideoEncodeCompat {
    VRTCVideoEncodeCompat() {
    }

    public static void compat(VRTCParams.VRTCVideoEncodeParam encodeParam) {
        if (encodeParam.videoWidth > 0 || encodeParam.videoHeight > 0) {
            return;
        }
        switch (encodeParam.videoResolution) {
            case 21: {
                encodeParam.videoWidth = 1920;
                encodeParam.videoHeight = 1080;
                VRTCVideoEncodeCompat.tryFitWithRecommendValue(encodeParam, 15, 700, 1300, 1700);
                break;
            }
            default: {
                encodeParam.videoWidth = 1280;
                encodeParam.videoHeight = 720;
                VRTCVideoEncodeCompat.tryFitWithRecommendValue(encodeParam, 15, 500, 800, 1200);
                break;
            }
            case 19: {
                encodeParam.videoWidth = 960;
                encodeParam.videoHeight = 540;
                VRTCVideoEncodeCompat.tryFitWithRecommendValue(encodeParam, 15, 500, 700, 800);
                break;
            }
            case 18: {
                encodeParam.videoWidth = 640;
                encodeParam.videoHeight = 360;
                VRTCVideoEncodeCompat.tryFitWithRecommendValue(encodeParam, 15, 240, 350, 450);
                break;
            }
            case 16: 
            case 17: {
                encodeParam.videoWidth = 320;
                encodeParam.videoHeight = 180;
                encodeParam.videoResolution = 16;
                VRTCVideoEncodeCompat.tryFitWithRecommendValue(encodeParam, 15, 190, 230, 290);
                break;
            }
            case 14: 
            case 15: {
                encodeParam.videoResolution = 14;
                encodeParam.videoWidth = 160;
                encodeParam.videoHeight = 90;
                VRTCVideoEncodeCompat.tryFitWithRecommendValue(encodeParam, 15, 120, 150, 180);
                break;
            }
            case 13: {
                encodeParam.videoWidth = 960;
                encodeParam.videoHeight = 720;
                VRTCVideoEncodeCompat.tryFitWithRecommendValue(encodeParam, 15, 450, 750, 1050);
                break;
            }
            case 12: {
                encodeParam.videoWidth = 640;
                encodeParam.videoHeight = 480;
                VRTCVideoEncodeCompat.tryFitWithRecommendValue(encodeParam, 15, 360, 500, 600);
                break;
            }
            case 11: {
                encodeParam.videoWidth = 480;
                encodeParam.videoHeight = 360;
                VRTCVideoEncodeCompat.tryFitWithRecommendValue(encodeParam, 15, 200, 280, 350);
                break;
            }
            case 9: 
            case 10: {
                encodeParam.videoResolution = 9;
                encodeParam.videoWidth = 320;
                encodeParam.videoHeight = 240;
                VRTCVideoEncodeCompat.tryFitWithRecommendValue(encodeParam, 15, 200, 250, 300);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                encodeParam.videoResolution = 6;
                encodeParam.videoWidth = 192;
                encodeParam.videoHeight = 144;
                VRTCVideoEncodeCompat.tryFitWithRecommendValue(encodeParam, 15, 150, 170, 200);
            }
        }
        if (encodeParam.videoResolutionMode == 1) {
            int tempWidth = encodeParam.videoWidth;
            encodeParam.videoWidth = encodeParam.videoHeight;
            encodeParam.videoHeight = tempWidth;
        }
    }

    private static void fitVideoFps(VRTCParams.VRTCVideoEncodeParam encodeParam, int defaultValue) {
        if (encodeParam.videoFps <= 0) {
            encodeParam.videoFps = defaultValue;
        }
    }

    private static void fitVideoBitrate(VRTCParams.VRTCVideoEncodeParam encodeParam, int defaultValue) {
        if (encodeParam.videoBitrate <= 0) {
            encodeParam.videoBitrate = defaultValue;
        }
    }

    private static void fitVideoMaxBitrate(VRTCParams.VRTCVideoEncodeParam encodeParam, int defaultValue) {
        if (encodeParam.maxVideoBitrate <= 0) {
            encodeParam.maxVideoBitrate = defaultValue;
        }
    }

    private static void fitVideoMinBitrate(VRTCParams.VRTCVideoEncodeParam encodeParam, int defaultValue) {
        if (encodeParam.minVideoBitrate <= 0) {
            encodeParam.minVideoBitrate = defaultValue;
        }
    }

    private static void tryFitWithRecommendValue(VRTCParams.VRTCVideoEncodeParam encodeParam, int videoFps, int minBitrate, int bitrate, int maxBitrate) {
        VRTCVideoEncodeCompat.fitVideoFps(encodeParam, videoFps);
        VRTCVideoEncodeCompat.fitVideoMinBitrate(encodeParam, minBitrate);
        VRTCVideoEncodeCompat.fitVideoBitrate(encodeParam, bitrate);
        VRTCVideoEncodeCompat.fitVideoMaxBitrate(encodeParam, maxBitrate);
    }
}

