/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.rtc.trtc.log;

import android.os.Build;
import android.util.Base64;
import com.tencent.trtc.TRTCStatistics;
import com.vhall.logmanager.VLog;
import com.vhall.rtc.trtc.Stream;
import com.vhall.rtc.trtc.log.StreamLogReport;
import com.vhall.rtc.trtc.log.TempHttpRequest;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;

public class LogReport {
    private static final String mTag = "LogReport";
    private static LogReport mInstance = null;
    private long mLogId = 0L;
    private TRTCStatistics mTRTCStatistics;
    public HashMap<String, StreamLogReport> mStreamLogReportDic = new HashMap();
    public static final String kHost = "host";
    public static final String kVer = "ver";
    public static final String kPublishTime = "release_date";
    public static final String kSession = "s";
    public static final String kBU = "bu";
    public static final String kDT = "dt";
    public static final String kOSV = "osv";
    public static final String kUA = "ua";
    public int bu = 0;
    public int pf = 5;
    public String reportUrl;
    public String reportMonitorUrl;
    public String sessionId;
    public String userid;
    public String aid;
    public String cid;
    public JSONObject logDataInfo = new JSONObject();

    public static String md5(String string) {
        if (string == null || string.isEmpty()) {
            return "";
        }
        MessageDigest md5 = null;
        try {
            md5 = MessageDigest.getInstance("MD5");
            byte[] bytes = md5.digest(string.getBytes());
            String result = "";
            for (byte b : bytes) {
                String temp = Integer.toHexString(b & 0xFF);
                if (temp.length() == 1) {
                    temp = "0" + temp;
                }
                result = result + temp;
            }
            return result;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return "";
        }
    }

    private LogReport() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LogReport instance() {
        Class<LogReport> clazz = LogReport.class;
        synchronized (LogReport.class) {
            if (mInstance == null) {
                mInstance = new LogReport();
                String uuid = UUID.randomUUID().toString();
                LogReport.mInstance.sessionId = LogReport.md5(uuid + System.currentTimeMillis());
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    long getLogId() {
        ++this.mLogId;
        return this.mLogId;
    }

    public boolean setLogRoominfo(String uid, String aid, String cid, int pf) {
        if (!uid.isEmpty()) {
            this.userid = uid;
        }
        if (!aid.isEmpty()) {
            this.aid = aid;
        }
        if (!cid.isEmpty()) {
            this.cid = cid;
        }
        if (pf >= 0) {
            this.pf = pf;
        }
        return true;
    }

    public boolean setLogDataInfo(JSONObject logInfo) {
        if (logInfo == null) {
            return false;
        }
        this.logDataInfo = logInfo;
        try {
            if (this.logDataInfo.has(kHost)) {
                this.reportUrl = this.logDataInfo.getString(kHost);
                try {
                    URL url = new URL(this.reportUrl);
                    this.reportMonitorUrl = url.getPort() > 0 ? url.getProtocol() + "://" + url.getHost() + ":" + url.getPort() + "/monitor" : url.getProtocol() + "://" + url.getHost() + "/monitor";
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                }
                VLog.d((String)mTag, (String)("reportMonitorUrl:" + this.reportMonitorUrl));
                this.logDataInfo.remove(kHost);
            } else {
                VLog.d((String)mTag, (String)"data info is not contain host.");
            }
            if (this.logDataInfo.has(kBU)) {
                this.bu = this.logDataInfo.optInt(kBU);
            } else {
                VLog.d((String)mTag, (String)"bu field is empty.");
            }
            this.logDataInfo.put(kOSV, (Object)("android " + Build.VERSION.RELEASE));
            this.logDataInfo.put(kUA, (Object)("android " + Build.VERSION.RELEASE));
            this.logDataInfo.put(kDT, (Object)Build.MODEL);
            this.logDataInfo.put(kVer, (Object)"v3.0.0");
            this.logDataInfo.put(kPublishTime, (Object)"20221115");
            this.logDataInfo.put(kSession, (Object)this.sessionId);
        }
        catch (JSONException e) {
            e.printStackTrace();
            VLog.d((String)mTag, (String)"JSONException catch.");
        }
        return true;
    }

    public void reportLogWithKey(VhallLogReportKey key) {
        this.reportLogWithKeyAndStreamId(key, null, null);
    }

    public void reportLogWithKeyAndStreamId(VhallLogReportKey key, String streamId) {
        this.reportLogWithKeyAndStreamId(key, streamId, null);
    }

    public void reportLogWithKeyAndStreamId(VhallLogReportKey key, String streamId, String msg) {
        this.reportLogWithKeyAndStreamId(key, streamId, msg, -1);
    }

    public void reportLogWithKeyAndStreamId(VhallLogReportKey key, String streamId, String msg, int code) {
        this.reportLogWithKeyAndStreamId(key, streamId, msg, code, null);
    }

    public void reportLogWithKeyAndStreamId(VhallLogReportKey key, String streamId, String msg, int code, JSONObject info) {
        if (this.logDataInfo == null || this.reportUrl == null) {
            return;
        }
        JSONObject tmpObj = null;
        try {
            tmpObj = new JSONObject(this.logDataInfo.toString());
            tmpObj.put("uid", (Object)this.userid);
            tmpObj.put("aid", (Object)this.aid);
            tmpObj.put("cid", (Object)this.cid);
            tmpObj.put(kSession, (Object)this.sessionId);
            tmpObj.put("id", this.getLogId());
            tmpObj.put(kBU, this.bu);
            tmpObj.put("pf", this.pf);
            tmpObj.put("ld", System.currentTimeMillis());
            tmpObj.put(kVer, (Object)"3.0.0");
            if (streamId != null) {
                tmpObj.put("p", (Object)streamId);
            }
            if (msg != null) {
                String _msg = msg;
                if (code != -1) {
                    _msg = _msg + ":" + code + "";
                }
                tmpObj.put("_m", (Object)_msg);
            } else {
                tmpObj.put("_m", (Object)"");
            }
            if (info != null) {
                Iterator it = info.keys();
                while (it.hasNext()) {
                    String item = (String)it.next();
                    tmpObj.put(item, info.get(item));
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        String token = tmpObj.toString();
        String host = null;
        host = key == VhallLogReportKey.kSignalingConnectSuccess || key == VhallLogReportKey.kSignalingDisconnect ? this.reportUrl : this.reportMonitorUrl;
        String url = null;
        try {
            url = host + "?k=" + key.getValue() + "&token=" + new String(Base64.encode((byte[])token.getBytes(), (int)2), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        VLog.d((String)mTag, (String)("report url:" + url + "token:" + token));
        TempHttpRequest.httpGetAsyncRequest(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void streamStart(Stream stream) {
        if (stream == null) {
            return;
        }
        StreamLogReport streamLogReport = null;
        LogReport logReport = this;
        synchronized (logReport) {
            if (this.mStreamLogReportDic.containsKey(stream.streamId)) {
                streamLogReport = this.mStreamLogReportDic.get(stream.streamId);
            } else {
                streamLogReport = new StreamLogReport();
                this.mStreamLogReportDic.put(stream.streamId, streamLogReport);
            }
        }
        streamLogReport.streamStart(stream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void streamStop(String streamId) {
        if (streamId == null) {
            return;
        }
        LogReport logReport = this;
        synchronized (logReport) {
            if (this.mStreamLogReportDic.containsKey(streamId + "")) {
                StreamLogReport streamLogReport = this.mStreamLogReportDic.get(streamId + "");
                streamLogReport.streamStop();
                this.mStreamLogReportDic.remove(streamId + "");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void streamError(String streamId) {
        if (streamId == null) {
            return;
        }
        LogReport logReport = this;
        synchronized (logReport) {
            if (this.mStreamLogReportDic.containsKey(streamId + "")) {
                StreamLogReport streamLogReport = this.mStreamLogReportDic.get(streamId + "");
                streamLogReport.streamError();
                this.mStreamLogReportDic.remove(streamId + "");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void streamAllStop() {
        LogReport logReport = this;
        synchronized (logReport) {
            for (String key : this.mStreamLogReportDic.keySet()) {
                StreamLogReport streamLogReport = this.mStreamLogReportDic.get(key);
                if (streamLogReport == null) continue;
                streamLogReport.streamStop();
            }
            this.mStreamLogReportDic.clear();
        }
    }

    public void updateLatestStatistics(TRTCStatistics statistics) {
        this.mTRTCStatistics = statistics;
    }

    public HashMap<String, String> fetchStatisticsData(Stream stream) {
        if (null != this.mTRTCStatistics) {
            HashMap<String, String> dataHashMap = new HashMap<String, String>();
            if (stream.isLocal) {
                try {
                    dataHashMap.put("bitrate", String.valueOf(((TRTCStatistics.TRTCLocalStatistics)this.mTRTCStatistics.localArray.get((int)0)).videoBitrate));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    dataHashMap.put("videoWidth", String.valueOf(((TRTCStatistics.TRTCLocalStatistics)this.mTRTCStatistics.localArray.get((int)0)).width));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    dataHashMap.put("videoHeight", String.valueOf(((TRTCStatistics.TRTCLocalStatistics)this.mTRTCStatistics.localArray.get((int)0)).height));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    ArrayList remoteList = this.mTRTCStatistics.remoteArray;
                    if (null != remoteList && !remoteList.isEmpty()) {
                        for (TRTCStatistics.TRTCRemoteStatistics remoteStatistics : remoteList) {
                            if (!remoteStatistics.userId.equals(stream.userId)) continue;
                            dataHashMap.put("bitrate", String.valueOf(remoteStatistics.videoBitrate));
                            dataHashMap.put("videoWidth", String.valueOf(remoteStatistics.width));
                            dataHashMap.put("videoHeight", String.valueOf(remoteStatistics.height));
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return dataHashMap;
        }
        return null;
    }

    public static enum VhallLogType {
        kInfoLogType(5001),
        kLiveInfoLogType(5002);

        private int _value;

        private VhallLogType(int value) {
            this._value = value;
        }

        public int getValue() {
            return this._value;
        }
    }

    public static enum VhallLogReportErrorCode {
        kNoneError(-1),
        kSubscribeError(4001),
        kSubscribeSuccess(2002),
        kPublishError(4002),
        kPublishSuccess(2003);

        private int _value;

        private VhallLogReportErrorCode(int value) {
            this._value = value;
        }

        public int getValue() {
            return this._value;
        }
    }

    public static enum VhallLogReportKey {
        kSignalingConnectSuccess(182001),
        kSignalingDisconnect(182002),
        kSubscribeInfo(182003),
        kPublishInfo(182004);

        private int _value;

        private VhallLogReportKey(int value) {
            this._value = value;
        }

        public int getValue() {
            return this._value;
        }
    }
}

