/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.rtc.trtc;

import android.annotation.SuppressLint;
import com.vhall.ilss.VHInteractiveApi;
import com.vhall.logmanager.VLog;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Response;
import org.json.JSONException;
import org.json.JSONObject;

@SuppressLint(value={"NewApi"})
public class getStreamAttributes
implements AutoCloseable {
    private final String TAG = "VhallTRTC getStreamAttributes";
    private String attributes = "";
    private Call httpCall;

    @Override
    public void close() throws IOException {
        if (this.httpCall != null) {
            this.httpCall.cancel();
        }
    }

    public String getStreamAttributes(String accessToken, String roomId, final String streamId) throws IOException, InterruptedException {
        final CountDownLatch latch = new CountDownLatch(1);
        this.httpCall = VHInteractiveApi.stream_get_attributes(roomId, accessToken, streamId, new Callback(){

            public void onFailure(Call call, IOException e) {
                VLog.e((String)"VhallTRTC getStreamAttributes", (String)("stream_update_attributes failed streamId:" + streamId));
                e.printStackTrace();
                latch.countDown();
            }

            public void onResponse(Call call, Response response) throws IOException {
                if (response.isSuccessful()) {
                    String result = response.body().string();
                    getStreamAttributes.this.attributes = getStreamAttributes.this.parseStreamAttributes(result);
                    VLog.i((String)"VhallTRTC getStreamAttributes", (String)("stream_update_attributes succeeded streamId:" + streamId + " attributes:" + getStreamAttributes.this.attributes));
                }
                latch.countDown();
            }
        });
        latch.await();
        return this.attributes;
    }

    private String parseStreamAttributes(String jsonString) {
        try {
            JSONObject jsonObject = new JSONObject(jsonString);
            int code = jsonObject.getInt("code");
            String msg = jsonObject.getString("msg");
            if (code == 200 && "success".equals(msg)) {
                if (jsonObject.has("data")) {
                    JSONObject data = jsonObject.getJSONObject("data");
                    if (data.has("attributes")) {
                        String attributes = data.getString("attributes");
                        if (attributes != null && !attributes.isEmpty()) {
                            System.out.println("Attributes: " + attributes);
                            return attributes;
                        }
                        System.out.println("Invalid attributes in JSON");
                    } else {
                        System.out.println("JSON does not contain the 'attributes' field");
                    }
                } else {
                    System.out.println("JSON does not contain the 'data' field");
                }
            } else {
                System.out.println("Invalid data in JSON");
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
            System.out.println("Error parsing JSON");
        }
        return "";
    }
}

