/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.rtc.trtc;

import android.content.Context;
import android.media.projection.MediaProjection;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import android.widget.FrameLayout;
import com.tencent.liteav.device.TXDeviceManager;
import com.tencent.rtmp.ui.TXCloudVideoView;
import com.tencent.trtc.TRTCCloud;
import com.tencent.trtc.TRTCCloudDef;
import com.tencent.trtc.TRTCCloudListener;
import com.tencent.trtc.TRTCStatistics;
import com.vhall.framework.common.ICallback;
import com.vhall.ilss.VHInteractiveApi;
import com.vhall.ilss.VHRoomListener;
import com.vhall.logmanager.VLog;
import com.vhall.rtc.Utils;
import com.vhall.rtc.VRTCParams;
import com.vhall.rtc.absrtc.ISwitchFocusModeListener;
import com.vhall.rtc.absrtc.IVHRTC;
import com.vhall.rtc.absrtc.IVHRTCRenderView;
import com.vhall.rtc.trtc.Stream;
import com.vhall.rtc.trtc.TRTCVideoEncodeCompat;
import com.vhall.rtc.trtc.getStreamAttributes;
import com.vhall.rtc.trtc.log.LogReport;
import java.io.IOException;
import java.util.HashMap;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Response;
import org.json.JSONException;
import org.json.JSONObject;

public class VhallTRTCImpl
implements IVHRTC {
    private final String TAG = "VhallTRTC";
    private TRTCCloud mTRTCCloud;
    private TXDeviceManager mTXDeviceManager;
    private VRTCParams.VRTCRoomParamsInner mRoomParams;
    private boolean mAutoPublish;
    private boolean mAutoSubscribe;
    private VHRoomListener mRoomListener = null;
    private int mLocalStreamType;
    private final String TRTC_STREAM_TYPE_MAIN = "main";
    private final String TRTC_STREAM_TYPE_AUXILIARY = "auxiliary";
    private String mLocalTRTCStreamType = "main";
    private HashMap<String, Stream> mStreamList;
    private Stream mLocalStream;
    private VRTCParams.VRTCVideoEncodeParam mInitVideoEncoderParam;
    private String mStreamAttributes;
    private HashMap<String, String> userIdList;
    private int mCurTRTCRole = 21;
    private final String PLACEHOLDER_LOCAL_STREAMID = "placeholder_local_streamid";
    private int mDevicePlatform = 5;
    private String mTempUserId = null;

    public VhallTRTCImpl(Context context) {
        if (null == context) {
            throw new IllegalArgumentException("context should not be null");
        }
        this.mTRTCCloud = TRTCCloud.sharedInstance((Context)context.getApplicationContext());
        this.mTXDeviceManager = this.mTRTCCloud.getDeviceManager();
        this.mStreamList = new HashMap();
        this.userIdList = new HashMap();
    }

    @Override
    public void enterRoom(VRTCParams.VRTCRoomParamsInner roomParams, boolean autoPublish, boolean autoSubscribe, String attribute, VHRoomListener roomListener) {
        this.mRoomParams = roomParams;
        if (null != this.mLocalStream) {
            this.mLocalStream.streamId = this.mRoomParams.userId;
            this.mLocalStream.userId = this.mRoomParams.userId;
            this.mStreamList.remove("placeholder_local_streamid");
            this.addStream2Cache(this.mLocalStream);
        } else {
            this.mTempUserId = this.mRoomParams.userId;
        }
        if (null != this.mTRTCCloud) {
            this.mAutoPublish = autoPublish;
            this.mAutoSubscribe = autoSubscribe;
            if (!this.mAutoSubscribe) {
                this.mTRTCCloud.setDefaultStreamRecvMode(false, false);
            }
            this.mRoomListener = roomListener;
            this.mTRTCCloud.setListener((TRTCCloudListener)new TRTCCloudImplListener());
            TRTCCloudDef.TRTCParams trtcParams = this.makeTRTCParam(roomParams);
            this.mTRTCCloud.enterRoom(trtcParams, 1);
        } else {
            VLog.e((String)"VhallTRTC", (String)"please init first");
        }
    }

    @Override
    public void startLocalPreview(IVHRTCRenderView renderView, VRTCParams.VRTCVideoEncodeParam videoParam, VRTCParams.VRTCStreamParam streamParam, boolean isFrontCamera) {
        this.mLocalStreamType = streamParam.streamType;
        this.mLocalTRTCStreamType = "main";
        this.mInitVideoEncoderParam = videoParam;
        this.mStreamAttributes = streamParam.attributes;
        this.mLocalStream = new Stream();
        this.mLocalStream.isLocal = true;
        if (null != this.mRoomParams) {
            this.mLocalStream.streamId = this.mRoomParams.userId;
            this.mLocalStream.userId = this.mRoomParams.userId;
        } else {
            this.mLocalStream.streamId = "placeholder_local_streamid";
        }
        this.mLocalStream.streamTypeVrtc = this.mLocalStreamType;
        this.mLocalStream.streamTypeTrtc = 0;
        this.addStream2Cache(this.mLocalStream);
        if (null != this.mTRTCCloud) {
            TRTCCloudDef.TRTCRenderParams localRenderParam = new TRTCCloudDef.TRTCRenderParams();
            localRenderParam.fillMode = 0;
            localRenderParam.mirrorType = 0;
            this.mTRTCCloud.setLocalRenderParams(localRenderParam);
            if (this.hasAudio(this.mLocalStreamType)) {
                this.mTRTCCloud.startLocalAudio(1);
            }
            this.updateVideoResolution(videoParam, false);
            if (null != renderView) {
                this.mTRTCCloud.startLocalPreview(isFrontCamera, this.generateRenderView(renderView));
            }
        } else {
            VLog.e((String)"VhallTRTC", (String)"mTRTCCloud should not be null");
        }
        if (null != renderView) {
            renderView.setOnTouchListener(new View.OnTouchListener(){

                public boolean onTouch(View v, MotionEvent event) {
                    return v.onTouchEvent(event);
                }
            });
        }
    }

    @Override
    public void createScreenShareStream(MediaProjection mediaProjection, VRTCParams.VRTCVideoEncodeParam videoParam, VRTCParams.VRTCStreamParam streamParam) {
        VRTCParams.VRTCVideoEncodeParam encodeParam;
        this.mStreamAttributes = streamParam.attributes;
        this.mLocalStreamType = 3;
        this.mLocalTRTCStreamType = "auxiliary";
        if (null == videoParam) {
            encodeParam = new VRTCParams.VRTCVideoEncodeParam();
            encodeParam.videoResolution = 20;
            encodeParam.videoFps = 10;
            encodeParam.videoBitrate = 1200;
            encodeParam.resolutionStrategy = 2;
        } else {
            encodeParam = videoParam;
        }
        this.mInitVideoEncoderParam = encodeParam;
        this.mLocalStream = new Stream();
        this.mLocalStream.isLocal = true;
        if (null != this.mRoomParams) {
            this.mLocalStream.streamId = this.mRoomParams.userId;
            this.mLocalStream.userId = this.mRoomParams.userId;
        }
        this.mLocalStream.streamTypeVrtc = 3;
        this.mLocalStream.streamTypeTrtc = 2;
        this.addStream2Cache(this.mLocalStream);
        TRTCCloudDef.TRTCVideoEncParam trtcVideoEncParam = this.updateVideoResolution(encodeParam, true);
        this.mTRTCCloud.startScreenCapture(this.mLocalStream.streamTypeTrtc, trtcVideoEncParam, new TRTCCloudDef.TRTCScreenShareParams());
    }

    @Override
    public void stopScreenShare() {
        this.mTRTCCloud.stopScreenCapture();
    }

    @Override
    public String getUserIdByStreamId(String streamId) {
        Stream stream = this.getStreamById(streamId);
        return null != stream ? stream.userId : null;
    }

    private void addStream2Cache(Stream stream) {
        if (null != this.mStreamList) {
            this.mStreamList.put(stream.streamId, stream);
        }
    }

    private void removeStreamFromCache(String streamId) {
        if (TextUtils.isEmpty((CharSequence)streamId)) {
            return;
        }
        if (null != this.mStreamList) {
            this.mStreamList.remove(streamId);
        }
        if (null != this.userIdList) {
            this.userIdList.remove(streamId);
        }
    }

    private Stream getStreamById(String streamId) {
        if (TextUtils.isEmpty((CharSequence)streamId)) {
            return null;
        }
        if (null != this.mStreamList && this.mStreamList.containsKey(streamId)) {
            return this.mStreamList.get(streamId);
        }
        return null;
    }

    private boolean containsStreamId(String streamId) {
        return null != this.getStreamById(streamId);
    }

    private TXCloudVideoView generateRenderView(IVHRTCRenderView renderView) {
        if (null == renderView) {
            return null;
        }
        TXCloudVideoView tempRenderView = new TXCloudVideoView(renderView.getContext());
        renderView.bindFramelayout((FrameLayout)tempRenderView);
        return tempRenderView;
    }

    @Override
    public void startRemoteView(IVHRTCRenderView renderView, String streamId) {
        if (null != this.mTRTCCloud) {
            this.mTRTCCloud.muteRemoteAudio(this.userIdList.get(streamId), false);
            Stream stream = this.getStreamById(streamId);
            if (null != stream) {
                this.mTRTCCloud.startRemoteView(this.userIdList.get(streamId), stream.streamTypeTrtc, this.generateRenderView(renderView));
                TRTCCloudDef.TRTCRenderParams param = new TRTCCloudDef.TRTCRenderParams();
                param.fillMode = 1;
                param.mirrorType = 2;
                this.mTRTCCloud.setRemoteRenderParams(this.userIdList.get(streamId), stream.streamTypeTrtc, param);
            } else {
                VLog.e((String)"VhallTRTC", (String)"streamId do not exists");
            }
        } else {
            VLog.e((String)"VhallTRTC", (String)"mTRTCCloud should not be null");
        }
    }

    @Override
    public void publish() {
        if (null != this.mTRTCCloud) {
            if (!this.mStreamAttributes.isEmpty()) {
                VHInteractiveApi.stream_update_attributes(this.mRoomParams.roomParams.inavRoomId, this.mRoomParams.roomParams.accessToken, this.getCombinedStreamId(this.mRoomParams.userId), this.mStreamAttributes, new Callback(){

                    public void onFailure(Call call, IOException e) {
                        VLog.e((String)"VhallTRTC", (String)"stream_update_attributes failed");
                    }

                    public void onResponse(Call call, Response response) throws IOException {
                        VLog.i((String)"VhallTRTC", (String)"stream_update_attributes succeeded");
                    }
                });
                VHInteractiveApi.stream_get_attributes(this.mRoomParams.roomParams.inavRoomId, this.mRoomParams.roomParams.accessToken, this.getCombinedStreamId(this.mRoomParams.userId), new Callback(){

                    public void onFailure(Call call, IOException e) {
                        VLog.e((String)"VhallTRTC", (String)"stream_update_attributes failed");
                    }

                    public void onResponse(Call call, Response response) throws IOException {
                        String result = response.body().string();
                        VLog.i((String)"VhallTRTC", (String)"stream_update_attributes succeeded");
                    }
                });
            }
            this.mCurTRTCRole = 20;
            this.mTRTCCloud.switchRole(20);
        } else {
            VLog.e((String)"VhallTRTC", (String)"mTRTCCloud should not be null");
        }
    }

    @Override
    public void unPublish() {
        if (null != this.mTRTCCloud) {
            this.mCurTRTCRole = 21;
            this.mTRTCCloud.switchRole(21);
        } else {
            VLog.e((String)"VhallTRTC", (String)"mTRTCCloud should not be null");
        }
    }

    @Override
    public void subscribe(String streamId) {
        if (null != this.mRoomListener) {
            Stream stream = this.getStreamById(streamId);
            if (null == stream) {
                return;
            }
            String bzUserId = stream.userId;
            this.mRoomListener.onDidSubscribeStream(bzUserId, streamId);
            LogReport.instance().streamStart(stream);
        }
    }

    @Override
    public void unSubscribe(String streamId) {
        if (null != this.mTRTCCloud) {
            this.mTRTCCloud.muteRemoteAudio(this.userIdList.get(streamId), true);
        } else {
            VLog.e((String)"VhallTRTC", (String)"mTRTCCloud should not be null");
        }
        this.muteVideo(streamId, true);
        if (null != this.mRoomListener) {
            HashMap<String, String> user = this.tryParseWebStyleUserId(streamId);
            this.mRoomListener.onDidUnSubscribeStream(user.get("userId"), streamId);
        }
    }

    @Override
    public void leaveRoom() {
        if (null != this.mTRTCCloud) {
            this.mTRTCCloud.exitRoom();
            LogReport.instance().streamAllStop();
        } else {
            VLog.e((String)"VhallTRTC", (String)"mTRTCCloud should not be null");
        }
    }

    @Override
    public void muteVideo(String streamId, boolean mute) {
        if (null != this.mTRTCCloud) {
            if (TextUtils.isEmpty((CharSequence)streamId)) {
                this.mTRTCCloud.muteLocalVideo(this.isMainTRTCStream() ? 0 : 2, mute);
                this.notifyEvent(this.getUserId(), mute ? "MUTE_VIDEO" : "UN_MUTE_VIDEO");
            } else {
                HashMap<String, String> user = this.tryParseWebStyleUserId(streamId);
                int type = user.get("vrtcStreamType").equals(String.valueOf(2)) ? 0 : 2;
                this.mTRTCCloud.muteRemoteVideoStream(this.userIdList.get(streamId), type, mute);
            }
        } else {
            VLog.e((String)"VhallTRTC", (String)"mTRTCCloud should not be null");
        }
    }

    @Override
    public void muteAudio(String streamId, boolean mute) {
        if (null != this.mTRTCCloud) {
            if (TextUtils.isEmpty((CharSequence)streamId)) {
                this.mTRTCCloud.muteLocalAudio(mute);
                this.notifyEvent(this.getUserId(), mute ? "MUTE_AUDIO" : "UN_MUTE_AUDIO");
            } else {
                this.mTRTCCloud.muteRemoteAudio(this.userIdList.get(streamId), mute);
            }
        } else {
            VLog.e((String)"VhallTRTC", (String)"mTRTCCloud should not be null");
        }
    }

    @Override
    public void switchCamera() {
        if (null != this.mTXDeviceManager) {
            this.mTXDeviceManager.switchCamera(!this.mTXDeviceManager.isFrontCamera());
        }
    }

    @Override
    public boolean isFrontCamera() {
        return null == this.mTXDeviceManager || this.mTXDeviceManager.isFrontCamera();
    }

    @Override
    public void setMirror(boolean isMirror) {
        if (null != this.mTRTCCloud) {
            TRTCCloudDef.TRTCRenderParams localRenderParam = new TRTCCloudDef.TRTCRenderParams();
            localRenderParam.mirrorType = isMirror ? 1 : 2;
            this.mTRTCCloud.setLocalRenderParams(localRenderParam);
        } else {
            VLog.e((String)"VhallTRTC", (String)"mTRTCCloud should not be null");
        }
    }

    @Override
    public void switchAutoFocusMode(boolean enableAuto, ISwitchFocusModeListener switchFocusModeListener) {
        this.mTXDeviceManager.enableCameraAutoFocus(enableAuto);
        if (null != switchFocusModeListener) {
            switchFocusModeListener.onComplete(true, null);
        }
    }

    @Override
    public void release() {
        if (null != this.mStreamList) {
            this.mStreamList.clear();
            this.mStreamList = null;
        }
        this.mLocalStream = null;
        this.mInitVideoEncoderParam = null;
        if (this.mTRTCCloud != null) {
            this.mTRTCCloud.stopAllRemoteView();
            this.mTRTCCloud.stopLocalAudio();
            this.mTRTCCloud.stopLocalPreview();
            this.leaveRoom();
            this.mTRTCCloud.setListener(null);
        }
        this.mTRTCCloud = null;
        TRTCCloud.destroySharedInstance();
    }

    @Override
    public void setScaleType(int scaleType) {
        if (null != this.mTRTCCloud) {
            TRTCCloudDef.TRTCRenderParams localRenderParam = new TRTCCloudDef.TRTCRenderParams();
            localRenderParam.fillMode = this.convertScaleType2TRTCMode(scaleType);
            this.mTRTCCloud.setLocalRenderParams(localRenderParam);
        } else {
            VLog.e((String)"VhallTRTC", (String)"mTRTCCloud should not be null");
        }
    }

    @Override
    public void setVideoResolution(int videoProfile) {
        if (null != this.mTRTCCloud) {
            this.mInitVideoEncoderParam.videoResolution = videoProfile;
            this.updateVideoResolution(this.mInitVideoEncoderParam, false);
        } else {
            VLog.e((String)"VhallTRTC", (String)"mTRTCCloud should not be null");
        }
    }

    private TRTCCloudDef.TRTCVideoEncParam updateVideoResolution(VRTCParams.VRTCVideoEncodeParam videoParam, boolean isScreenShare) {
        TRTCVideoEncodeCompat.compat(videoParam);
        TRTCCloudDef.TRTCVideoEncParam encParam = new TRTCCloudDef.TRTCVideoEncParam();
        encParam.videoResolution = videoParam.videoResolution2TRTC;
        encParam.videoFps = videoParam.videoFps;
        encParam.videoResolutionMode = 1;
        encParam.videoBitrate = videoParam.videoBitrate;
        if (videoParam.resolutionStrategy == 3) {
            encParam.minVideoBitrate = 0;
            encParam.enableAdjustRes = true;
        } else if (videoParam.resolutionStrategy == 0) {
            encParam.minVideoBitrate = videoParam.videoBitrate;
            encParam.enableAdjustRes = false;
        } else if (videoParam.resolutionStrategy == 2) {
            encParam.minVideoBitrate = (int)((double)videoParam.videoBitrate * 0.6);
            encParam.enableAdjustRes = false;
        } else if (videoParam.resolutionStrategy == 1) {
            encParam.minVideoBitrate = 100;
            encParam.enableAdjustRes = true;
        }
        if (!isScreenShare) {
            this.mTRTCCloud.setVideoEncoderParam(encParam);
        }
        return encParam;
    }

    @Override
    public void setDefaultAudioDevice(Object object) {
    }

    @Override
    public void broadcastRoom(VRTCParams.VRTCBroadcastParamInner broadcastParam, String accessToken, final ICallback callback) {
        if (null == broadcastParam || null == broadcastParam.broadcastParam) {
            VHInteractiveApi.stopBroadcastTRTC(this.mRoomParams.roomParams.inavRoomId, accessToken, new Callback(){

                public void onFailure(Call call, IOException e) {
                    if (null != callback) {
                        callback.onFailure(10004, null != e ? e.getMessage() : null);
                    }
                }

                public void onResponse(Call call, Response response) throws IOException {
                    if (null != callback) {
                        Utils.parseOkHttpCallback(callback, response);
                    }
                    if (null != VhallTRTCImpl.this.mRoomListener) {
                        VhallTRTCImpl.this.mRoomListener.onStreamMixed(new JSONObject());
                    }
                }
            });
        } else {
            VHInteractiveApi.startBroadcastTRTC(broadcastParam, accessToken, new Callback(){

                public void onFailure(Call call, IOException e) {
                    if (null != callback) {
                        callback.onFailure(10004, null != e ? e.getMessage() : null);
                    }
                }

                public void onResponse(Call call, Response response) throws IOException {
                    if (null != callback) {
                        Utils.parseOkHttpCallback(callback, response);
                    }
                    if (null != VhallTRTCImpl.this.mRoomListener) {
                        VhallTRTCImpl.this.mRoomListener.onStreamMixed(new JSONObject());
                    }
                }
            });
        }
    }

    @Override
    public void setMixLayoutMainScreen(String streamId, final ICallback callback) {
        if (TextUtils.isEmpty((CharSequence)streamId)) {
            streamId = this.mLocalStream.streamId;
        }
        VHInteractiveApi.setMixMainScreenTRTC(this.mRoomParams.roomParams.inavRoomId, this.userIdList.get(streamId) == null || this.userIdList.get(streamId).isEmpty() ? streamId : this.userIdList.get(streamId), this.mRoomParams.roomParams.accessToken, new Callback(){

            public void onFailure(Call call, IOException e) {
                callback.onFailure(10004, null != e ? e.getMessage() : null);
            }

            public void onResponse(Call call, Response response) throws IOException {
                if (null != callback) {
                    Utils.parseOkHttpCallback(callback, response);
                }
            }
        });
    }

    @Override
    public void setMixLayoutMode(VRTCParams.VRTCBroadcastParamInner broadcastParam, int layoutMode, ICallback callback) {
        broadcastParam.isAdaptiveLayoutMode = layoutMode >= 1000;
        broadcastParam.broadcastParam.layoutMode = layoutMode;
        broadcastParam.compat_layout_mode = Utils.compatAdaptiveLayoutMode(layoutMode);
        this.broadcastRoom(broadcastParam, this.mRoomParams.roomParams.accessToken, callback);
    }

    @Override
    public void setMixBackgroundColor(VRTCParams.VRTCBroadcastParamInner broadcastParam, String hexColor, ICallback callback) {
        broadcastParam.broadcastParam.backgroundColor = Utils.compatColor2HexStyle(hexColor);
        this.broadcastRoom(broadcastParam, this.mRoomParams.roomParams.accessToken, callback);
    }

    @Override
    public void setMixBackgroundImage(VRTCParams.VRTCBroadcastParamInner broadcastParam, String url, int cropType, ICallback callback) {
        broadcastParam.broadcastParam.backgroundImageUrl = url;
        this.broadcastRoom(broadcastParam, this.mRoomParams.roomParams.accessToken, callback);
    }

    @Override
    public void setMixBorderColor(VRTCParams.VRTCBroadcastParam.Border border, ICallback callback) {
        VLog.e((String)"VhallTRTC", (String)"TRTC\u6682\u4e0d\u652f\u6301\u8bbe\u7f6e\u65c1\u8def\u8fb9\u6846");
    }

    @Override
    public void setDataReport(JSONObject dataReport) {
        if (null != dataReport) {
            LogReport logReport = LogReport.instance();
            logReport.setLogDataInfo(dataReport);
            if (dataReport.has("pf")) {
                this.mDevicePlatform = dataReport.optInt("pf");
            }
        }
    }

    @Override
    public void setMixPlaceholderImage(String url, ICallback callback) {
        VLog.e((String)"VhallTRTC", (String)"TRTC\u6682\u4e0d\u652f\u6301\u8bbe\u7f6e\u65c1\u8def\u7a97\u683c\u5360\u4f4d\u56fe");
        if (null != callback) {
            callback.onFailure(10005, "TRTC\u6682\u4e0d\u652f\u6301\u8bbe\u7f6e\u65c1\u8def\u7a97\u683c\u5360\u4f4d\u56fe");
        }
    }

    @Override
    public void docCloudRender(String appId, String channelId, boolean start, final ICallback callback) {
        VHInteractiveApi.docCloudRender(this.mRoomParams.roomParams.inavRoomId, this.mRoomParams.roomParams.accessToken, channelId, start, new Callback(){

            public void onFailure(Call call, IOException e) {
                callback.onFailure(10007, null != e ? e.getMessage() : null);
            }

            public void onResponse(Call call, Response response) throws IOException {
                if (null != callback) {
                    Utils.parseOkHttpCallback(callback, response);
                }
            }
        });
        VLog.e((String)"VhallTRTC", (String)("docCloudRender " + appId + " " + channelId + " " + start));
    }

    private TRTCCloudDef.TRTCParams makeTRTCParam(VRTCParams.VRTCRoomParamsInner roomParams) {
        TRTCCloudDef.TRTCParams trtcParams = new TRTCCloudDef.TRTCParams();
        trtcParams.sdkAppId = roomParams.trtcSdkAppId;
        trtcParams.userId = roomParams.userId;
        trtcParams.strRoomId = roomParams.roomParams.inavRoomId;
        trtcParams.userSig = roomParams.inavToken;
        trtcParams.role = 21;
        this.mCurTRTCRole = 21;
        return trtcParams;
    }

    private String userIdToStreamId(String userId, int trtcStreamType) {
        if (this.isStreamFromWeb(userId)) {
            return userId;
        }
        StringBuilder stringBuilder = new StringBuilder(userId);
        stringBuilder.append(":").append(0 == trtcStreamType ? "main" : "auxiliary").append(":").append(0 == trtcStreamType ? 2 : 3);
        return stringBuilder.toString();
    }

    private void doWhenRemoteStreamAvailable(String userId, int trtcStreamType, int vrtcStreamType) {
        HashMap<String, String> user = this.tryParseWebStyleUserId(userId);
        String streamId = userId;
        if (!this.isStreamFromWeb(userId)) {
            StringBuilder stringBuilder = new StringBuilder(userId);
            stringBuilder.append(":").append(0 == trtcStreamType ? "main" : "auxiliary").append(":").append(vrtcStreamType >= 0 ? vrtcStreamType : (0 == trtcStreamType ? 2 : 3));
            streamId = stringBuilder.toString();
        }
        this.userIdList.put(streamId, userId);
        if (!this.containsStreamId(streamId)) {
            this.addStream2Cache(this.mockRemoteStream(user.get("userId"), streamId, trtcStreamType, vrtcStreamType));
            if (null != this.mRoomListener) {
                this.mRoomListener.onDidAddStream(user.get("userId"), streamId);
            }
            if (this.mAutoSubscribe) {
                this.subscribe(streamId);
            }
        }
    }

    private boolean isStreamFromWeb(String userStreamId) {
        return !TextUtils.isEmpty((CharSequence)userStreamId) && userStreamId.contains(":");
    }

    private HashMap<String, String> tryParseWebStyleUserId(String originUserId) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        resultMap.put("vrtcStreamType", "-1");
        if (!TextUtils.isEmpty((CharSequence)originUserId) && originUserId.contains(":")) {
            String realUserId = null;
            String vrtcStreamType = null;
            try {
                String[] splitId = originUserId.split(":");
                realUserId = splitId[0];
                vrtcStreamType = splitId[2];
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (!TextUtils.isEmpty(realUserId)) {
                resultMap.put("userId", realUserId);
                resultMap.put("vrtcStreamType", vrtcStreamType);
            } else {
                resultMap.put("userId", originUserId);
            }
        } else {
            resultMap.put("userId", originUserId);
        }
        return resultMap;
    }

    private void notifyEvent(String userId, String event) {
        VHInteractiveApi.eventNotifyTRTC(this.mRoomParams.roomParams.inavRoomId, this.getCombinedStreamId(userId), event, this.mRoomParams.roomParams.accessToken, null);
    }

    private String getCombinedStreamId(String streamId) {
        Stream stream = this.getStreamById(streamId);
        if (null != stream) {
            if (!TextUtils.isEmpty((CharSequence)streamId) && !streamId.contains(":")) {
                StringBuilder stringBuilder = new StringBuilder(stream.userId);
                stringBuilder.append(":").append(0 == stream.streamTypeTrtc ? "main" : "auxiliary").append(":").append(stream.streamTypeVrtc);
                return stringBuilder.toString();
            }
        } else {
            VLog.e((String)"VhallTRTC", (String)("target streamId does not exists, streamId:" + streamId));
        }
        return streamId;
    }

    private Stream mockRemoteStream(String userId, String streamId, int trtcStreamType, int vrtcStreamType) {
        Stream remoteStream = new Stream();
        remoteStream.streamId = streamId;
        remoteStream.userId = userId;
        remoteStream.isLocal = false;
        int n = trtcStreamType >= 0 ? trtcStreamType : (remoteStream.streamTypeTrtc = !this.isStreamFromWeb(streamId) && 3 == vrtcStreamType ? 2 : 0);
        remoteStream.streamTypeVrtc = vrtcStreamType >= 0 ? vrtcStreamType : (0 == trtcStreamType ? 2 : 3);
        try (getStreamAttributes requestAttributes = new getStreamAttributes();){
            remoteStream.attributes = requestAttributes.getStreamAttributes(this.mRoomParams.roomParams.accessToken, this.mRoomParams.roomParams.inavRoomId, streamId);
            VLog.i((String)"VhallTRTC", (String)("attributes:" + remoteStream.attributes));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return remoteStream;
    }

    private String getUserId() {
        return null != this.mRoomParams ? this.mRoomParams.userId : null;
    }

    private boolean hasAudio(int vrtcStreamType) {
        return vrtcStreamType != 1;
    }

    private boolean isMainTRTCStream() {
        return "main".equals(this.mLocalTRTCStreamType);
    }

    private int convertScaleType2TRTCMode(int scaleType) {
        int trtcScaleType;
        switch (scaleType) {
            default: {
                trtcScaleType = 0;
                break;
            }
            case 1: {
                trtcScaleType = 1;
            }
        }
        return trtcScaleType;
    }

    private class TRTCCloudImplListener
    extends TRTCCloudListener {
        private TRTCCloudImplListener() {
        }

        public void onEnterRoom(long result) {
            VLog.d((String)"VhallTRTC", (String)("onEnterRoom, result=" + result));
            if (null != VhallTRTCImpl.this.mRoomListener) {
                try {
                    VhallTRTCImpl.this.mRoomListener.onDidConnect(new JSONObject().put("result", result));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            if (VhallTRTCImpl.this.mAutoPublish) {
                VhallTRTCImpl.this.publish();
            }
            String clientId = String.valueOf(System.currentTimeMillis());
            LogReport.instance().setLogRoominfo(((VhallTRTCImpl)VhallTRTCImpl.this).mRoomParams.userId, ((VhallTRTCImpl)VhallTRTCImpl.this).mRoomParams.roomParams.inavRoomId, clientId, VhallTRTCImpl.this.mDevicePlatform);
        }

        public void onExitRoom(int reason) {
            VLog.d((String)"VhallTRTC", (String)("onExitRoom, reason=" + reason));
            if (null != VhallTRTCImpl.this.mRoomListener) {
                VhallTRTCImpl.this.mRoomListener.onDidExitRoom();
            }
        }

        public void onError(int errCode, String errMsg, Bundle extraInfo) {
            VLog.e((String)"VhallTRTC", (String)("onError, errCode=" + errMsg + ", errMsg=" + errMsg + ", extraInfo=" + (null != extraInfo ? extraInfo.toString() : null)));
            if (null != VhallTRTCImpl.this.mRoomListener) {
                if (errCode == -1301 || errCode == -1314 || errCode == -1315 || errCode == -1316) {
                    VhallTRTCImpl.this.mRoomListener.onCameraError(errCode, errMsg);
                } else {
                    VhallTRTCImpl.this.mRoomListener.onDidError(errCode, errMsg, null != extraInfo ? extraInfo.toString() : null);
                }
            }
        }

        public void onWarning(int warningCode, String warningMsg, Bundle extraInfo) {
            VLog.d((String)"VhallTRTC", (String)("onWarning, warningCode=" + warningCode + ", warningMsg=" + warningMsg + ", extraInfo=" + (null != extraInfo ? extraInfo.toString() : null)));
            if (null != VhallTRTCImpl.this.mRoomListener) {
                VhallTRTCImpl.this.mRoomListener.onWarning(warningCode, warningMsg, null != extraInfo ? extraInfo.toString() : null);
            }
        }

        public void onSwitchRole(int errCode, String errMsg) {
            VLog.e((String)"VhallTRTC", (String)("onSwitchRole, errCode=" + errCode + ", errMsg=" + errMsg));
            if (0 == errCode) {
                if (null != VhallTRTCImpl.this.mRoomListener) {
                    if (20 == VhallTRTCImpl.this.mCurTRTCRole) {
                        VhallTRTCImpl.this.mRoomListener.onDidPublishStream(VhallTRTCImpl.this.getUserId(), VhallTRTCImpl.this.getUserId());
                        VhallTRTCImpl.this.notifyEvent(VhallTRTCImpl.this.getUserId(), "PUBLISH");
                        LogReport.instance().streamStart(VhallTRTCImpl.this.mLocalStream);
                    } else if (21 == VhallTRTCImpl.this.mCurTRTCRole) {
                        VhallTRTCImpl.this.mRoomListener.onDidUnPublishStream(VhallTRTCImpl.this.getUserId(), VhallTRTCImpl.this.getUserId());
                        VhallTRTCImpl.this.notifyEvent(VhallTRTCImpl.this.getUserId(), "UN_PUBLISH");
                        LogReport.instance().streamStop(((VhallTRTCImpl)VhallTRTCImpl.this).mLocalStream.streamId);
                    }
                }
            } else {
                if (20 == VhallTRTCImpl.this.mCurTRTCRole) {
                    VhallTRTCImpl.this.mCurTRTCRole = 21;
                } else if (21 == VhallTRTCImpl.this.mCurTRTCRole) {
                    VhallTRTCImpl.this.mCurTRTCRole = 20;
                }
                if (null != VhallTRTCImpl.this.mRoomListener) {
                    JSONObject extraInfo = new JSONObject();
                    try {
                        extraInfo.put("errcode_trtc", errCode);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                    VhallTRTCImpl.this.mRoomListener.onDidError(11002, errMsg, extraInfo.toString());
                }
            }
        }

        public void onFirstVideoFrame(String userId, int streamType, int width, int height) {
            VLog.d((String)"VhallTRTC", (String)("onFirstVideoFrame, userId=" + userId + ", streamType=" + streamType + ", width=" + width + ", height=" + height));
            if (null != VhallTRTCImpl.this.mRoomListener) {
                VhallTRTCImpl.this.mRoomListener.onFirstFrameAvailable(TextUtils.isEmpty((CharSequence)userId), userId, width, height);
            }
        }

        public void onRemoteUserEnterRoom(String userId) {
            VLog.d((String)"VhallTRTC", (String)("onRemoteUserEnterRoom, userId=" + userId));
            if (VhallTRTCImpl.this.isStreamFromWeb(userId)) {
                HashMap user = VhallTRTCImpl.this.tryParseWebStyleUserId(userId);
                if (100 == Integer.parseInt((String)user.get("vrtcStreamType"))) {
                    return;
                }
                VhallTRTCImpl.this.doWhenRemoteStreamAvailable(userId, -1, Integer.parseInt((String)user.get("vrtcStreamType")));
            }
        }

        private void removeRemoteStream(String streamId) {
            HashMap user = VhallTRTCImpl.this.tryParseWebStyleUserId(streamId);
            if (null == VhallTRTCImpl.this.getStreamById(streamId)) {
                return;
            }
            VhallTRTCImpl.this.removeStreamFromCache(streamId);
            if (null != VhallTRTCImpl.this.mRoomListener) {
                VhallTRTCImpl.this.mRoomListener.onDidRemoveStream((String)user.get("userId"), streamId);
            }
            LogReport.instance().streamStop(streamId);
        }

        public void onRemoteUserLeaveRoom(String userId, int reason) {
            VLog.d((String)"VhallTRTC", (String)("onRemoteUserLeaveRoom, userId=" + userId + ", reason=" + reason));
            HashMap user = VhallTRTCImpl.this.tryParseWebStyleUserId(userId);
            if (100 == Integer.parseInt((String)user.get("vrtcStreamType"))) {
                return;
            }
            if (!VhallTRTCImpl.this.isStreamFromWeb(userId)) {
                String streamId = VhallTRTCImpl.this.userIdToStreamId(userId, 2);
                this.removeRemoteStream(streamId);
                streamId = VhallTRTCImpl.this.userIdToStreamId(userId, 0);
                this.removeRemoteStream(streamId);
            } else {
                this.removeRemoteStream(userId);
            }
        }

        public void onTryToReconnect() {
            VLog.e((String)"VhallTRTC", (String)"onTryToReconnect");
            if (null != VhallTRTCImpl.this.mRoomListener) {
                VhallTRTCImpl.this.mRoomListener.onReconnect(0, 0);
            }
        }

        public void onUserVideoAvailable(String userId, boolean available) {
            VLog.d((String)"VhallTRTC", (String)("onUserVideoAvailable, userId=" + userId + ", available" + available));
            HashMap user = VhallTRTCImpl.this.tryParseWebStyleUserId(userId);
            if (100 == Integer.parseInt((String)user.get("vrtcStreamType"))) {
                return;
            }
            if (available && !VhallTRTCImpl.this.isStreamFromWeb(userId)) {
                VhallTRTCImpl.this.doWhenRemoteStreamAvailable(userId, 0, -1);
            }
            if (null != VhallTRTCImpl.this.mRoomListener) {
                JSONObject jsonObject = new JSONObject();
                try {
                    jsonObject.put("video", available);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                VhallTRTCImpl.this.mRoomListener.onDidUpdateOfStreamV2(VhallTRTCImpl.this.userIdToStreamId(userId, 0), jsonObject);
            }
        }

        public void onUserSubStreamAvailable(String userId, boolean available) {
            VLog.d((String)"VhallTRTC", (String)("onUserSubStreamAvailable, userId=" + userId + ", available" + available));
            HashMap user = VhallTRTCImpl.this.tryParseWebStyleUserId(userId);
            if (100 == Integer.parseInt((String)user.get("vrtcStreamType"))) {
                return;
            }
            if (available && !VhallTRTCImpl.this.isStreamFromWeb(userId)) {
                VhallTRTCImpl.this.doWhenRemoteStreamAvailable(userId, 2, -1);
            }
            if (!available) {
                String streamId = userId;
                if (!VhallTRTCImpl.this.isStreamFromWeb(userId)) {
                    streamId = VhallTRTCImpl.this.userIdToStreamId(userId, 2);
                }
                VhallTRTCImpl.this.removeStreamFromCache(streamId);
                if (null != VhallTRTCImpl.this.mRoomListener) {
                    VhallTRTCImpl.this.mRoomListener.onDidRemoveStream((String)user.get("userId"), streamId);
                }
            }
        }

        public void onUserAudioAvailable(String userId, boolean available) {
            VLog.d((String)"VhallTRTC", (String)("onUserAudioAvailable, userId=" + userId + ", available" + available));
            if (available && !VhallTRTCImpl.this.isStreamFromWeb(userId)) {
                VhallTRTCImpl.this.doWhenRemoteStreamAvailable(userId, 0, -1);
            }
            if (null != VhallTRTCImpl.this.mRoomListener) {
                JSONObject jsonObject = new JSONObject();
                try {
                    jsonObject.put("audio", available);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                VhallTRTCImpl.this.mRoomListener.onDidUpdateOfStreamV2(VhallTRTCImpl.this.userIdToStreamId(userId, 0), jsonObject);
            }
        }

        public void onUserVideoSizeChanged(String userId, int streamType, int newWidth, int newHeight) {
            VLog.d((String)"VhallTRTC", (String)("onUserVideoSizeChanged, userId=" + userId + ", streamType=" + streamType + ", newWidth=" + newWidth + ", newHeight=" + newHeight));
            if (null != VhallTRTCImpl.this.mRoomListener) {
                JSONObject jsonObject = new JSONObject();
                try {
                    jsonObject.put("newWidth", newWidth);
                    jsonObject.put("newHeight", newHeight);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                VhallTRTCImpl.this.mRoomListener.onDidUpdateOfStreamV2(VhallTRTCImpl.this.userIdToStreamId(userId, streamType), jsonObject);
            }
        }

        public void onStatistics(TRTCStatistics statistics) {
            if (null != statistics) {
                LogReport.instance().updateLatestStatistics(statistics);
            }
        }
    }
}

