/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.rtc.trtc;

import com.vhall.logmanager.VLog;
import com.vhall.rtc.VRTCParams;

class TRTCVideoEncodeCompat {
    private static final String TAG = "TRTCVideoEncodeCompat";

    TRTCVideoEncodeCompat() {
    }

    public static void compat(VRTCParams.VRTCVideoEncodeParam encodeParam) {
        if (encodeParam.videoWidth > 0 || encodeParam.videoHeight > 0) {
            VLog.d((String)TAG, (String)"TRTC \u6a21\u5f0f\u4e0b\u81ea\u5b9a\u4e49\u5bbd\u9ad8\u65e0\u6548\uff0c\u8bf7\u4f7f\u7528videoResolution\u5b57\u6bb5\uff0c\u503c\u53c2\u8003VRTCCode#RTCVideoProfile");
        }
        switch (encodeParam.videoResolution) {
            case 21: {
                encodeParam.videoResolution2TRTC = 114;
                TRTCVideoEncodeCompat.tryFitWithRecommendValue(encodeParam, 20, 3000);
                break;
            }
            default: {
                encodeParam.videoResolution2TRTC = 112;
                TRTCVideoEncodeCompat.tryFitWithRecommendValue(encodeParam, 20, 1800);
                break;
            }
            case 19: {
                encodeParam.videoResolution2TRTC = 110;
                TRTCVideoEncodeCompat.tryFitWithRecommendValue(encodeParam, 20, 1300);
                break;
            }
            case 18: {
                encodeParam.videoResolution2TRTC = 108;
                TRTCVideoEncodeCompat.tryFitWithRecommendValue(encodeParam, 20, 900);
                break;
            }
            case 17: {
                encodeParam.videoResolution2TRTC = 106;
                TRTCVideoEncodeCompat.tryFitWithRecommendValue(encodeParam, 20, 550);
            }
            case 16: {
                encodeParam.videoResolution2TRTC = 104;
                TRTCVideoEncodeCompat.tryFitWithRecommendValue(encodeParam, 20, 400);
                break;
            }
            case 15: {
                encodeParam.videoResolution2TRTC = 102;
                TRTCVideoEncodeCompat.tryFitWithRecommendValue(encodeParam, 20, 300);
            }
            case 14: {
                encodeParam.videoResolution2TRTC = 100;
                TRTCVideoEncodeCompat.tryFitWithRecommendValue(encodeParam, 20, 250);
                break;
            }
            case 13: {
                encodeParam.videoResolution2TRTC = 64;
                TRTCVideoEncodeCompat.tryFitWithRecommendValue(encodeParam, 20, 1500);
                break;
            }
            case 12: {
                encodeParam.videoResolution2TRTC = 62;
                TRTCVideoEncodeCompat.tryFitWithRecommendValue(encodeParam, 20, 900);
                break;
            }
            case 11: {
                encodeParam.videoResolution2TRTC = 60;
                TRTCVideoEncodeCompat.tryFitWithRecommendValue(encodeParam, 20, 600);
                break;
            }
            case 10: {
                encodeParam.videoResolution2TRTC = 58;
                TRTCVideoEncodeCompat.tryFitWithRecommendValue(encodeParam, 20, 450);
            }
            case 9: {
                encodeParam.videoResolution2TRTC = 56;
                TRTCVideoEncodeCompat.tryFitWithRecommendValue(encodeParam, 20, 375);
                break;
            }
            case 8: {
                encodeParam.videoResolution2TRTC = 54;
                TRTCVideoEncodeCompat.tryFitWithRecommendValue(encodeParam, 20, 300);
                break;
            }
            case 7: {
                encodeParam.videoResolution2TRTC = 52;
                TRTCVideoEncodeCompat.tryFitWithRecommendValue(encodeParam, 20, 225);
                break;
            }
            case 5: 
            case 6: {
                encodeParam.videoResolution2TRTC = 50;
                TRTCVideoEncodeCompat.tryFitWithRecommendValue(encodeParam, 20, 150);
            }
        }
    }

    private static void fitVideoFps(VRTCParams.VRTCVideoEncodeParam encodeParam, int defaultValue) {
        if (encodeParam.videoFps <= 0) {
            encodeParam.videoFps = defaultValue;
        }
    }

    private static void fitVideoBitrate(VRTCParams.VRTCVideoEncodeParam encodeParam, int defaultValue) {
        if (encodeParam.videoBitrate <= 0) {
            encodeParam.videoBitrate = defaultValue;
        }
    }

    private static void tryFitWithRecommendValue(VRTCParams.VRTCVideoEncodeParam encodeParam, int videoFps, int bitrate) {
        TRTCVideoEncodeCompat.fitVideoFps(encodeParam, videoFps);
        TRTCVideoEncodeCompat.fitVideoBitrate(encodeParam, bitrate);
    }
}

