/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.ilss;

import android.text.TextUtils;
import com.vhall.framework.VHAPI;
import com.vhall.rtc.VRTCParams;
import java.util.concurrent.TimeUnit;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.FormBody;
import okhttp3.OkHttpClient;
import okhttp3.RequestBody;

public class VHInteractiveApi {
    public static final String TYPE_INAV = "Inav";

    protected static void getPermission(String resId, String accessToken, String permission, Callback callback) {
        FormBody.Builder builder = VHAPI.getBaseBuilder((String)accessToken).add("resourse_id", resId).add("permission", permission);
        Call call = VHAPI.getOkHttpClient().newCall(VHAPI.getRequest((String)"v2/inav/get-access-token-permission", (RequestBody)builder.build()));
        if (callback == null) {
            call.enqueue((Callback)new VHAPI.DefaultCallback());
        } else {
            call.enqueue(callback);
        }
    }

    protected static void getRoomInfo(String roomid, String accessToken, String broadcastid, String mode, String role, Callback callback) {
        FormBody.Builder builder = VHAPI.getBaseBuilder((String)accessToken).add("inav_id", roomid);
        if (!TextUtils.isEmpty((CharSequence)broadcastid)) {
            builder.add("room_id", broadcastid);
        }
        if (!TextUtils.isEmpty((CharSequence)mode)) {
            builder.add("mode", mode);
        }
        if (!TextUtils.isEmpty((CharSequence)role)) {
            builder.add("role", role);
        }
        Call call = VHAPI.getOkHttpClient().newCall(VHAPI.getRequest((String)"v2/inav/get-inav-info", (RequestBody)builder.build()));
        if (callback == null) {
            call.enqueue((Callback)new VHAPI.DefaultCallback());
        } else {
            call.enqueue(callback);
        }
    }

    protected static void getRoomMember(String roomid, String accessToken, Callback callback) {
        FormBody.Builder builder = VHAPI.getBaseBuilder((String)accessToken).add("inav_id", roomid);
        Call call = VHAPI.getOkHttpClient().newCall(VHAPI.getRequest((String)"v2/inav/inav-user-list", (RequestBody)builder.build()));
        if (callback == null) {
            call.enqueue((Callback)new VHAPI.DefaultCallback());
        } else {
            call.enqueue(callback);
        }
    }

    protected static void onLeave(String roomid, String accessToken) {
        FormBody.Builder builder = VHAPI.getBaseBuilder((String)accessToken).add("inav_id", roomid);
        Call call = VHAPI.getOkHttpClient().newCall(VHAPI.getRequest((String)"v2/inav/leave-inav", (RequestBody)builder.build()));
        call.enqueue((Callback)new VHAPI.DefaultCallback());
    }

    @Deprecated
    protected static void onStateChanged(String roomid, String accessToken, String streamid, int type, Callback callback) {
        FormBody.Builder builder = VHAPI.getBaseBuilder((String)accessToken).add("inav_id", roomid).add("stream_id", streamid).add("type", String.valueOf(type));
        Call call = VHAPI.getOkHttpClient().newCall(VHAPI.getRequest((String)"v2/inav/user-publish-callback", (RequestBody)builder.build()));
        if (callback == null) {
            call.enqueue((Callback)new VHAPI.DefaultCallback());
        } else {
            call.enqueue(callback);
        }
    }

    @Deprecated
    protected static void onBrocast(String roomid, String accessToken, String broid, int type, Callback callback) {
        FormBody.Builder builder = VHAPI.getBaseBuilder((String)accessToken).add("inav_id", roomid).add("room_id", broid).add("type", String.valueOf(type));
        Call call = VHAPI.getOkHttpClient().newCall(VHAPI.getRequest((String)"v2/inav/publish-another-config", (RequestBody)builder.build()));
        if (callback == null) {
            call.enqueue((Callback)new VHAPI.DefaultCallback());
        } else {
            call.enqueue(callback);
        }
    }

    public static void startBroadcastTRTC(VRTCParams.VRTCBroadcastParamInner broadcastParam, String accessToken, Callback callback) {
        FormBody.Builder builder = VHAPI.getBaseBuilder((String)accessToken).add("inav_id", broadcastParam.inavRoomId).add("room_id", broadcastParam.broadcastRoomId).add("profile", null != broadcastParam.compat_profile_json ? broadcastParam.compat_profile_json.toString() : "");
        if (broadcastParam.isAdaptiveLayoutMode) {
            builder.add("adaptive_layout_mode", String.valueOf(broadcastParam.compat_layout_mode));
            builder.add("layout", "");
        } else {
            builder.add("adaptive_layout_mode", "");
            builder.add("layout", String.valueOf(broadcastParam.compat_layout_mode));
        }
        if (!TextUtils.isEmpty((CharSequence)broadcastParam.broadcastParam.backgroundColor)) {
            builder.add("background_color", broadcastParam.broadcastParam.backgroundColor);
        } else {
            builder.add("background_color", "");
        }
        if (!TextUtils.isEmpty((CharSequence)broadcastParam.broadcastParam.backgroundImageUrl)) {
            builder.add("background_url", broadcastParam.broadcastParam.backgroundImageUrl);
        } else {
            builder.add("background_url", "");
        }
        Call call = VHAPI.getOkHttpClient().newCall(VHAPI.getRequest((String)"/v2/inav/start-mix-transcode", (RequestBody)builder.build()));
        if (callback == null) {
            call.enqueue((Callback)new VHAPI.DefaultCallback());
        } else {
            call.enqueue(callback);
        }
    }

    public static void stopBroadcastTRTC(String inavRoomId, String accessToken, Callback callback) {
        FormBody.Builder builder = VHAPI.getBaseBuilder((String)accessToken).add("inav_id", inavRoomId);
        Call call = VHAPI.getOkHttpClient().newCall(VHAPI.getRequest((String)"/v2/inav/stop-mix-transcode", (RequestBody)builder.build()));
        if (callback == null) {
            call.enqueue((Callback)new VHAPI.DefaultCallback());
        } else {
            call.enqueue(callback);
        }
    }

    public static void eventNotifyTRTC(String inavRoomId, String streamId, String event, String accessToken, Callback callback) {
        if (!TextUtils.isEmpty((CharSequence)streamId)) {
            FormBody.Builder builder = VHAPI.getBaseBuilder((String)accessToken).add("inav_id", inavRoomId).add("stream_id", streamId).add("type", event);
            Call call = VHAPI.getOkHttpClient().newCall(VHAPI.getRequest((String)"/v2/inav/event-notification", (RequestBody)builder.build()));
            if (callback == null) {
                call.enqueue((Callback)new VHAPI.DefaultCallback());
            } else {
                call.enqueue(callback);
            }
        }
    }

    public static void setMixMainScreenTRTC(String inavRoomId, String streamId, String accessToken, Callback callback) {
        FormBody.Builder builder = VHAPI.getBaseBuilder((String)accessToken).add("inav_id", inavRoomId).add("stream_id", streamId);
        Call call = VHAPI.getOkHttpClient().newCall(VHAPI.getRequest((String)"/v2/inav/set-max-video-user", (RequestBody)builder.build()));
        if (callback == null) {
            call.enqueue((Callback)new VHAPI.DefaultCallback());
        } else {
            call.enqueue(callback);
        }
    }

    @Deprecated
    protected static void reqPush(String roomid, String accessToken, Callback callback) {
        FormBody.Builder builder = VHAPI.getBaseBuilder((String)accessToken).add("inav_id", roomid);
        Call call = VHAPI.getOkHttpClient().newCall(VHAPI.getRequest((String)"v2/inav/apply-inav-publish", (RequestBody)builder.build()));
        if (callback == null) {
            call.enqueue((Callback)new VHAPI.DefaultCallback());
        } else {
            call.enqueue(callback);
        }
    }

    @Deprecated
    protected static void checkPushReq(String roomid, String accessToken, String userid, int type, Callback callback) {
        FormBody.Builder builder = VHAPI.getBaseBuilder((String)accessToken).add("inav_id", roomid).add("audit_user_id", userid).add("audit_type", String.valueOf(type));
        Call call = VHAPI.getOkHttpClient().newCall(VHAPI.getRequest((String)"v2/inav/audit-inav-publish", (RequestBody)builder.build()));
        if (callback == null) {
            call.enqueue((Callback)new VHAPI.DefaultCallback());
        } else {
            call.enqueue(callback);
        }
    }

    @Deprecated
    protected static void invitePush(String roomid, String accessToken, String userid, Callback callback) {
        FormBody.Builder builder = VHAPI.getBaseBuilder((String)accessToken).add("inav_id", roomid).add("askfor_third_user_id", userid);
        Call call = VHAPI.getOkHttpClient().newCall(VHAPI.getRequest((String)"v2/inav/askfor-inav-publish", (RequestBody)builder.build()));
        if (callback == null) {
            call.enqueue((Callback)new VHAPI.DefaultCallback());
        } else {
            call.enqueue(callback);
        }
    }

    @Deprecated
    protected static void kickoutPush(String roomid, String accessToken, String userid, int type, Callback callback) {
        FormBody.Builder builder = VHAPI.getBaseBuilder((String)accessToken).add("inav_id", roomid).add("kick_user_id", userid).add("type", String.valueOf(type));
        Call call = VHAPI.getOkHttpClient().newCall(VHAPI.getRequest((String)"v2/inav/kick-inav-stream", (RequestBody)builder.build()));
        if (callback == null) {
            call.enqueue((Callback)new VHAPI.DefaultCallback());
        } else {
            call.enqueue(callback);
        }
    }

    @Deprecated
    protected static void kickoutRoom(String roomid, String accessToken, String userid, int type, Callback callback) {
        FormBody.Builder builder = VHAPI.getBaseBuilder((String)accessToken).add("inav_id", roomid).add("kick_user_id", userid).add("type", String.valueOf(type));
        Call call = VHAPI.getOkHttpClient().newCall(VHAPI.getRequest((String)"v2/inav/kick-inav", (RequestBody)builder.build()));
        if (callback == null) {
            call.enqueue((Callback)new VHAPI.DefaultCallback());
        } else {
            call.enqueue(callback);
        }
    }

    public static void forceLeaveRoom(String roomId, String accessToken, String kickUserId, Callback callback) {
        FormBody.Builder builder = VHAPI.getBaseBuilder((String)accessToken).add("inav_id", roomId).add("kick_user_id", kickUserId);
        Call call = VHAPI.getOkHttpClient().newCall(VHAPI.getRequest((String)"v2/inav/leave-room-force-inav", (RequestBody)builder.build()));
        if (callback != null) {
            call.enqueue(callback);
        } else {
            call.equals(new VHAPI.DefaultCallback());
        }
    }

    public static void docCloudRender(String roomId, String accessToken, String channelId, boolean start, Callback callback) {
        FormBody.Builder builder = VHAPI.getBaseBuilder((String)accessToken).add("channel_id", channelId).add("inav_id", roomId);
        Call call = VHAPI.getOkHttpClient().newCall(VHAPI.getRequest((String)(start ? "v2/inav/start-doc-cloud-render" : "v2/inav/stop-doc-cloud-render"), (RequestBody)builder.build()));
        if (callback != null) {
            call.enqueue(callback);
        } else {
            call.equals(new VHAPI.DefaultCallback());
        }
    }

    public static Call stream_get_attributes(String roomId, String accessToken, String streamId, Callback callback) {
        FormBody.Builder builder = VHAPI.getBaseBuilder((String)accessToken).add("stream_id", streamId).add("inav_id", roomId);
        OkHttpClient client = VHAPI.getOkHttpClient().newBuilder().writeTimeout(5L, TimeUnit.SECONDS).readTimeout(5L, TimeUnit.SECONDS).connectTimeout(5L, TimeUnit.SECONDS).build();
        Call call = client.newCall(VHAPI.getRequest((String)"v2/inav/stream-get-attributes", (RequestBody)builder.build()));
        if (callback != null) {
            call.enqueue(callback);
        } else {
            call.equals(new VHAPI.DefaultCallback());
        }
        return call;
    }

    public static void stream_update_attributes(String roomId, String accessToken, String streamId, String attribute, Callback callback) {
        FormBody.Builder builder = VHAPI.getBaseBuilder((String)accessToken).add("stream_id", streamId).add("attributes", attribute).add("inav_id", roomId);
        Call call = VHAPI.getOkHttpClient().newCall(VHAPI.getRequest((String)"v2/inav/stream-update-attributes", (RequestBody)builder.build()));
        if (callback != null) {
            call.enqueue(callback);
        } else {
            call.equals(new VHAPI.DefaultCallback());
        }
    }
}

