/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.zxing.client.android.result;

import android.app.Activity;
import android.content.Context;
import android.net.wifi.WifiManager;
import android.os.AsyncTask;
import android.util.Log;
import android.widget.Toast;
import com.google.zxing.client.result.ParsedResult;
import com.google.zxing.client.result.WifiParsedResult;
import com.vhall.zxing.client.android.CaptureActivity;
import com.vhall.zxing.client.android.R;
import com.vhall.zxing.client.android.result.ResultHandler;
import com.vhall.zxing.client.android.wifi.WifiConfigManager;

public final class WifiResultHandler
extends ResultHandler {
    private static final String TAG = WifiResultHandler.class.getSimpleName();
    private final CaptureActivity parent;

    public WifiResultHandler(CaptureActivity activity, ParsedResult result) {
        super(activity, result);
        this.parent = activity;
    }

    @Override
    public int getButtonCount() {
        return 1;
    }

    @Override
    public int getButtonText(int index) {
        return R.string.button_wifi;
    }

    @Override
    public void handleButtonPress(int index) {
        if (index == 0) {
            WifiParsedResult wifiResult = (WifiParsedResult)this.getResult();
            WifiManager wifiManager = (WifiManager)this.getActivity().getApplicationContext().getSystemService("wifi");
            if (wifiManager == null) {
                Log.w((String)TAG, (String)"No WifiManager available from device");
                return;
            }
            final Activity activity = this.getActivity();
            activity.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    Toast.makeText((Context)activity.getApplicationContext(), (int)R.string.wifi_changing_network, (int)0).show();
                }
            });
            new WifiConfigManager(wifiManager).executeOnExecutor(AsyncTask.THREAD_POOL_EXECUTOR, new WifiParsedResult[]{wifiResult});
            this.parent.restartPreviewAfterDelay(0L);
        }
    }

    @Override
    public CharSequence getDisplayContents() {
        WifiParsedResult wifiResult = (WifiParsedResult)this.getResult();
        return wifiResult.getSsid() + " (" + wifiResult.getNetworkEncryption() + ')';
    }

    @Override
    public int getDisplayTitle() {
        return R.string.result_wifi;
    }
}

