/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.zxing.client.android.history;

import android.app.Activity;
import android.content.ContentValues;
import android.content.Context;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.database.CursorIndexOutOfBoundsException;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.net.Uri;
import android.os.Environment;
import android.preference.PreferenceManager;
import android.util.Log;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.Result;
import com.vhall.zxing.client.android.history.DBHelper;
import com.vhall.zxing.client.android.history.HistoryItem;
import com.vhall.zxing.client.android.result.ResultHandler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public final class HistoryManager {
    private static final String TAG = HistoryManager.class.getSimpleName();
    private static final int MAX_ITEMS = 2000;
    private static final String[] COLUMNS = new String[]{"text", "display", "format", "timestamp", "details"};
    private static final String[] COUNT_COLUMN = new String[]{"COUNT(1)"};
    private static final String[] ID_COL_PROJECTION = new String[]{"id"};
    private static final String[] ID_DETAIL_COL_PROJECTION = new String[]{"id", "details"};
    private static final Pattern DOUBLE_QUOTE = Pattern.compile("\"", 16);
    private final Activity activity;
    private final boolean enableHistory;

    public HistoryManager(Activity activity) {
        this.activity = activity;
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)activity);
        this.enableHistory = prefs.getBoolean("preferences_history", true);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public boolean hasHistoryItems() {
        DBHelper helper = new DBHelper((Context)this.activity);
        try (SQLiteDatabase db = helper.getReadableDatabase();){
            boolean bl;
            block14: {
                Cursor cursor = db.query("history", COUNT_COLUMN, null, null, null, null, null);
                try {
                    cursor.moveToFirst();
                    boolean bl2 = bl = cursor.getInt(0) > 0;
                    if (cursor == null) break block14;
                }
                catch (Throwable throwable) {
                    if (cursor != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                cursor.close();
            }
            return bl;
        }
        catch (SQLException sqle) {
            Log.w((String)TAG, (Throwable)sqle);
            return false;
        }
    }

    public List<HistoryItem> buildHistoryItems() {
        DBHelper helper = new DBHelper((Context)this.activity);
        ArrayList<HistoryItem> items = new ArrayList<HistoryItem>();
        try (SQLiteDatabase db = helper.getReadableDatabase();
             Cursor cursor = db.query("history", COLUMNS, null, null, null, null, "timestamp DESC");){
            while (cursor.moveToNext()) {
                String text = cursor.getString(0);
                String display = cursor.getString(1);
                String format = cursor.getString(2);
                long timestamp = cursor.getLong(3);
                String details = cursor.getString(4);
                Result result = new Result(text, null, null, BarcodeFormat.valueOf((String)format), timestamp);
                items.add(new HistoryItem(result, display, details));
            }
        }
        catch (CursorIndexOutOfBoundsException cioobe) {
            Log.w((String)TAG, (Throwable)cioobe);
        }
        return items;
    }

    public HistoryItem buildHistoryItem(int number) {
        DBHelper helper = new DBHelper((Context)this.activity);
        try (SQLiteDatabase db = helper.getReadableDatabase();){
            HistoryItem historyItem;
            block12: {
                Cursor cursor = db.query("history", COLUMNS, null, null, null, null, "timestamp DESC");
                try {
                    cursor.move(number + 1);
                    String text = cursor.getString(0);
                    String display = cursor.getString(1);
                    String format = cursor.getString(2);
                    long timestamp = cursor.getLong(3);
                    String details = cursor.getString(4);
                    Result result = new Result(text, null, null, BarcodeFormat.valueOf((String)format), timestamp);
                    historyItem = new HistoryItem(result, display, details);
                    if (cursor == null) break block12;
                }
                catch (Throwable throwable) {
                    if (cursor != null) {
                        try {
                            cursor.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                cursor.close();
            }
            return historyItem;
        }
    }

    public void deleteHistoryItem(int number) {
        DBHelper helper = new DBHelper((Context)this.activity);
        try (SQLiteDatabase db = helper.getWritableDatabase();
             Cursor cursor = db.query("history", ID_COL_PROJECTION, null, null, null, null, "timestamp DESC");){
            cursor.move(number + 1);
            db.delete("history", "id=" + cursor.getString(0), null);
        }
        catch (SQLException sqle) {
            Log.w((String)TAG, (Throwable)sqle);
        }
    }

    public void addHistoryItem(Result result, ResultHandler handler) {
        if (!this.activity.getIntent().getBooleanExtra("SAVE_HISTORY", true) || handler.areContentsSecure() || !this.enableHistory) {
            return;
        }
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)this.activity);
        if (!prefs.getBoolean("preferences_remember_duplicates", false)) {
            this.deletePrevious(result.getText());
        }
        ContentValues values = new ContentValues();
        values.put("text", result.getText());
        values.put("format", result.getBarcodeFormat().toString());
        values.put("display", handler.getDisplayContents().toString());
        values.put("timestamp", Long.valueOf(System.currentTimeMillis()));
        DBHelper helper = new DBHelper((Context)this.activity);
        try (SQLiteDatabase db = helper.getWritableDatabase();){
            db.insert("history", "timestamp", values);
        }
        catch (SQLException sqle) {
            Log.w((String)TAG, (Throwable)sqle);
        }
    }

    public void addHistoryItemDetails(String itemID, String itemDetails) {
        DBHelper helper = new DBHelper((Context)this.activity);
        try (SQLiteDatabase db = helper.getWritableDatabase();
             Cursor cursor = db.query("history", ID_DETAIL_COL_PROJECTION, "text=?", new String[]{itemID}, null, null, "timestamp DESC", "1");){
            Object newDetails;
            String oldID = null;
            String oldDetails = null;
            if (cursor.moveToNext()) {
                oldID = cursor.getString(0);
                oldDetails = cursor.getString(1);
            }
            if (oldID != null && (newDetails = oldDetails == null ? itemDetails : (oldDetails.contains(itemDetails) ? null : oldDetails + " : " + itemDetails)) != null) {
                ContentValues values = new ContentValues();
                values.put("details", (String)newDetails);
                db.update("history", values, "id=?", new String[]{oldID});
            }
        }
        catch (SQLException sqle) {
            Log.w((String)TAG, (Throwable)sqle);
        }
    }

    private void deletePrevious(String text) {
        DBHelper helper = new DBHelper((Context)this.activity);
        try (SQLiteDatabase db = helper.getWritableDatabase();){
            db.delete("history", "text=?", new String[]{text});
        }
        catch (SQLException sqle) {
            Log.w((String)TAG, (Throwable)sqle);
        }
    }

    public void trimHistory() {
        DBHelper helper = new DBHelper((Context)this.activity);
        try (SQLiteDatabase db = helper.getWritableDatabase();
             Cursor cursor = db.query("history", ID_COL_PROJECTION, null, null, null, null, "timestamp DESC");){
            cursor.move(2000);
            while (cursor.moveToNext()) {
                String id2 = cursor.getString(0);
                Log.i((String)TAG, (String)("Deleting scan history ID " + id2));
                db.delete("history", "id=" + id2, null);
            }
        }
        catch (SQLException sqle) {
            Log.w((String)TAG, (Throwable)sqle);
        }
    }

    CharSequence buildHistory() {
        StringBuilder historyText = new StringBuilder(1000);
        DBHelper helper = new DBHelper((Context)this.activity);
        try (SQLiteDatabase db = helper.getReadableDatabase();
             Cursor cursor = db.query("history", COLUMNS, null, null, null, null, "timestamp DESC");){
            DateFormat format = DateFormat.getDateTimeInstance(2, 2);
            while (cursor.moveToNext()) {
                historyText.append('\"').append(HistoryManager.massageHistoryField(cursor.getString(0))).append("\",");
                historyText.append('\"').append(HistoryManager.massageHistoryField(cursor.getString(1))).append("\",");
                historyText.append('\"').append(HistoryManager.massageHistoryField(cursor.getString(2))).append("\",");
                historyText.append('\"').append(HistoryManager.massageHistoryField(cursor.getString(3))).append("\",");
                long timestamp = cursor.getLong(3);
                historyText.append('\"').append(HistoryManager.massageHistoryField(format.format(timestamp))).append("\",");
                historyText.append('\"').append(HistoryManager.massageHistoryField(cursor.getString(4))).append("\"\r\n");
            }
        }
        catch (SQLException sqle) {
            Log.w((String)TAG, (Throwable)sqle);
        }
        return historyText;
    }

    void clearHistory() {
        DBHelper helper = new DBHelper((Context)this.activity);
        try (SQLiteDatabase db = helper.getWritableDatabase();){
            db.delete("history", null, null);
        }
        catch (SQLException sqle) {
            Log.w((String)TAG, (Throwable)sqle);
        }
    }

    static Uri saveHistory(String history) {
        Uri uri;
        File bsRoot = new File(Environment.getExternalStorageDirectory(), "BarcodeScanner");
        File historyRoot = new File(bsRoot, "History");
        if (!historyRoot.mkdirs() && !historyRoot.isDirectory()) {
            Log.w((String)TAG, (String)("Couldn't make dir " + historyRoot));
            return null;
        }
        File historyFile = new File(historyRoot, "history-" + System.currentTimeMillis() + ".csv");
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(historyFile), StandardCharsets.UTF_8);
        try {
            out.write(history);
            uri = Uri.parse((String)("file://" + historyFile.getAbsolutePath()));
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ioe) {
                Log.w((String)TAG, (String)("Couldn't access file " + historyFile + " due to " + ioe));
                return null;
            }
        }
        out.close();
        return uri;
    }

    private static String massageHistoryField(String value) {
        return value == null ? "" : DOUBLE_QUOTE.matcher(value).replaceAll("\"\"");
    }
}

