/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.zxing.client.android.encode;

import android.telephony.PhoneNumberUtils;
import com.vhall.zxing.client.android.encode.Formatter;
import java.util.HashSet;
import java.util.List;

abstract class ContactEncoder {
    ContactEncoder() {
    }

    abstract String[] encode(List<String> var1, String var2, List<String> var3, List<String> var4, List<String> var5, List<String> var6, List<String> var7, String var8);

    static String trim(String s) {
        if (s == null) {
            return null;
        }
        String result = s.trim();
        return result.isEmpty() ? null : result;
    }

    static void append(StringBuilder newContents, StringBuilder newDisplayContents, String prefix, String value, Formatter fieldFormatter, char terminator) {
        String trimmed = ContactEncoder.trim(value);
        if (trimmed != null) {
            newContents.append(prefix).append(fieldFormatter.format(trimmed, 0)).append(terminator);
            newDisplayContents.append(trimmed).append('\n');
        }
    }

    static void appendUpToUnique(StringBuilder newContents, StringBuilder newDisplayContents, String prefix, List<String> values, int max, Formatter displayFormatter, Formatter fieldFormatter, char terminator) {
        if (values == null) {
            return;
        }
        int count = 0;
        HashSet<String> uniques = new HashSet<String>(2);
        for (int i = 0; i < values.size(); ++i) {
            String value = values.get(i);
            String trimmed = ContactEncoder.trim(value);
            if (trimmed == null || trimmed.isEmpty() || uniques.contains(trimmed)) continue;
            newContents.append(prefix).append(fieldFormatter.format(trimmed, i)).append(terminator);
            String display = displayFormatter == null ? trimmed : displayFormatter.format(trimmed, i);
            newDisplayContents.append((CharSequence)display).append('\n');
            if (++count == max) break;
            uniques.add(trimmed);
        }
    }

    static String formatPhone(String phoneData) {
        return PhoneNumberUtils.formatNumber((String)phoneData);
    }
}

