/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.zxing.client.android.camera.open;

import android.hardware.Camera;
import android.util.Log;
import com.vhall.zxing.client.android.camera.open.CameraFacing;
import com.vhall.zxing.client.android.camera.open.OpenCamera;

public final class OpenCameraInterface {
    private static final String TAG = OpenCameraInterface.class.getName();
    public static final int NO_REQUESTED_CAMERA = -1;

    private OpenCameraInterface() {
    }

    public static OpenCamera open(int cameraId) {
        Camera.CameraInfo cameraInfo;
        int numCameras = Camera.getNumberOfCameras();
        if (numCameras == 0) {
            Log.w((String)TAG, (String)"No cameras!");
            return null;
        }
        if (cameraId >= numCameras) {
            Log.w((String)TAG, (String)("Requested camera does not exist: " + cameraId));
            return null;
        }
        if (cameraId <= -1) {
            for (cameraId = 0; cameraId < numCameras; ++cameraId) {
                cameraInfo = new Camera.CameraInfo();
                Camera.getCameraInfo((int)cameraId, (Camera.CameraInfo)cameraInfo);
                if (CameraFacing.values()[cameraInfo.facing] == CameraFacing.BACK) break;
            }
            if (cameraId == numCameras) {
                Log.i((String)TAG, (String)("No camera facing " + (Object)((Object)CameraFacing.BACK) + "; returning camera #0"));
                cameraId = 0;
            }
        }
        Log.i((String)TAG, (String)("Opening camera #" + cameraId));
        cameraInfo = new Camera.CameraInfo();
        Camera.getCameraInfo((int)cameraId, (Camera.CameraInfo)cameraInfo);
        Camera camera = Camera.open((int)cameraId);
        if (camera == null) {
            return null;
        }
        return new OpenCamera(cameraId, camera, CameraFacing.values()[cameraInfo.facing], cameraInfo.orientation);
    }
}

