/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.zxing.client.android.book;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.view.View;
import android.widget.AdapterView;
import com.vhall.zxing.client.android.LocaleManager;
import com.vhall.zxing.client.android.book.SearchBookContentsActivity;
import com.vhall.zxing.client.android.book.SearchBookContentsResult;
import java.util.List;

final class BrowseBookListener
implements AdapterView.OnItemClickListener {
    private final SearchBookContentsActivity activity;
    private final List<SearchBookContentsResult> items;

    BrowseBookListener(SearchBookContentsActivity activity, List<SearchBookContentsResult> items) {
        this.activity = activity;
        this.items = items;
    }

    public void onItemClick(AdapterView<?> parent, View v, int position, long id2) {
        if (position < 1) {
            return;
        }
        int itemOffset = position - 1;
        if (itemOffset >= this.items.size()) {
            return;
        }
        String pageId = this.items.get(itemOffset).getPageId();
        String query = SearchBookContentsResult.getQuery();
        if (LocaleManager.isBookSearchUrl(this.activity.getISBN()) && !pageId.isEmpty()) {
            String uri = this.activity.getISBN();
            int equals = uri.indexOf(61);
            String volumeId = uri.substring(equals + 1);
            String readBookURI = "http://books.google." + LocaleManager.getBookSearchCountryTLD((Context)this.activity) + "/books?id=" + volumeId + "&pg=" + pageId + "&vq=" + query;
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)readBookURI));
            intent.addFlags(524288);
            this.activity.startActivity(intent);
        }
    }
}

