/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.zxing.client.android;

import android.net.Uri;
import com.google.zxing.Result;
import com.vhall.zxing.client.android.result.ResultHandler;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;

final class ScanFromWebPageManager {
    private static final CharSequence CODE_PLACEHOLDER = "{CODE}";
    private static final CharSequence RAW_CODE_PLACEHOLDER = "{RAWCODE}";
    private static final CharSequence META_PLACEHOLDER = "{META}";
    private static final CharSequence FORMAT_PLACEHOLDER = "{FORMAT}";
    private static final CharSequence TYPE_PLACEHOLDER = "{TYPE}";
    private static final String RETURN_URL_PARAM = "ret";
    private static final String RAW_PARAM = "raw";
    private final String returnUrlTemplate;
    private final boolean returnRaw;

    ScanFromWebPageManager(Uri inputUri) {
        this.returnUrlTemplate = inputUri.getQueryParameter(RETURN_URL_PARAM);
        this.returnRaw = inputUri.getQueryParameter(RAW_PARAM) != null;
    }

    boolean isScanFromWebPage() {
        return this.returnUrlTemplate != null;
    }

    String buildReplyURL(Result rawResult, ResultHandler resultHandler) {
        String result = this.returnUrlTemplate;
        result = ScanFromWebPageManager.replace(CODE_PLACEHOLDER, this.returnRaw ? rawResult.getText() : resultHandler.getDisplayContents(), result);
        result = ScanFromWebPageManager.replace(RAW_CODE_PLACEHOLDER, rawResult.getText(), result);
        result = ScanFromWebPageManager.replace(FORMAT_PLACEHOLDER, rawResult.getBarcodeFormat().toString(), result);
        result = ScanFromWebPageManager.replace(TYPE_PLACEHOLDER, resultHandler.getType().toString(), result);
        result = ScanFromWebPageManager.replace(META_PLACEHOLDER, String.valueOf(rawResult.getResultMetadata()), result);
        return result;
    }

    private static String replace(CharSequence placeholder, CharSequence with, String pattern) {
        CharSequence escapedWith = with == null ? "" : with;
        try {
            escapedWith = URLEncoder.encode(escapedWith.toString(), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return pattern.replace(placeholder, escapedWith);
    }
}

