/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.rtc;

import android.content.Context;
import android.media.projection.MediaProjection;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import com.vhall.beautify.VHBeautifyKit;
import com.vhall.rtc.IVhallRTC;
import com.vhall.rtc.beautify.CaptureBufferCallbackImpl;
import com.vhall.vhallrtc.client.FinishCallback;
import com.vhall.vhallrtc.client.IFocusModeChangeListener;
import com.vhall.vhallrtc.client.Room;
import com.vhall.vhallrtc.client.Stream;
import com.vhall.vhallrtc.common.AppRTCAudioManager;
import java.lang.ref.WeakReference;
import org.json.JSONException;
import org.json.JSONObject;
import org.vhwebrtc.EglBase;

public class VhallRTC
implements IVhallRTC {
    private static final String TAG = "VhallRTC";
    protected Room mRoom;
    protected EglBase mRootEglBase;
    protected Stream mLocalStream;
    protected Context mContext;
    private AppRTCAudioManager audioManager;
    private Handler handler = new Handler(Looper.getMainLooper());
    private IOnCameraListener mCameraListener = null;

    public VhallRTC(Context context, boolean softEchoCanceller, boolean cpuoverusedetection) {
        this.init(context, softEchoCanceller, cpuoverusedetection);
    }

    public VhallRTC(Context context, boolean softEchoCanceller) {
        this.init(context, softEchoCanceller, true);
    }

    private void init(Context context, boolean softEchoCanceller, boolean cpuoverusedetection) {
        if (context == null) {
            throw new IllegalArgumentException("context should not be null");
        }
        this.mContext = context;
        this.mRootEglBase = EglBase.create();
        this.mRoom = new Room(this.mContext, null, softEchoCanceller, this.mRootEglBase, false, cpuoverusedetection);
        this.audioManager = AppRTCAudioManager.create((Context)context);
    }

    @Override
    public void setDataReport(JSONObject data) {
        if (null != this.mRoom) {
            this.mRoom.setReportLogData(data);
        }
    }

    @Override
    public Stream createLocalStream(JSONObject options, String attributes) {
        if (this.mLocalStream != null) {
            this.mLocalStream.stopStats();
            this.mLocalStream.dispose();
            this.mLocalStream = null;
            VHBeautifyKit.getInstance().release();
        }
        this.mLocalStream = new Stream(this.mContext, this.mRootEglBase, this.mRoom.getPeerConnectionFactory(), options, attributes);
        this.withCaptureBufferCallback(this.mLocalStream);
        return this.mLocalStream;
    }

    @Override
    public Stream createLocalStream(int type, String attributes, int layer) {
        JSONObject option = new JSONObject();
        try {
            option.put("videoFps", 15);
            option.put("streamType", Stream.VhallStreamType.VhallStreamTypeAudioAndVideo.getValue());
            option.put("frameResolutionType", type);
            option.put("numSpatialLayers", layer);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return this.createLocalStream(option, attributes);
    }

    @Override
    public Stream createScreenLocalStream(MediaProjection mediaProjection, JSONObject options, String attributes) {
        if (this.mLocalStream != null) {
            this.mLocalStream.stopStats();
            this.mLocalStream.dispose();
            this.mLocalStream = null;
        }
        this.mLocalStream = new Stream(1, mediaProjection, this.mContext, this.mRootEglBase, this.mRoom.getPeerConnectionFactory(), options, attributes);
        this.withCaptureBufferCallback(this.mLocalStream);
        return this.mLocalStream;
    }

    @Override
    public Stream createScreenLocalStream(MediaProjection mediaProjection, String attributes, int layer) {
        JSONObject option = new JSONObject();
        try {
            option.put("videoFps", 15);
            option.put("streamType", Stream.VhallStreamType.VhallStreamTypeScreen.getValue());
            option.put("videoWidth", 1280);
            option.put("videoHeight", 720);
            option.put("minBitrateKbps", 700);
            option.put("currentBitrateKbps", 800);
            option.put("maxBitrateKbps", 1024);
            option.put("numSpatialLayers", layer);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return this.createScreenLocalStream(mediaProjection, option, attributes);
    }

    private Stream withCaptureBufferCallback(Stream stream) {
        VHBeautifyKit.getInstance().loadFaceProcessor();
        if (null != this.mContext) {
            VHBeautifyKit.getInstance().judgeDeviceLevel(new WeakReference<Context>(this.mContext));
        }
        stream.setCaptureBufferCallback((Stream.CaptureBufferCallback)new CaptureBufferCallbackImpl(){

            @Override
            public void onCameraError(String s) {
                super.onCameraError(s);
                if (null != VhallRTC.this.mCameraListener) {
                    VhallRTC.this.mCameraListener.onCameraError(s);
                }
            }

            @Override
            public void onCameraFreezed(String s) {
                super.onCameraFreezed(s);
                if (null != VhallRTC.this.mCameraListener) {
                    VhallRTC.this.mCameraListener.onCameraError(s);
                }
            }

            @Override
            public void onFirstFrameAvailable() {
                super.onFirstFrameAvailable();
                if (null != VhallRTC.this.mCameraListener) {
                    VhallRTC.this.mCameraListener.onFirstFrame();
                }
            }
        });
        stream.setEnableCaptureCallback(true);
        return stream;
    }

    @Override
    public void enterRoom(String token, String userAttribute) {
        if (!TextUtils.isEmpty((CharSequence)token) && null != this.mRoom) {
            this.mRoom.connectWithEncodedToken(token, userAttribute);
        }
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                VhallRTC.this.audioManager.start(null);
            }
        });
    }

    public void setDefaultAudioDevice(AppRTCAudioManager.AudioDevice defaultDevice) {
        this.audioManager.setDefaultAudioDevice(defaultDevice);
    }

    @Override
    public void subscribeStream(Stream stream) {
        if (stream != null && null != this.mRoom) {
            this.mRoom.subscribe(stream);
        }
    }

    @Override
    public void unsubscribeStream(Stream stream) {
        if (stream != null && null != this.mRoom) {
            this.mRoom.unsubscribe(stream);
        }
    }

    @Override
    public void switchDualStream(Stream stream, int type, FinishCallback callback) {
        if (stream != null) {
            stream.switchDualStream(type, callback);
        }
    }

    @Override
    public void publish() {
        if (this.mLocalStream != null && null != this.mRoom) {
            this.mRoom.publish(this.mLocalStream);
        }
    }

    @Override
    public void unpublish() {
        if (this.mLocalStream != null) {
            this.mLocalStream.stopStats();
        }
        if (null != this.mRoom) {
            this.mRoom.unpublish();
        }
    }

    @Override
    public void leaveRoom() {
        try {
            this.unpublish();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (null != this.mRoom) {
            this.mRoom.leave();
        }
        this.handler.post(new Runnable(){

            @Override
            public void run() {
                VhallRTC.this.audioManager.stop();
            }
        });
    }

    public void configRoomBroadCast(JSONObject config, String mode, FinishCallback finish) {
        if (null != this.mRoom) {
            this.mRoom.configRoomBroadCast(config, mode, finish);
        }
    }

    public void setMixLayoutMode(int layoutMode, String mode, FinishCallback finish) {
        if (null != this.mRoom) {
            if (layoutMode >= 1000) {
                this.mRoom.setMixAdpaptiveLayoutMode(layoutMode - 1000, finish);
            } else {
                this.mRoom.setMixLayoutMode(layoutMode, mode, finish);
            }
        }
    }

    public void startDocCloudRender(String appId, String channelId, FinishCallback finish) {
        this.startDocCloudRender(appId, channelId, -1L, finish);
    }

    public void startDocCloudRender(String appId, String channelId, long delayStopTime, FinishCallback finish) {
        if (null != this.mRoom) {
            JSONObject config = new JSONObject();
            try {
                config.put("appId", (Object)appId);
                config.put("channelId", (Object)channelId);
                if (delayStopTime > -1L) {
                    config.put("delayStopTime", delayStopTime);
                }
                this.startDocCloudRender(config, finish);
            }
            catch (JSONException exception) {
                exception.printStackTrace();
            }
        }
    }

    public void startDocCloudRender(JSONObject config, FinishCallback finish) {
        if (null != this.mRoom) {
            this.mRoom.startDocCloudRender(config, finish);
        }
    }

    public void stopDocCloudRender(String appId, String channelId, FinishCallback finish) {
        this.stopDocCloudRender(appId, channelId, "rtc", finish);
    }

    public void stopDocCloudRender(String appId, String channelId, String mode, FinishCallback finish) {
        if (null != this.mRoom) {
            JSONObject config = new JSONObject();
            try {
                config.put("appId", (Object)appId);
                config.put("channelId", (Object)channelId);
                if (!TextUtils.isEmpty((CharSequence)mode)) {
                    config.put("mode", (Object)mode);
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            this.stopDocCloudRender(config, finish);
        }
    }

    public void stopDocCloudRender(JSONObject config, FinishCallback finish) {
        if (null != this.mRoom) {
            this.mRoom.stopDocCloudRender(config, finish);
        }
    }

    public void startRoomBroadCast(String mode, FinishCallback finish) {
        if (null != this.mRoom) {
            this.mRoom.startRoomBroadCast(mode, finish);
        }
    }

    public void stopRoomBroadCast(String mode, FinishCallback finish) {
        if (null != this.mRoom) {
            this.mRoom.stopRoomBroadCast(mode, finish);
        }
    }

    public void setReconnectTimes(int times) {
        if (this.mRoom != null && times >= 0) {
            this.mRoom.setReconnectTimes(times);
        }
    }

    @Override
    public void release() {
        this.leaveRoom();
        if (this.mLocalStream != null) {
            this.mLocalStream.dispose();
        }
        if (null != this.mRoom) {
            this.mRoom.dispose();
        }
        if (null != this.mRootEglBase) {
            this.mRootEglBase.release();
        }
        VHBeautifyKit.getInstance().release();
    }

    @Override
    public void setListener(Room.RoomDelegate listener) {
        if (null != this.mRoom) {
            this.mRoom.setRoomDeleagte(listener);
        }
    }

    public void setCameraListener(IOnCameraListener cameraListener) {
        this.mCameraListener = cameraListener;
    }

    @Override
    public void setRoomBroadCastBackgroundImage(String url, int cropType, FinishCallback callback) {
        if (this.isUrlLeagal(url)) {
            if (null != this.mRoom) {
                JSONObject param = new JSONObject();
                JSONObject config = new JSONObject();
                boolean jsonResult = true;
                String jsonErr = null;
                try {
                    config.put("backgroundImage", (Object)url);
                    config.put("cropType", cropType);
                    param.put("config", (Object)config);
                }
                catch (JSONException e) {
                    jsonResult = false;
                    jsonErr = e.getMessage();
                    e.printStackTrace();
                }
                if (jsonResult) {
                    this.mRoom.setRoomBroadCastBackgroundImage(param, null, callback);
                } else if (null != callback) {
                    callback.onFinish(20031, jsonErr);
                }
            } else {
                this.sendRoomNullError(callback);
            }
        } else {
            this.sendUrlIllegalError(callback);
        }
    }

    @Override
    public void resetRoomBroadCastBackgroundImage(FinishCallback callback) {
        if (null != this.mRoom) {
            JSONObject param = new JSONObject();
            try {
                param.put("mode", (Object)"mix");
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            this.mRoom.reSetRoomBroadCastBackgroundImage(param, null, callback);
        } else {
            this.sendRoomNullError(callback);
        }
    }

    @Override
    public void setRoomBroadCastPlaceholderImage(String url, FinishCallback callback) {
        if (this.isUrlLeagal(url)) {
            if (null != this.mRoom) {
                JSONObject param = new JSONObject();
                JSONObject config = new JSONObject();
                boolean jsonResult = true;
                String jsonErr = null;
                try {
                    config.put("placeholderImage", (Object)url);
                    param.put("config", (Object)config);
                }
                catch (JSONException e) {
                    jsonResult = false;
                    jsonErr = e.getMessage();
                    e.printStackTrace();
                }
                if (jsonResult) {
                    this.mRoom.setRoomBroadCastPlaceholderImage(param, null, callback);
                } else if (null != callback) {
                    callback.onFinish(20031, jsonErr);
                }
            } else {
                this.sendRoomNullError(callback);
            }
        } else {
            this.sendUrlIllegalError(callback);
        }
    }

    @Override
    public void resetRoomBroadCastPlaceholderImage(FinishCallback callback) {
        if (null != this.mRoom) {
            JSONObject param = new JSONObject();
            try {
                param.put("mode", (Object)"mix");
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            this.mRoom.reSetRoomBroadCastPlaceholderImage(param, null, callback);
        } else {
            this.sendRoomNullError(callback);
        }
    }

    @Override
    public void switchAutoFocusMode(boolean isAuto, IFocusModeChangeListener focusCallback) {
        if (null != this.mLocalStream) {
            this.mLocalStream.switchAutoFocusMode(isAuto, focusCallback);
        }
    }

    private boolean isUrlLeagal(String url) {
        return !TextUtils.isEmpty((CharSequence)url) && url.startsWith("https");
    }

    private void sendUrlIllegalError(FinishCallback callback) {
        if (null != callback) {
            callback.onFinish(20031, "bg url is invalid, only support https");
        }
    }

    private void sendRoomNullError(FinishCallback callback) {
        if (null != callback) {
            callback.onFinish(20031, "Room instance should not be null");
        }
    }

    public static interface IOnCameraListener {
        public void onCameraError(String var1);

        public void onFirstFrame();
    }
}

