/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.vhallrtc.logreport;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.graphics.YuvImage;
import android.renderscript.Allocation;
import android.renderscript.Element;
import android.renderscript.RenderScript;
import android.renderscript.ScriptIntrinsicYuvToRGB;
import android.renderscript.Type;
import android.util.Base64;
import android.util.Log;
import com.vhall.vhallrtc.client.Stream;
import com.vhall.vhallrtc.common.HttpRequest;
import com.vhall.vhallrtc.common.LogManager;
import com.vhall.vhallrtc.common.Tool;
import com.vhall.vhallrtc.logreport.LogReport;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.vhwebrtc.VideoFrame;

public class StreamLogReport {
    private static final String mTag = "StreamLogReport";
    private static final long period = 30000L;
    private static final long period_ = 3000L;
    private static final long period_15 = 15000L;
    private static final String kRTCStatsTypeSSRC = "ssrc";
    private static final String kRTCStatsBytesSent = "bytesSent";
    private static final String kRTCStatsBytesReceived = "bytesReceived";
    private static final String kRTCStatsBytesKey = "bytesKey";
    private static final String kRTCStatsBytes = "bytes";
    private static final String kRTCStatsAllLastDate = "ALLlastDate";
    private static final String kRTCStatsAllStreamLastDate = "ALLStreamlastDate";
    private static final String kRTCStatsAudioLastDate = "AudiolastDate";
    private static final String kRTCStatsVideoLastDate = "VideolastDate";
    private static final String kRTCStatsMediaTypeKey = "mediaType";
    private static final String KDizDes02 = "biz_des02";
    private static final String kGoogFrameHeightSent = "googFrameHeightSent";
    private static final String kGoogFrameWidthSent = "googFrameWidthSent";
    private static final String kGoogFrameHeightReceived = "googFrameHeightReceived";
    private static final String kGoogFrameWidthReceived = "googFrameWidthReceived";
    private static final int VhallStreamStatusTypeStart = 0;
    private static final int VhallStreamStatusTypesStop = 1;
    public static final String kStreamId = "p";
    public static final String kErrorCode = "errorcode";
    public static final String kBitRate = "bitrate";
    public static final String kTF = "tf";
    public static final String kTT = "tt";
    public static final String kUF = "uf";
    public static final String kOS = "os";
    public static final String kWidth = "v_width";
    public static final String kHeight = "v_height";
    private HashMap<String, HashMap<String, String>> mStatsBySSRC = new HashMap();
    private HashMap<String, HashMap<String, String>> mStatsByStreamSSRC = new HashMap();
    private HashMap<String, String> mAllSSRC = new HashMap();
    private HashMap<String, HashMap<String, String>> mVideoStatsBySSRC = new HashMap();
    private HashMap<String, HashMap<String, String>> mAudioStatsBySSRC = new HashMap();
    private HashMap<String, String> mAudioSSRC = new HashMap();
    private HashMap<String, String> mVideoSSRC = new HashMap();
    private Object lock = new Object();
    public Stream stream;
    private Timer mStatsTimer;
    private TimerTask timerTask;
    private Timer mInfoStatsTimer;
    private TimerTask InfotimerTask;
    private Timer mScreenShotsTimer;
    private TimerTask ScreenShotsimerTask;
    private long bytes;
    private long infobytes;
    private long audiobytes;
    private long videobytes;
    private NV21ToBitmap ba;
    private LogReport.LogReportDelegate mLogReportDelegate;

    public void streamStart(LogReport.LogReportDelegate delegate, String streamId) {
        if (this.mStatsTimer == null) {
            this.mStatsTimer = new Timer();
            this.timerTask = new TimerTask(){

                @Override
                public void run() {
                    StreamLogReport.this.gatherTrackStats(LogReport.VhallLogReportErrorCode.kNoneError, 0);
                }
            };
            this.mStatsTimer.schedule(this.timerTask, 30000L, 30000L);
            this.mInfoStatsTimer = new Timer();
            this.InfotimerTask = new TimerTask(){

                @Override
                public void run() {
                    StreamLogReport.this.gatherAVTrackStats(LogReport.VhallLogReportErrorCode.kNoneError, 0);
                }
            };
            this.mStatsTimer.schedule(this.InfotimerTask, 3000L, 3000L);
        }
        if (delegate != null) {
            this.mLogReportDelegate = delegate;
        }
        HashMap<String, String> allbytesMap = new HashMap<String, String>();
        allbytesMap.put(kRTCStatsBytes, "0");
        allbytesMap.put(kRTCStatsAllLastDate, "" + System.currentTimeMillis());
        this.mStatsBySSRC.put(kRTCStatsBytesKey, allbytesMap);
        HashMap<String, String> allStreambytesMap = new HashMap<String, String>();
        allStreambytesMap.put(kRTCStatsBytes, "0");
        allStreambytesMap.put(kRTCStatsAllStreamLastDate, "" + System.currentTimeMillis());
        this.mStatsByStreamSSRC.put(kRTCStatsBytesKey, allStreambytesMap);
        HashMap<String, String> videobytesMap = new HashMap<String, String>();
        videobytesMap.put(kRTCStatsBytes, "0");
        videobytesMap.put(kRTCStatsVideoLastDate, "" + System.currentTimeMillis());
        this.mVideoStatsBySSRC.put(kRTCStatsBytesKey, videobytesMap);
        HashMap<String, String> audiobytesMap = new HashMap<String, String>();
        audiobytesMap.put(kRTCStatsBytes, "0");
        audiobytesMap.put(kRTCStatsAudioLastDate, "" + System.currentTimeMillis());
        this.mAudioStatsBySSRC.put(kRTCStatsBytesKey, audiobytesMap);
        if (this.stream != null && this.stream.isLocal && this.mScreenShotsTimer == null) {
            this.mScreenShotsTimer = new Timer();
            this.ScreenShotsimerTask = new TimerTask(){

                @Override
                public void run() {
                    StreamLogReport.this.ScreenShots();
                }
            };
            this.mScreenShotsTimer.schedule(this.ScreenShotsimerTask, 15000L, 15000L);
        }
    }

    private static byte[] RotateYUV420Degree180(byte[] data, int imageWidth, int imageHeight) {
        byte[] yuv = new byte[imageWidth * imageHeight * 3 / 2];
        int i = 0;
        int count = 0;
        for (i = imageWidth * imageHeight - 1; i >= 0; --i) {
            yuv[count] = data[i];
            ++count;
        }
        i = imageWidth * imageHeight * 3 / 2 - 1;
        for (i = imageWidth * imageHeight * 3 / 2 - 1; i >= imageWidth * imageHeight; i -= 2) {
            yuv[count++] = data[i - 1];
            yuv[count++] = data[i];
        }
        return yuv;
    }

    private byte[] to270(byte[] data, int imageWidth, int imageHeight) {
        int j;
        int nPos;
        int i;
        byte[] yuv = new byte[imageWidth * imageHeight * 3 / 2];
        int nWidth = 0;
        int nHeight = 0;
        int wh = 0;
        int uvHeight = 0;
        if (imageWidth != nWidth || imageHeight != nHeight) {
            nWidth = imageWidth;
            nHeight = imageHeight;
            wh = imageWidth * imageHeight;
            uvHeight = imageHeight >> 1;
        }
        int k = 0;
        for (i = 0; i < imageWidth; ++i) {
            nPos = 0;
            for (j = 0; j < imageHeight; ++j) {
                yuv[k] = data[nPos + i];
                ++k;
                nPos += imageWidth;
            }
        }
        for (i = 0; i < imageWidth; i += 2) {
            nPos = wh;
            for (j = 0; j < uvHeight; ++j) {
                yuv[k] = data[nPos + i];
                yuv[k + 1] = data[nPos + i + 1];
                k += 2;
                nPos += imageWidth;
            }
        }
        return StreamLogReport.RotateYUV420Degree180(yuv, imageWidth, imageHeight);
    }

    void SemiPlanar2Planar(byte[] input, int width, int height) {
        int planar = width * height;
        for (int i = 0; i < planar / 4; ++i) {
            input[planar + planar / 4 + i] = input[planar + i * 2 + 1];
            input[planar + i] = input[planar + i * 2];
        }
    }

    void Planar2SemiPlanar(byte[] input, int width, int height) {
        int planar = width * height;
        for (int i = 0; i < planar / 4; ++i) {
            input[planar + i * 2] = input[planar + i];
            input[planar + i * 2 + 1] = input[planar + planar / 4 + i];
        }
    }

    private byte[] YUV420spRotate270(byte[] src, int width, int height) {
        int i;
        int j;
        int count = 0;
        int uvHeight = height >> 1;
        int imgSize = width * height;
        byte[] des = new byte[imgSize * 3 >> 1];
        for (j = width - 1; j >= 0; --j) {
            for (i = 0; i < height; ++i) {
                des[count++] = src[width * i + j];
            }
        }
        for (j = width - 1; j > 0; j -= 2) {
            for (i = 0; i < uvHeight; ++i) {
                des[count++] = src[imgSize + width * i + j - 1];
                des[count++] = src[imgSize + width * i + j];
            }
        }
        return des;
    }

    private byte[] rotateYUV420Degree180(byte[] data, int w, int h) {
        int imgSize = w * h;
        int len = imgSize * 3 / 2;
        byte[] yuv = new byte[len];
        int i = 0;
        int count = 0;
        for (i = imgSize - 1; i >= 0; --i) {
            yuv[count++] = data[i];
        }
        for (i = len - 1; i >= imgSize; i -= 2) {
            yuv[count++] = data[i - 1];
            yuv[count++] = data[i];
        }
        return yuv;
    }

    public byte[] rotateYUV420SP90(byte[] src, int width, int height) {
        int j;
        int i;
        int wh = width * height;
        byte[] yuv = new byte[wh * 3 >> 1];
        int count = 0;
        for (i = 0; i < width; ++i) {
            for (j = 0; j < height; ++j) {
                yuv[count++] = src[width * (j + 1) - 1 + i];
            }
        }
        for (i = 0; i < width; i += 2) {
            int len = height >> 1;
            int index = 0;
            for (j = 0; j < len; ++j) {
                index = wh + width * j + i;
                yuv[count] = src[index];
                yuv[count + 1] = src[index + 1];
                count += 2;
            }
        }
        return yuv;
    }

    private void ScreenShots() {
        if (this.stream == null || !this.stream.isLocal) {
            return;
        }
        VideoFrame frame = this.stream.mLocalVideoFrame;
        if (frame != null) {
            int temp;
            int width = frame.getRotatedWidth();
            int height = frame.getRotatedHeight();
            int scaledwidth = 160;
            int scaledheight = 120;
            switch (frame.getRotation()) {
                case 0: 
                case 180: {
                    width = frame.getRotatedWidth();
                    height = frame.getRotatedHeight();
                    break;
                }
                case 90: 
                case 270: {
                    height = frame.getRotatedWidth();
                    width = frame.getRotatedHeight();
                    break;
                }
            }
            if (width < height) {
                scaledwidth = 120;
                scaledheight = 160;
            }
            LogManager.d(mTag, "Rotation" + frame.getRotation() + "width\uff1a" + width + " height\uff1a" + height);
            VideoFrame.Buffer date_ = frame.getBuffer().cropAndScale(0, 0, width, height, scaledwidth, scaledheight);
            VideoFrame.I420Buffer buffer = date_.toI420();
            ByteBuffer dst_buffer = ByteBuffer.allocateDirect(buffer.getWidth() * buffer.getHeight() * 3 / 2);
            byte[] data = new byte[scaledwidth * scaledheight * 3 / 2];
            ByteBuffer yBuffer = buffer.getDataY();
            ByteBuffer vBuffer = buffer.getDataU();
            ByteBuffer uBuffer = buffer.getDataV();
            int yStride = buffer.getStrideY();
            int uStride = buffer.getStrideU();
            int vStride = buffer.getStrideV();
            yBuffer.get(data, 0, scaledwidth * scaledheight);
            vBuffer.get(data, scaledwidth * scaledheight, scaledwidth * scaledheight / 4);
            uBuffer.get(data, scaledwidth * scaledheight * 5 / 4, scaledwidth * scaledheight / 4);
            if (this.stream.getStreamType() != Stream.VhallStreamType.VhallStreamTypeScreen.getValue()) {
                this.Planar2SemiPlanar(data, scaledwidth, scaledheight);
            }
            if (frame.getRotation() == 270) {
                data = this.YUV420spRotate270(data, scaledwidth, scaledheight);
                temp = scaledwidth;
                scaledwidth = scaledheight;
                scaledheight = temp;
            } else if (frame.getRotation() == 180) {
                data = this.rotateYUV420Degree180(data, scaledwidth, scaledheight);
            } else if (frame.getRotation() == 90) {
                data = this.rotateYUV420SP90(data, scaledwidth, scaledheight);
                temp = scaledwidth;
                scaledwidth = scaledheight;
                scaledheight = temp;
            }
            if (data != null) {
                if (this.stream.getStreamType() != Stream.VhallStreamType.VhallStreamTypeScreen.getValue()) {
                    byte[] data_out = new byte[scaledwidth * scaledheight * 3 / 2];
                    this.NV21toI420SemiPlanar(data, data_out, scaledwidth, scaledheight);
                    data = data_out;
                }
                data = StreamLogReport.I420Tonv21(data, scaledwidth, scaledheight);
            }
            date_.release();
            buffer.release();
            YuvImage yuvImage = new YuvImage(data, 17, scaledwidth, scaledheight, null);
            ByteArrayOutputStream os = new ByteArrayOutputStream(data.length);
            yuvImage.compressToJpeg(new Rect(0, 0, scaledwidth, scaledheight), 80, (OutputStream)os);
            byte[] jpg = os.toByteArray();
            String token = null;
            try {
                token = new String(Base64.encode((byte[])jpg, (int)2), "UTF-8");
                if (token.length() > 0) {
                    LogReport logReport = LogReport.instance();
                    logReport.reportLogWithKeyAndStreamId(LogReport.VhallLogReportKey.kScreenShots, this.stream.streamId, token);
                }
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
    }

    public void streamStop() {
        if (this.mStatsTimer != null) {
            this.mStatsTimer.cancel();
            this.mStatsTimer = null;
        }
        if (this.timerTask != null) {
            this.timerTask.cancel();
            this.timerTask = null;
        }
        LogReport.VhallLogReportErrorCode errorCode = this.stream.isLocal ? LogReport.VhallLogReportErrorCode.kPublishSuccess : LogReport.VhallLogReportErrorCode.kSubscribeSuccess;
        this.gatherTrackStats(errorCode, 1);
        if (this.mScreenShotsTimer != null) {
            this.mScreenShotsTimer.cancel();
            this.mScreenShotsTimer = null;
        }
        if (this.ScreenShotsimerTask != null) {
            this.ScreenShotsimerTask.cancel();
            this.ScreenShotsimerTask = null;
        }
    }

    public void streamError() {
        LogReport.VhallLogReportErrorCode errorCode = this.stream.isLocal ? LogReport.VhallLogReportErrorCode.kPublishError : LogReport.VhallLogReportErrorCode.kSubscribeError;
        this.gatherTrackStats(errorCode, 1);
    }

    public void getRTCAudioInfo(final String streamId) {
        if (this.stream == null || this.mLogReportDelegate == null) {
            return;
        }
        this.stream.getRTCAudioInfo(new Stream.StatsReportCallback(){

            @Override
            public void onResponse(int trackCount, int trackIndex, Map<String, String> statMap) {
                if (statMap.size() > 0) {
                    if (StreamLogReport.this.stream.isLocal) {
                        if (StreamLogReport.this.mLogReportDelegate != null && statMap.containsKey("audioInputLevel")) {
                            StreamLogReport.this.mLogReportDelegate.onAudioLevel(streamId, Integer.parseInt(statMap.get("audioInputLevel")));
                        }
                    } else if (StreamLogReport.this.mLogReportDelegate != null && statMap.containsKey("audioOutputLevel")) {
                        StreamLogReport.this.mLogReportDelegate.onAudioLevel(streamId, Integer.parseInt(statMap.get("audioOutputLevel")));
                    }
                }
            }
        });
    }

    public static byte[] I420Tonv21(byte[] data, int width, int height) {
        byte[] ret = new byte[data.length];
        int total = width * height;
        ByteBuffer bufferY = ByteBuffer.wrap(ret, 0, total);
        ByteBuffer bufferVU = ByteBuffer.wrap(ret, total, total / 2);
        bufferY.put(data, 0, total);
        for (int i = 0; i < total / 4; ++i) {
            bufferVU.put(data[i + total + total / 4]);
            bufferVU.put(data[total + i]);
        }
        return ret;
    }

    public static byte[] Nv12ToNv21(byte[] data, int w, int h) {
        int total = w * h;
        ByteBuffer cvt = ByteBuffer.wrap(data, 0, total);
        for (int m = 0; m < h / 2; ++m) {
            for (int n = 0; n < w / 2; ++n) {
                byte tmp = cvt.array()[0];
                cvt.array()[0] = cvt.array()[1];
                cvt.array()[1] = tmp;
                cvt = ByteBuffer.wrap(data, 0, total += 2);
            }
        }
        return cvt.array();
    }

    private void NV21toI420SemiPlanar(byte[] nv21bytes, byte[] i420bytes, int width, int height) {
        int totle = width * height;
        int nLen = totle / 4;
        System.arraycopy(nv21bytes, 0, i420bytes, 0, totle);
        for (int i = 0; i < nLen; ++i) {
            i420bytes[totle + i] = nv21bytes[totle + 2 * i];
            i420bytes[totle + nLen + i] = nv21bytes[totle + 2 * i + 1];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void gatherAVTrackStats(LogReport.VhallLogReportErrorCode errorCode, int type) {
        if (!this.stream.isLocal || this.stream.getRenderViews() == null || this.stream.getRenderViews().size() > 0) {
            // empty if block
        }
        this.mAudioSSRC.clear();
        this.mVideoSSRC.clear();
        this.infobytes = 0L;
        this.stream.getRTCLegacyStatsReport(new Stream.StatsReportCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onResponse(int trackCount, int trackIndex, Map<String, String> statMap) {
                HashMap hashMap = StreamLogReport.this.mVideoSSRC;
                synchronized (hashMap) {
                    String statsBytes = StreamLogReport.this.stream.isLocal ? StreamLogReport.kRTCStatsBytesSent : StreamLogReport.kRTCStatsBytesReceived;
                    StreamLogReport.this.infobytes += Integer.valueOf(statMap.get(statsBytes)).longValue();
                    if (statMap.containsKey(StreamLogReport.kRTCStatsMediaTypeKey)) {
                        if (statMap.get(StreamLogReport.kRTCStatsMediaTypeKey).equals("video")) {
                            StreamLogReport.this.mVideoSSRC.putAll(statMap);
                            StreamLogReport.this.videobytes = Integer.valueOf(statMap.get(statsBytes)).longValue();
                            Log.d((String)StreamLogReport.mTag, (String)(" videobytes" + StreamLogReport.this.videobytes + "  kRTCStatsBytesSent: " + Integer.valueOf(statMap.get(statsBytes)).longValue()));
                        } else {
                            StreamLogReport.this.mAudioSSRC.putAll(statMap);
                            StreamLogReport.this.audiobytes = Integer.valueOf(statMap.get(statsBytes)).longValue();
                        }
                    }
                    if (trackCount - 1 <= trackIndex) {
                        ArrayList result = StreamLogReport.this.calculateBitrateForStatsReport(StreamLogReport.this.infobytes, StreamLogReport.this.mStatsByStreamSSRC, StreamLogReport.kRTCStatsAllStreamLastDate);
                        HashMap<String, String> bytesMap = new HashMap<String, String>();
                        bytesMap.put(StreamLogReport.kRTCStatsBytes, StreamLogReport.this.bytes + "");
                        bytesMap.put(StreamLogReport.kRTCStatsAllStreamLastDate, "" + System.currentTimeMillis());
                        StreamLogReport.this.mStatsByStreamSSRC.put(StreamLogReport.kRTCStatsBytesKey, bytesMap);
                        ArrayList videoresult = StreamLogReport.this.calculateBitrateForStatsReport(StreamLogReport.this.videobytes, StreamLogReport.this.mVideoStatsBySSRC, StreamLogReport.kRTCStatsVideoLastDate);
                        HashMap<String, String> vbytesMap = new HashMap<String, String>();
                        vbytesMap.put(StreamLogReport.kRTCStatsBytes, StreamLogReport.this.videobytes + "");
                        vbytesMap.put(StreamLogReport.kRTCStatsVideoLastDate, "" + System.currentTimeMillis());
                        StreamLogReport.this.mVideoStatsBySSRC.put(StreamLogReport.kRTCStatsBytesKey, vbytesMap);
                        ArrayList audioresult = StreamLogReport.this.calculateBitrateForStatsReport(StreamLogReport.this.audiobytes, StreamLogReport.this.mAudioStatsBySSRC, StreamLogReport.kRTCStatsAudioLastDate);
                        HashMap<String, String> abytesMap = new HashMap<String, String>();
                        abytesMap.put(StreamLogReport.kRTCStatsBytes, StreamLogReport.this.audiobytes + "");
                        abytesMap.put(StreamLogReport.kRTCStatsAudioLastDate, "" + System.currentTimeMillis());
                        StreamLogReport.this.mAudioStatsBySSRC.put(StreamLogReport.kRTCStatsBytesKey, abytesMap);
                        String token = null;
                        LogReport logReport = LogReport.instance();
                        LogReport.VhallLogReportKey minitorKey = LogReport.VhallLogReportKey.kMinitorPublishInfo;
                        try {
                            JSONObject tokenDic = new JSONObject(logReport.logDataInfo.toString());
                            tokenDic.put(StreamLogReport.kStreamId, (Object)StreamLogReport.this.stream.streamId);
                            tokenDic.put("s", (Object)logReport.sessionId);
                            tokenDic.put("ld", System.currentTimeMillis());
                            tokenDic.put("uid", (Object)logReport.userid);
                            tokenDic.put("aid", (Object)logReport.aid);
                            tokenDic.put("pf", logReport.pf);
                            tokenDic.put("ver", (Object)Tool.getSDKVersion());
                            tokenDic.put("vtype", StreamLogReport.this.stream.getStreamType());
                            if (StreamLogReport.this.stream.isLocal) {
                                tokenDic.put("type", (Object)"sent");
                            } else {
                                tokenDic.put("type", (Object)"recv");
                            }
                            tokenDic.put("avbw", (Object)"");
                            if (!StreamLogReport.this.mVideoSSRC.isEmpty()) {
                                if (StreamLogReport.this.mVideoSSRC.containsKey(StreamLogReport.kRTCStatsTypeSSRC)) {
                                    tokenDic.put("v_ssrc", StreamLogReport.this.mVideoSSRC.get(StreamLogReport.kRTCStatsTypeSSRC));
                                }
                                tokenDic.put("v_kbytes", StreamLogReport.this.videobytes);
                                tokenDic.put("v_kbitrate", videoresult.get(1));
                                Log.d((String)StreamLogReport.mTag, (String)("v_kbitrate: " + videoresult.get(1) + "   videobytes:" + StreamLogReport.this.videobytes));
                                if (StreamLogReport.this.stream.isLocal) {
                                    if (StreamLogReport.this.mVideoSSRC.containsKey(StreamLogReport.kGoogFrameHeightSent)) {
                                        tokenDic.put(StreamLogReport.kHeight, StreamLogReport.this.mVideoSSRC.get(StreamLogReport.kGoogFrameHeightSent));
                                    }
                                    if (StreamLogReport.this.mVideoSSRC.containsKey(StreamLogReport.kGoogFrameWidthSent)) {
                                        tokenDic.put(StreamLogReport.kWidth, StreamLogReport.this.mVideoSSRC.get(StreamLogReport.kGoogFrameWidthSent));
                                    }
                                    if (StreamLogReport.this.mVideoSSRC.containsKey("hugeFramesSent")) {
                                        tokenDic.put("v_fmcount", StreamLogReport.this.mVideoSSRC.get("hugeFramesSent"));
                                    }
                                    if (StreamLogReport.this.mVideoSSRC.containsKey("googFrameRateSent")) {
                                        tokenDic.put("v_fmrate", StreamLogReport.this.mVideoSSRC.get("googFrameRateSent"));
                                    }
                                    if (StreamLogReport.this.mVideoSSRC.containsKey("packetsSent")) {
                                        tokenDic.put("v_pkt", StreamLogReport.this.mVideoSSRC.get("packetsSent"));
                                    }
                                    if (StreamLogReport.this.mVideoSSRC.containsKey("packetsLost")) {
                                        tokenDic.put("v_pkt_lost", StreamLogReport.this.mVideoSSRC.get("packetsLost"));
                                    }
                                    if (StreamLogReport.this.mVideoSSRC.containsKey("framesEncoded")) {
                                        tokenDic.put("v_fmenc", StreamLogReport.this.mVideoSSRC.get("framesEncoded"));
                                    }
                                    tokenDic.put("v_tet", (Object)"");
                                    tokenDic.put("v_avget", (Object)"");
                                    if (StreamLogReport.this.mVideoSSRC.containsKey("qpSum")) {
                                        tokenDic.put("v_qpsum", StreamLogReport.this.mVideoSSRC.get("qpSum"));
                                    }
                                    tokenDic.put("v_srcw", StreamLogReport.this.stream.mVideoWidth);
                                    tokenDic.put("v_srch", StreamLogReport.this.stream.mVideoHeight);
                                    tokenDic.put("v_srcfmt", StreamLogReport.this.stream.mFps);
                                    tokenDic.put("v_tpsd", (Object)"");
                                } else {
                                    if (StreamLogReport.this.mVideoSSRC.containsKey(StreamLogReport.kGoogFrameHeightReceived)) {
                                        tokenDic.put(StreamLogReport.kHeight, StreamLogReport.this.mVideoSSRC.get(StreamLogReport.kGoogFrameHeightReceived));
                                    }
                                    if (StreamLogReport.this.mVideoSSRC.containsKey(StreamLogReport.kGoogFrameWidthReceived)) {
                                        tokenDic.put(StreamLogReport.kWidth, StreamLogReport.this.mVideoSSRC.get(StreamLogReport.kGoogFrameWidthReceived));
                                    }
                                    if (StreamLogReport.this.mVideoSSRC.containsKey("hugeFramesRecv")) {
                                        tokenDic.put("v_fmcount", StreamLogReport.this.mVideoSSRC.get("hugeFramesRecv"));
                                    }
                                    if (StreamLogReport.this.mVideoSSRC.containsKey("googFrameRateRecv")) {
                                        tokenDic.put("v_fmrate", StreamLogReport.this.mVideoSSRC.get("googFrameRateRecv"));
                                    }
                                    if (StreamLogReport.this.mVideoSSRC.containsKey("packetsRecv")) {
                                        tokenDic.put("v_pkt", StreamLogReport.this.mVideoSSRC.get("packetsRecv"));
                                    }
                                    if (StreamLogReport.this.mVideoSSRC.containsKey("packetsLost")) {
                                        tokenDic.put("v_pkt_lost", StreamLogReport.this.mVideoSSRC.get("packetsLost"));
                                    }
                                    if (StreamLogReport.this.mVideoSSRC.containsKey("googFreezeCount")) {
                                        tokenDic.put("v_drop", StreamLogReport.this.mVideoSSRC.get("googFreezeCount"));
                                    }
                                    if (StreamLogReport.this.mVideoSSRC.containsKey("googFramesDropped")) {
                                        tokenDic.put("v_freeze", StreamLogReport.this.mVideoSSRC.get("googFramesDropped"));
                                    }
                                    if (StreamLogReport.this.mVideoSSRC.containsKey("googJitterReceived")) {
                                        tokenDic.put("v_jit", StreamLogReport.this.mVideoSSRC.get("googJitterReceived"));
                                    }
                                }
                                if (StreamLogReport.this.mVideoSSRC.containsKey("googNacksReceived")) {
                                    tokenDic.put("v_nack", StreamLogReport.this.mVideoSSRC.get("googNacksReceived"));
                                }
                                if (StreamLogReport.this.mVideoSSRC.containsKey("googPlisReceived")) {
                                    tokenDic.put("v_pli", StreamLogReport.this.mVideoSSRC.get("googPlisReceived"));
                                }
                                if (StreamLogReport.this.mVideoSSRC.containsKey("googFrisReceived")) {
                                    tokenDic.put("v_fir", StreamLogReport.this.mVideoSSRC.get("googFrisReceived"));
                                }
                                if (StreamLogReport.this.mVideoSSRC.containsKey("googRtt")) {
                                    tokenDic.put("v_rtt", StreamLogReport.this.mVideoSSRC.get("googRtt"));
                                    tokenDic.put("rtt", StreamLogReport.this.mVideoSSRC.get("googRtt"));
                                }
                                if (StreamLogReport.this.mVideoSSRC.containsKey("codecImplementationName")) {
                                    tokenDic.put("v_codecName", StreamLogReport.this.mVideoSSRC.get("codecImplementationName"));
                                }
                            }
                            if (!StreamLogReport.this.mAudioSSRC.isEmpty()) {
                                tokenDic.put("a_exist", (Object)"1");
                                if (StreamLogReport.this.mAudioSSRC.containsKey(StreamLogReport.kRTCStatsTypeSSRC)) {
                                    tokenDic.put("a_ssrc", StreamLogReport.this.mAudioSSRC.get(StreamLogReport.kRTCStatsTypeSSRC));
                                }
                                if (StreamLogReport.this.mAudioSSRC.containsKey("audioInputLevel")) {
                                    tokenDic.put("a_level", StreamLogReport.this.mAudioSSRC.get("audioInputLevel"));
                                }
                                if (StreamLogReport.this.mAudioSSRC.containsKey("audioInputLevel")) {
                                    tokenDic.put("a_level", StreamLogReport.this.mAudioSSRC.get("audioInputLevel"));
                                }
                                tokenDic.put("a_kbytes", StreamLogReport.this.audiobytes);
                                tokenDic.put("a_kbitrate", audioresult.get(1));
                                if (StreamLogReport.this.stream.isLocal) {
                                    if (StreamLogReport.this.mAudioSSRC.containsKey("packetsSent")) {
                                        tokenDic.put("a_pkt", StreamLogReport.this.mAudioSSRC.get("packetsSent"));
                                    }
                                    if (StreamLogReport.this.mAudioSSRC.containsKey("packetsLost")) {
                                        tokenDic.put("a_pkt_lost", StreamLogReport.this.mAudioSSRC.get("packetsLost"));
                                    }
                                } else {
                                    if (StreamLogReport.this.mAudioSSRC.containsKey("packetsRecv")) {
                                        tokenDic.put("a_pkt", StreamLogReport.this.mAudioSSRC.get("packetsRecv"));
                                    }
                                    if (StreamLogReport.this.mAudioSSRC.containsKey("packetsLost")) {
                                        tokenDic.put("a_pkt_lost", StreamLogReport.this.mAudioSSRC.get("packetsLost"));
                                    }
                                }
                                if (StreamLogReport.this.mAudioSSRC.containsKey("googRtt")) {
                                    tokenDic.put("a_rtt", StreamLogReport.this.mAudioSSRC.get("googRtt"));
                                }
                                if (StreamLogReport.this.mAudioSSRC.containsKey("googJitterReceived")) {
                                    tokenDic.put("a_jit", StreamLogReport.this.mAudioSSRC.get("googJitterRecvived"));
                                }
                            }
                            tokenDic.put("t_kbytes", (Object)(StreamLogReport.this.infobytes + ""));
                            tokenDic.put("t_kbitrate", result.get(1));
                            JSONArray tokenArray = new JSONArray();
                            tokenArray.put((Object)tokenDic);
                            token = tokenArray.toString();
                            Log.d((String)StreamLogReport.mTag, (String)("onResponse: " + token));
                            String url = null;
                            try {
                                url = logReport.reportMonitorUrl + "?k=" + minitorKey.getValue() + "&id=" + logReport.getLogId() + "&bu=" + logReport.bu + "&token=" + new String(Base64.encode((byte[])token.getBytes(), (int)2), "UTF-8");
                            }
                            catch (UnsupportedEncodingException e) {
                                e.printStackTrace();
                            }
                            LogManager.d(StreamLogReport.mTag, url);
                            HttpRequest.httpGetAsyncRequest(url);
                            Object object = StreamLogReport.this.lock;
                            synchronized (object) {
                                StreamLogReport.this.lock.notify();
                            }
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        });
        Object object = this.lock;
        synchronized (object) {
            try {
                this.lock.wait(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void gatherTrackStats(final LogReport.VhallLogReportErrorCode errorCode, final int type) {
        this.bytes = 0L;
        this.mAllSSRC.clear();
        this.stream.getRTCLegacyStatsReport(new Stream.StatsReportCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onResponse(int trackCount, int trackIndex, Map<String, String> statMap) {
                String statsBytes = StreamLogReport.this.stream.isLocal ? StreamLogReport.kRTCStatsBytesSent : StreamLogReport.kRTCStatsBytesReceived;
                StreamLogReport.this.mAllSSRC.putAll(statMap);
                StreamLogReport.this.bytes += Integer.valueOf(statMap.get(statsBytes)).longValue();
                if (trackCount - 1 <= trackIndex) {
                    ArrayList result = StreamLogReport.this.calculateBitrateForStatsReport(StreamLogReport.this.bytes, StreamLogReport.this.mStatsBySSRC, StreamLogReport.kRTCStatsAllLastDate);
                    HashMap<String, String> bytesMap = new HashMap<String, String>();
                    bytesMap.put(StreamLogReport.kRTCStatsBytes, StreamLogReport.this.bytes + "");
                    bytesMap.put(StreamLogReport.kRTCStatsAllLastDate, "" + System.currentTimeMillis());
                    StreamLogReport.this.mStatsBySSRC.put(StreamLogReport.kRTCStatsBytesKey, bytesMap);
                    LogReport logReport = LogReport.instance();
                    LogReport.VhallLogReportKey key = LogReport.VhallLogReportKey.kSignalingConnectSuccess;
                    LogReport.VhallLogReportKey minitorKey = LogReport.VhallLogReportKey.kSignalingConnectSuccess;
                    String token = null;
                    try {
                        JSONObject tokenDic = new JSONObject(logReport.logDataInfo.toString());
                        tokenDic.put(StreamLogReport.kStreamId, (Object)StreamLogReport.this.stream.streamId);
                        if (StreamLogReport.this.stream.isLocal) {
                            tokenDic.put(StreamLogReport.kUF, result.get(0));
                            if (StreamLogReport.this.mAllSSRC.containsKey(StreamLogReport.kGoogFrameHeightSent)) {
                                tokenDic.put(StreamLogReport.kHeight, StreamLogReport.this.mAllSSRC.get(StreamLogReport.kGoogFrameHeightSent));
                            }
                            if (StreamLogReport.this.mAllSSRC.containsKey(StreamLogReport.kGoogFrameWidthSent)) {
                                tokenDic.put(StreamLogReport.kWidth, StreamLogReport.this.mAllSSRC.get(StreamLogReport.kGoogFrameWidthSent));
                            }
                            key = LogReport.VhallLogReportKey.kPublishInfo;
                        } else {
                            tokenDic.put(StreamLogReport.kTF, result.get(0));
                            if (StreamLogReport.this.mAllSSRC.containsKey(StreamLogReport.kGoogFrameHeightReceived)) {
                                tokenDic.put(StreamLogReport.kHeight, StreamLogReport.this.mAllSSRC.get(StreamLogReport.kGoogFrameHeightReceived));
                            }
                            if (StreamLogReport.this.mAllSSRC.containsKey(StreamLogReport.kGoogFrameWidthReceived)) {
                                tokenDic.put(StreamLogReport.kWidth, StreamLogReport.this.mAllSSRC.get(StreamLogReport.kGoogFrameWidthReceived));
                            }
                            key = LogReport.VhallLogReportKey.kSubscribeInfo;
                        }
                        if (type == 0) {
                            tokenDic.put(StreamLogReport.KDizDes02, 1);
                        } else {
                            tokenDic.put(StreamLogReport.KDizDes02, 2);
                        }
                        tokenDic.put(StreamLogReport.kOS, StreamLogReport.this.stream.isOverseas);
                        tokenDic.put(StreamLogReport.kBitRate, result.get(1));
                        tokenDic.put(StreamLogReport.kTT, result.get(2));
                        if (errorCode.getValue() > 0) {
                            tokenDic.put(StreamLogReport.kErrorCode, errorCode.getValue());
                        }
                        token = tokenDic.toString();
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                    String url = null;
                    try {
                        url = logReport.reportUrl + "?k=" + key.getValue() + "&s=" + logReport.sessionId + "&id=" + logReport.getLogId() + "&bu=" + logReport.bu + "&token=" + new String(Base64.encode((byte[])token.getBytes(), (int)2), "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                    LogManager.d(StreamLogReport.mTag, url);
                    HttpRequest.httpGetAsyncRequest(url);
                    Object object = StreamLogReport.this.lock;
                    synchronized (object) {
                        StreamLogReport.this.lock.notify();
                    }
                }
            }
        });
        Object object = this.lock;
        synchronized (object) {
            try {
                this.lock.wait(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private ArrayList<Long> calculateBitrateForStatsReport(long bytes, HashMap<String, HashMap<String, String>> mapssrc, String lastdate) {
        if (mapssrc.containsKey(kRTCStatsBytesKey)) {
            Map ssrcMap = mapssrc.get(kRTCStatsBytesKey);
            long lastBytes = Long.valueOf((String)ssrcMap.get(kRTCStatsBytes));
            long lastStatsTS = Long.valueOf((String)ssrcMap.get(lastdate));
            long accumulative = bytes > lastBytes ? bytes - lastBytes : 0L;
            double seconds = (double)(System.currentTimeMillis() - lastStatsTS) / 1000.0;
            long kbps = (long)((double)(accumulative * 8L) / Math.abs(seconds)) / 1000L;
            ArrayList<Long> reslut = new ArrayList<Long>();
            reslut.add(accumulative);
            reslut.add(kbps);
            reslut.add((long)(seconds * 1000.0));
            return reslut;
        }
        return null;
    }

    public static class NV21ToBitmap {
        private RenderScript rs;
        private ScriptIntrinsicYuvToRGB yuvToRgbIntrinsic;
        private Type.Builder yuvType;
        private Type.Builder rgbaType;
        private Allocation in;
        private Allocation out;

        public NV21ToBitmap(Context context) {
            this.rs = RenderScript.create((Context)context);
            this.yuvToRgbIntrinsic = ScriptIntrinsicYuvToRGB.create((RenderScript)this.rs, (Element)Element.U8_4((RenderScript)this.rs));
        }

        public Bitmap nv21ToBitmap(byte[] nv21, int width, int height) {
            if (this.yuvType == null) {
                this.yuvType = new Type.Builder(this.rs, Element.U8((RenderScript)this.rs)).setX(nv21.length);
                this.in = Allocation.createTyped((RenderScript)this.rs, (Type)this.yuvType.create(), (int)1);
                this.rgbaType = new Type.Builder(this.rs, Element.RGBA_8888((RenderScript)this.rs)).setX(width).setY(height);
                this.out = Allocation.createTyped((RenderScript)this.rs, (Type)this.rgbaType.create(), (int)1);
            }
            this.in.copyFrom(nv21);
            this.yuvToRgbIntrinsic.setInput(this.in);
            this.yuvToRgbIntrinsic.forEach(this.out);
            Bitmap bmpout = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            this.out.copyTo(bmpout);
            return bmpout;
        }
    }
}

