/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.vhallrtc.gpuimage;

import android.opengl.GLES20;
import com.vhall.vhallrtc.gpuimage.GPUImageFilter;

public class GPUImageBeautifyFilter
extends GPUImageFilter {
    public static final String BEAUTIFY_FRAGMENT_SHADER = "precision highp float;\nvarying highp vec2 textureCoordinate;\nuniform sampler2D inputImageTexture;\nuniform vec2 singleStepOffset;\nuniform vec4 params;\nconst vec3 W = vec3(0.299,0.587,0.114);const mat3 saturateMatrix = mat3(1.1102,-0.0598,-0.061,-0.0774,1.0826,-0.1186,-0.0228,-0.0228,1.1772);float hardlight(float color){\tif(color <= 0.5) {\t\tcolor = color * color * 2.0;\t} else { \t\tcolor = 1.0 - ((1.0 - color)*(1.0 - color) * 2.0);\t}\treturn color;}void main() {\tvec2 blurCoordinates[12];\tblurCoordinates[0] = textureCoordinate.xy + singleStepOffset * vec2(5.0, -8.0);\tblurCoordinates[1] = textureCoordinate.xy + singleStepOffset * vec2(5.0, 8.0);\tblurCoordinates[2] = textureCoordinate.xy + singleStepOffset * vec2(-5.0, 8.0);\tblurCoordinates[3] = textureCoordinate.xy + singleStepOffset * vec2(-5.0, -8.0);\tblurCoordinates[4] = textureCoordinate.xy + singleStepOffset * vec2(8.0, -5.0);\tblurCoordinates[5] = textureCoordinate.xy + singleStepOffset * vec2(8.0, 5.0);\tblurCoordinates[6] = textureCoordinate.xy + singleStepOffset * vec2(-8.0, 5.0);\tblurCoordinates[7] = textureCoordinate.xy + singleStepOffset * vec2(-8.0, -5.0);\tblurCoordinates[8] = textureCoordinate.xy + singleStepOffset * vec2(-4.0, -4.0);\tblurCoordinates[9] = textureCoordinate.xy + singleStepOffset * vec2(-4.0, 4.0);\tblurCoordinates[10] = textureCoordinate.xy + singleStepOffset * vec2(4.0, -4.0);\tblurCoordinates[11] = textureCoordinate.xy + singleStepOffset * vec2(4.0, 4.0);\tfloat sampleColor = texture2D(inputImageTexture,textureCoordinate).g * 22.0;\tsampleColor += texture2D(inputImageTexture,blurCoordinates[0]).g;\tsampleColor += texture2D(inputImageTexture,blurCoordinates[1]).g;\tsampleColor += texture2D(inputImageTexture,blurCoordinates[2]).g;\tsampleColor += texture2D(inputImageTexture,blurCoordinates[3]).g;\tsampleColor += texture2D(inputImageTexture,blurCoordinates[4]).g;\tsampleColor += texture2D(inputImageTexture,blurCoordinates[5]).g;\tsampleColor += texture2D(inputImageTexture,blurCoordinates[6]).g;\tsampleColor += texture2D(inputImageTexture,blurCoordinates[7]).g;\tsampleColor += texture2D(inputImageTexture,blurCoordinates[8]).g * 2.0;\tsampleColor += texture2D(inputImageTexture,blurCoordinates[9]).g * 2.0;\tsampleColor += texture2D(inputImageTexture,blurCoordinates[10]).g * 2.0;\tsampleColor += texture2D(inputImageTexture,blurCoordinates[11]).g * 2.0;\tsampleColor = sampleColor / 38.0;\tvec3 centralColor = texture2D(inputImageTexture,textureCoordinate).rgb;\tfloat highpass = centralColor.g - sampleColor + 0.5;\tfor(int i = 0; i < 5;i++) {\t\thighpass = hardlight(highpass);\t}\tfloat lumance = dot(centralColor, W);\tfloat alpha = pow(lumance, params.r);\tvec3 smoothColor = centralColor + (centralColor-vec3(highpass))*alpha*0.1;\tsmoothColor.r = clamp(pow(smoothColor.r, params.g),0.0,1.0);\tsmoothColor.g = clamp(pow(smoothColor.g, params.g),0.0,1.0);\tsmoothColor.b = clamp(pow(smoothColor.b, params.g),0.0,1.0);\tvec3 lvse = vec3(1.0)-(vec3(1.0)-smoothColor)*(vec3(1.0)-centralColor);\tvec3 bianliang = max(smoothColor, centralColor);\tvec3 rouguang = 2.0*centralColor*smoothColor + centralColor*centralColor - 2.0*centralColor*centralColor*smoothColor;\tgl_FragColor = vec4(mix(centralColor, lvse, alpha), 1.0);\tgl_FragColor.rgb = mix(gl_FragColor.rgb, bianliang, alpha);\tgl_FragColor.rgb = mix(gl_FragColor.rgb, rouguang, params.b);\tvec3 satcolor = gl_FragColor.rgb * saturateMatrix;\tgl_FragColor.rgb = mix(gl_FragColor.rgb, satcolor, params.a);}";
    public static final String BEAUTIFY_FRAGMENT_SHADER_HIGH = "precision highp float;\nvarying highp vec2 textureCoordinate;\nuniform sampler2D inputImageTexture;\nuniform vec2 singleStepOffset;\nuniform highp vec4 params;\nconst highp vec3 W = vec3(0.299,0.587,0.114);\n const mat3 saturateMatrix = mat3(\n 1.1102,-0.0598,-0.061,\n-0.0774,1.0826,-0.1186,\n -0.0228,-0.0228,1.1772);\nfloat hardlight(float color)\n{\n if(color <= 0.5)\n {\n color = color * color * 2.0;\n }\nelse\n {\n    color = 1.0 - ((1.0 - color)*(1.0 - color) * 2.0);\n }\n return color;\n }\nvoid main(){\n vec2 blurCoordinates[24];\n blurCoordinates[0] = textureCoordinate.xy + singleStepOffset * vec2(0.0, -10.0);\n blurCoordinates[1] = textureCoordinate.xy + singleStepOffset * vec2(0.0, 10.0);\n blurCoordinates[2] = textureCoordinate.xy + singleStepOffset * vec2(-10.0, 0.0);\nblurCoordinates[3] = textureCoordinate.xy + singleStepOffset * vec2(10.0, 0.0);\nblurCoordinates[4] = textureCoordinate.xy + singleStepOffset * vec2(5.0, -8.0);\nblurCoordinates[5] = textureCoordinate.xy + singleStepOffset * vec2(5.0, 8.0);\nblurCoordinates[6] = textureCoordinate.xy + singleStepOffset * vec2(-5.0, 8.0);\nblurCoordinates[7] = textureCoordinate.xy + singleStepOffset * vec2(-5.0, -8.0);\nblurCoordinates[8] = textureCoordinate.xy + singleStepOffset * vec2(8.0, -5.0);\nblurCoordinates[9] = textureCoordinate.xy + singleStepOffset * vec2(8.0, 5.0);\nblurCoordinates[10] = textureCoordinate.xy + singleStepOffset * vec2(-8.0, 5.0);\nblurCoordinates[11] = textureCoordinate.xy + singleStepOffset * vec2(-8.0, -5.0);\nblurCoordinates[12] = textureCoordinate.xy + singleStepOffset * vec2(0.0, -6.0);\nblurCoordinates[13] = textureCoordinate.xy + singleStepOffset * vec2(0.0, 6.0);\nblurCoordinates[14] = textureCoordinate.xy + singleStepOffset * vec2(6.0, 0.0);\nblurCoordinates[15] = textureCoordinate.xy + singleStepOffset * vec2(-6.0, 0.0);\nblurCoordinates[16] = textureCoordinate.xy + singleStepOffset * vec2(-4.0, -4.0);\nblurCoordinates[17] = textureCoordinate.xy + singleStepOffset * vec2(-4.0, 4.0);\nblurCoordinates[18] = textureCoordinate.xy + singleStepOffset * vec2(4.0, -4.0);\nblurCoordinates[19] = textureCoordinate.xy + singleStepOffset * vec2(4.0, 4.0);\nblurCoordinates[20] = textureCoordinate.xy + singleStepOffset * vec2(-2.0, -2.0);\nblurCoordinates[21] = textureCoordinate.xy + singleStepOffset * vec2(-2.0, 2.0);\nblurCoordinates[22] = textureCoordinate.xy + singleStepOffset * vec2(2.0, -2.0);\nblurCoordinates[23] = textureCoordinate.xy + singleStepOffset * vec2(2.0, 2.0);\n float sampleColor = texture2D(inputImageTexture, textureCoordinate).g * 22.0;\nsampleColor += texture2D(inputImageTexture, blurCoordinates[0]).g;\nsampleColor += texture2D(inputImageTexture, blurCoordinates[1]).g;\n sampleColor += texture2D(inputImageTexture, blurCoordinates[2]).g;\nsampleColor += texture2D(inputImageTexture, blurCoordinates[3]).g;\nsampleColor += texture2D(inputImageTexture, blurCoordinates[4]).g;\nsampleColor += texture2D(inputImageTexture, blurCoordinates[5]).g;\nsampleColor += texture2D(inputImageTexture, blurCoordinates[6]).g;\nsampleColor += texture2D(inputImageTexture, blurCoordinates[7]).g;\nsampleColor += texture2D(inputImageTexture, blurCoordinates[8]).g;\nsampleColor += texture2D(inputImageTexture, blurCoordinates[9]).g;\nsampleColor += texture2D(inputImageTexture, blurCoordinates[10]).g;\nsampleColor += texture2D(inputImageTexture, blurCoordinates[11]).g;\nsampleColor += texture2D(inputImageTexture, blurCoordinates[12]).g * 2.0;\nsampleColor += texture2D(inputImageTexture, blurCoordinates[13]).g * 2.0;\nsampleColor += texture2D(inputImageTexture, blurCoordinates[14]).g * 2.0;\nsampleColor += texture2D(inputImageTexture, blurCoordinates[15]).g * 2.0;\nsampleColor += texture2D(inputImageTexture, blurCoordinates[16]).g * 2.0;\nsampleColor += texture2D(inputImageTexture, blurCoordinates[17]).g * 2.0;\nsampleColor += texture2D(inputImageTexture, blurCoordinates[18]).g * 2.0;\n sampleColor += texture2D(inputImageTexture, blurCoordinates[19]).g * 2.0;\nsampleColor += texture2D(inputImageTexture, blurCoordinates[20]).g * 3.0;\nsampleColor += texture2D(inputImageTexture, blurCoordinates[21]).g * 3.0;\nsampleColor += texture2D(inputImageTexture, blurCoordinates[22]).g * 3.0;\nsampleColor += texture2D(inputImageTexture, blurCoordinates[23]).g * 3.0;\nsampleColor = sampleColor / 62.0;\nvec3 centralColor = texture2D(inputImageTexture, textureCoordinate).rgb;\nfloat highpass = centralColor.g - sampleColor + 0.5;\nfor(int i = 0; i < 5;i++)\n {\n    highpass = hardlight(highpass);\n }\nfloat lumance = dot(centralColor, W);\n float alpha = pow(lumance, params.r);\nvec3 smoothColor = centralColor + (centralColor-vec3(highpass))*alpha*0.1;\n smoothColor.r = clamp(pow(smoothColor.r, params.g),0.0,1.0);\nsmoothColor.g = clamp(pow(smoothColor.g, params.g),0.0,1.0);\nsmoothColor.b = clamp(pow(smoothColor.b, params.g),0.0,1.0);\nvec3 lvse = vec3(1.0)-(vec3(1.0)-smoothColor)*(vec3(1.0)-centralColor);\n vec3 bianliang = max(smoothColor, centralColor);\n vec3 rouguang = 2.0*centralColor*smoothColor + centralColor*centralColor - 2.0*centralColor*centralColor*smoothColor;\ngl_FragColor = vec4(mix(centralColor, lvse, alpha), 1.0);\n gl_FragColor.rgb = mix(gl_FragColor.rgb, bianliang, alpha);\n gl_FragColor.rgb = mix(gl_FragColor.rgb, rouguang, params.b);\n vec3 satcolor = gl_FragColor.rgb * saturateMatrix;\n gl_FragColor.rgb = mix(gl_FragColor.rgb, satcolor, params.a);\n }\n";
    private int mSingleStepOffsetLocation;
    private int mParamsLocation;
    private int mBeautifyLevel;
    private int mInputWidth;
    private int mInputHeight;

    public GPUImageBeautifyFilter() {
        this(1280, 720, 0);
    }

    public GPUImageBeautifyFilter(int inWidth, int inHeight) {
        super("attribute vec4 position;\nattribute vec4 inputTextureCoordinate;\n \nvarying vec2 textureCoordinate;\n \nvoid main()\n{\n    gl_Position = position;\n    textureCoordinate = inputTextureCoordinate.xy;\n}", BEAUTIFY_FRAGMENT_SHADER);
        this.mBeautifyLevel = 0;
        this.mInputWidth = inWidth;
        this.mInputHeight = inHeight;
    }

    public GPUImageBeautifyFilter(int inWidth, int inHeight, int level) {
        super("attribute vec4 position;\nattribute vec4 inputTextureCoordinate;\n \nvarying vec2 textureCoordinate;\n \nvoid main()\n{\n    gl_Position = position;\n    textureCoordinate = inputTextureCoordinate.xy;\n}", BEAUTIFY_FRAGMENT_SHADER);
        this.mBeautifyLevel = level;
        this.mInputWidth = inWidth;
        this.mInputHeight = inHeight;
    }

    @Override
    public void onInit() {
        super.onInit();
        this.mSingleStepOffsetLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"singleStepOffset");
        this.mParamsLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"params");
    }

    @Override
    public void onInitialized() {
        super.onInitialized();
        this.setBeautifyLevel(this.mBeautifyLevel);
        this.setInputTextureSize(this.mInputWidth, this.mInputHeight);
    }

    public void setBeautifyLevel(int level) {
        float[][] beautify_level = new float[][]{{1.0f, 1.0f, 0.15f, 0.15f}, {0.8f, 0.9f, 0.2f, 0.2f}, {0.6f, 0.8f, 0.25f, 0.25f}, {0.4f, 0.7f, 0.38f, 0.3f}, {0.33f, 0.63f, 0.4f, 0.35f}};
        level = level < 0 ? 0 : (level > 4 ? 4 : level);
        this.setFloatVec4(this.mParamsLocation, beautify_level[level]);
    }

    public void setInputTextureSize(int width, int height) {
        this.setFloatVec2(this.mSingleStepOffsetLocation, new float[]{2.0f / (float)width, 2.0f / (float)height});
    }
}

