/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.vhallrtc.gpuimage;

import android.opengl.GLES20;
import com.vhall.vhallrtc.gpuimage.GPUImageFilter;

public class GPUImageBaseParamFilter
extends GPUImageFilter {
    public static final String BASE_PARAM_FRAGMENT_SHADER = "varying highp vec2 textureCoordinate;\n\nuniform sampler2D inputImageTexture;\nuniform lowp float brightness;\nuniform lowp float contrast;\nuniform lowp float saturation;\n\n// Values from \"Graphics Shaders: Theory and Practice\" by Bailey and Cunningham\nconst mediump vec3 luminanceWeighting = vec3(0.2125, 0.7154, 0.0721);\n\nvoid main()\n{\n\tlowp vec4 textureColor = texture2D(inputImageTexture, textureCoordinate);\n\t\n\ttextureColor = vec4((textureColor.rgb + vec3(brightness)), textureColor.w);\n\t\n\ttextureColor = vec4(((textureColor.rgb - vec3(0.5)) * contrast + vec3(0.5)), textureColor.w);\n\t\n\tlowp float luminance = dot(textureColor.rgb, luminanceWeighting);\n\tlowp vec3 greyScaleColor = vec3(luminance);\n\t\n\tgl_FragColor = vec4(mix(greyScaleColor, textureColor.rgb, saturation), textureColor.w);\n}\n";
    private int mBrightnessLocation;
    private int mContrastLocation;
    private int mSaturationLocation;
    private float mBrightness;
    private float mContrast;
    private float mSaturation;

    public GPUImageBaseParamFilter() {
        this(0.0f, 1.0f, 1.0f);
    }

    public GPUImageBaseParamFilter(float brightness, float contrast, float saturation) {
        super("attribute vec4 position;\nattribute vec4 inputTextureCoordinate;\n \nvarying vec2 textureCoordinate;\n \nvoid main()\n{\n    gl_Position = position;\n    textureCoordinate = inputTextureCoordinate.xy;\n}", BASE_PARAM_FRAGMENT_SHADER);
        this.mBrightness = brightness;
        this.mContrast = contrast;
        this.mSaturation = saturation;
    }

    @Override
    public void onInit() {
        super.onInit();
        this.mBrightnessLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"brightness");
        this.mContrastLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"contrast");
        this.mSaturationLocation = GLES20.glGetUniformLocation((int)this.getProgram(), (String)"saturation");
    }

    @Override
    public void onInitialized() {
        super.onInitialized();
        this.setBrightness(this.mBrightness);
        this.setContrast(this.mContrast);
        this.setSaturation(this.mSaturation);
    }

    public void setBrightness(float brightness) {
        this.mBrightness = brightness;
        this.setFloat(this.mBrightnessLocation, this.mBrightness);
    }

    public void setContrast(float contrast) {
        this.mContrast = contrast;
        this.setFloat(this.mContrastLocation, this.mContrast);
    }

    public void setSaturation(float saturation) {
        this.mSaturation = saturation;
        this.setFloat(this.mSaturationLocation, this.mSaturation);
    }
}

