/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.vhallrtc.common;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioDeviceInfo;
import android.media.AudioManager;
import android.os.Build;
import com.vhall.vhallrtc.common.AppRTCBluetoothManager;
import com.vhall.vhallrtc.common.AppRTCProximitySensor;
import com.vhall.vhallrtc.common.LogManager;
import com.vhall.vhallrtc.common.Tool;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import org.vhwebrtc.ThreadUtils;

public class AppRTCAudioManager {
    private static final String TAG = "AppRTCAudioManager";
    private static final String SPEAKERPHONE_AUTO = "auto";
    private static final String SPEAKERPHONE_TRUE = "true";
    private static final String SPEAKERPHONE_FALSE = "false";
    private final Context apprtcContext;
    private AudioManager audioManager;
    private AudioManagerEvents audioManagerEvents;
    private AudioManagerState amState;
    private int savedAudioMode = -2;
    private boolean savedIsSpeakerPhoneOn = false;
    private boolean savedIsMicrophoneMute = false;
    private boolean hasWiredHeadset = false;
    private AudioDevice defaultAudioDevice;
    private AudioDevice selectedAudioDevice;
    private AudioDevice userSelectedAudioDevice;
    private final String useSpeakerphone;
    private AppRTCProximitySensor proximitySensor = null;
    private final AppRTCBluetoothManager bluetoothManager;
    private Set<AudioDevice> audioDevices = new HashSet<AudioDevice>();
    private BroadcastReceiver wiredHeadsetReceiver;
    private AudioManager.OnAudioFocusChangeListener audioFocusChangeListener;
    private static LinkedList<HeadsetDevice> connectedHeadsets = new LinkedList();

    private void onProximitySensorChangedState() {
        if (!this.useSpeakerphone.equals(SPEAKERPHONE_AUTO)) {
            return;
        }
        if (this.audioDevices.size() == 2 && this.audioDevices.contains((Object)AudioDevice.EARPIECE) && this.audioDevices.contains((Object)AudioDevice.SPEAKER_PHONE)) {
            if (this.proximitySensor.sensorReportsNearState()) {
                this.setAudioDeviceInternal(AudioDevice.EARPIECE);
            } else {
                this.setAudioDeviceInternal(AudioDevice.SPEAKER_PHONE);
            }
        }
    }

    public static void headsetConnected(HeadsetDevice device) {
        for (HeadsetDevice headsetDevice : connectedHeadsets) {
            if (!headsetDevice.getAddress().equals(device.getAddress())) continue;
            return;
        }
        connectedHeadsets.add(device);
    }

    public static void headsetDisconnected(String address) {
        if (Build.VERSION.SDK_INT >= 24) {
            connectedHeadsets.removeIf(device -> device.getAddress().equals(address));
        } else {
            Iterator iterator = connectedHeadsets.iterator();
            while (iterator.hasNext()) {
                HeadsetDevice device2 = (HeadsetDevice)iterator.next();
                if (!device2.getAddress().equals(address)) continue;
                iterator.remove();
            }
        }
    }

    public static AudioDevice getLastHeadsetDevice() {
        if (!connectedHeadsets.isEmpty()) {
            return connectedHeadsets.getLast().getType();
        }
        return AudioDevice.NONE;
    }

    public static AppRTCAudioManager create(Context context) {
        return new AppRTCAudioManager(context);
    }

    private AppRTCAudioManager(Context context) {
        LogManager.d(TAG, "ctor");
        ThreadUtils.checkIsOnMainThread();
        this.apprtcContext = context;
        this.audioManager = (AudioManager)context.getSystemService("audio");
        this.bluetoothManager = AppRTCBluetoothManager.create(context, this);
        this.wiredHeadsetReceiver = new WiredHeadsetReceiver();
        this.amState = AudioManagerState.UNINITIALIZED;
        this.useSpeakerphone = SPEAKERPHONE_AUTO;
        LogManager.d(TAG, "useSpeakerphone: " + this.useSpeakerphone);
        this.defaultAudioDevice = this.useSpeakerphone.equals(SPEAKERPHONE_FALSE) ? AudioDevice.EARPIECE : AudioDevice.SPEAKER_PHONE;
        this.proximitySensor = AppRTCProximitySensor.create(context, new Runnable(){

            @Override
            public void run() {
                AppRTCAudioManager.this.onProximitySensorChangedState();
            }
        });
        LogManager.d(TAG, "defaultAudioDevice: " + (Object)((Object)this.defaultAudioDevice));
        Tool.logDeviceInfo(TAG);
    }

    public void start(AudioManagerEvents audioManagerEvents) {
        LogManager.d(TAG, "start");
        ThreadUtils.checkIsOnMainThread();
        if (this.amState == AudioManagerState.RUNNING) {
            LogManager.e(TAG, "AudioManager is already active");
            return;
        }
        LogManager.d(TAG, "AudioManager starts...");
        this.audioManagerEvents = audioManagerEvents;
        this.amState = AudioManagerState.RUNNING;
        this.savedAudioMode = this.audioManager.getMode();
        this.savedIsSpeakerPhoneOn = this.audioManager.isSpeakerphoneOn();
        this.savedIsMicrophoneMute = this.audioManager.isMicrophoneMute();
        this.hasWiredHeadset = this.hasWiredHeadset();
        this.audioFocusChangeListener = new AudioManager.OnAudioFocusChangeListener(){

            public void onAudioFocusChange(int focusChange) {
                String typeOfChange = "AUDIOFOCUS_NOT_DEFINED";
                switch (focusChange) {
                    case 1: {
                        typeOfChange = "AUDIOFOCUS_GAIN";
                        break;
                    }
                    case 2: {
                        typeOfChange = "AUDIOFOCUS_GAIN_TRANSIENT";
                        break;
                    }
                    case 4: {
                        typeOfChange = "AUDIOFOCUS_GAIN_TRANSIENT_EXCLUSIVE";
                        break;
                    }
                    case 3: {
                        typeOfChange = "AUDIOFOCUS_GAIN_TRANSIENT_MAY_DUCK";
                        break;
                    }
                    case -1: {
                        typeOfChange = "AUDIOFOCUS_LOSS";
                        break;
                    }
                    case -2: {
                        typeOfChange = "AUDIOFOCUS_LOSS_TRANSIENT";
                        break;
                    }
                    case -3: {
                        typeOfChange = "AUDIOFOCUS_LOSS_TRANSIENT_CAN_DUCK";
                        break;
                    }
                    default: {
                        typeOfChange = "AUDIOFOCUS_INVALID";
                    }
                }
                LogManager.d(AppRTCAudioManager.TAG, "onAudioFocusChange: " + typeOfChange);
            }
        };
        int result = this.audioManager.requestAudioFocus(this.audioFocusChangeListener, 0, 1);
        if (result == 1) {
            LogManager.d(TAG, "Audio focus request granted for VOICE_CALL streams");
        } else {
            LogManager.e(TAG, "Audio focus request failed");
        }
        this.audioManager.setMode(3);
        this.setMicrophoneMute(false);
        this.userSelectedAudioDevice = AudioDevice.NONE;
        this.selectedAudioDevice = AudioDevice.NONE;
        this.audioDevices.clear();
        this.bluetoothManager.start();
        this.updateAudioDeviceState();
        this.registerReceiver(this.wiredHeadsetReceiver, new IntentFilter("android.intent.action.HEADSET_PLUG"));
        LogManager.d(TAG, "AudioManager started");
    }

    public void stop() {
        LogManager.d(TAG, "stop");
        ThreadUtils.checkIsOnMainThread();
        if (this.amState != AudioManagerState.RUNNING) {
            LogManager.e(TAG, "Trying to stop AudioManager in incorrect state: " + (Object)((Object)this.amState));
            return;
        }
        this.amState = AudioManagerState.UNINITIALIZED;
        this.unregisterReceiver(this.wiredHeadsetReceiver);
        this.bluetoothManager.stop();
        this.setSpeakerphoneOn(this.savedIsSpeakerPhoneOn);
        this.setMicrophoneMute(this.savedIsMicrophoneMute);
        this.audioManager.setMode(this.savedAudioMode);
        this.audioManager.abandonAudioFocus(this.audioFocusChangeListener);
        this.audioFocusChangeListener = null;
        LogManager.d(TAG, "Abandoned audio focus for VOICE_CALL streams");
        if (this.proximitySensor != null) {
            this.proximitySensor.stop();
            this.proximitySensor = null;
        }
        this.audioManagerEvents = null;
        LogManager.d(TAG, "AudioManager stopped");
    }

    private void setAudioDeviceInternal(AudioDevice device) {
        LogManager.d(TAG, "setAudioDeviceInternal(device=" + (Object)((Object)device) + ")");
        switch (device) {
            case SPEAKER_PHONE: {
                this.setSpeakerphoneOn(true);
                break;
            }
            case EARPIECE: {
                this.setSpeakerphoneOn(false);
                break;
            }
            case WIRED_HEADSET: {
                this.setSpeakerphoneOn(false);
                break;
            }
            case BLUETOOTH: {
                this.setSpeakerphoneOn(false);
                break;
            }
            default: {
                LogManager.e(TAG, "Invalid audio device selection");
            }
        }
        if (!this.audioDevices.contains((Object)device)) {
            return;
        }
        this.selectedAudioDevice = device;
    }

    public void setDefaultAudioDevice(AudioDevice defaultDevice) {
        ThreadUtils.checkIsOnMainThread();
        switch (defaultDevice) {
            case SPEAKER_PHONE: {
                this.defaultAudioDevice = defaultDevice;
                break;
            }
            case EARPIECE: {
                if (this.hasEarpiece()) {
                    this.defaultAudioDevice = defaultDevice;
                    break;
                }
                this.defaultAudioDevice = AudioDevice.SPEAKER_PHONE;
                break;
            }
            default: {
                LogManager.e(TAG, "Invalid default audio device selection");
            }
        }
        LogManager.d(TAG, "setDefaultAudioDevice(device=" + (Object)((Object)this.defaultAudioDevice) + ")");
        this.updateAudioDeviceState();
    }

    public void selectAudioDevice(AudioDevice device) {
        ThreadUtils.checkIsOnMainThread();
        if (!this.audioDevices.contains((Object)device)) {
            LogManager.e(TAG, "Can not select " + (Object)((Object)device) + " from available " + this.audioDevices);
        }
        this.userSelectedAudioDevice = device;
        this.updateAudioDeviceState();
    }

    public Set<AudioDevice> getAudioDevices() {
        ThreadUtils.checkIsOnMainThread();
        return Collections.unmodifiableSet(new HashSet<AudioDevice>(this.audioDevices));
    }

    public AudioDevice getSelectedAudioDevice() {
        ThreadUtils.checkIsOnMainThread();
        return this.selectedAudioDevice;
    }

    private void registerReceiver(BroadcastReceiver receiver, IntentFilter filter) {
        this.apprtcContext.registerReceiver(receiver, filter);
    }

    private void unregisterReceiver(BroadcastReceiver receiver) {
        this.apprtcContext.unregisterReceiver(receiver);
    }

    private void setSpeakerphoneOn(boolean on) {
        boolean wasOn = this.audioManager.isSpeakerphoneOn();
        if (wasOn == on) {
            return;
        }
        this.audioManager.setSpeakerphoneOn(on);
    }

    private void setMicrophoneMute(boolean on) {
        boolean wasMuted = this.audioManager.isMicrophoneMute();
        if (wasMuted == on) {
            return;
        }
        this.audioManager.setMicrophoneMute(on);
    }

    private boolean hasEarpiece() {
        return this.apprtcContext.getPackageManager().hasSystemFeature("android.hardware.telephony");
    }

    @Deprecated
    private boolean hasWiredHeadset() {
        AudioDeviceInfo[] devices;
        if (Build.VERSION.SDK_INT < 23) {
            return this.audioManager.isWiredHeadsetOn();
        }
        for (AudioDeviceInfo device : devices = this.audioManager.getDevices(3)) {
            int type = device.getType();
            if (type == 3) {
                LogManager.d(TAG, "hasWiredHeadset: found wired headset");
                return true;
            }
            if (type != 11) continue;
            LogManager.d(TAG, "hasWiredHeadset: found USB audio device");
            return true;
        }
        return false;
    }

    public void updateAudioDeviceState() {
        boolean needBluetoothAudioStop;
        ThreadUtils.checkIsOnMainThread();
        LogManager.d(TAG, "--- updateAudioDeviceState: wired headset=" + this.hasWiredHeadset + ", BT state=" + (Object)((Object)this.bluetoothManager.getState()));
        LogManager.d(TAG, "Device status: available=" + this.audioDevices + ", selected=" + (Object)((Object)this.selectedAudioDevice) + ", user selected=" + (Object)((Object)this.userSelectedAudioDevice));
        if (this.bluetoothManager.getState() == AppRTCBluetoothManager.State.HEADSET_AVAILABLE || this.bluetoothManager.getState() == AppRTCBluetoothManager.State.HEADSET_UNAVAILABLE || this.bluetoothManager.getState() == AppRTCBluetoothManager.State.SCO_DISCONNECTING) {
            this.bluetoothManager.updateDevice();
        }
        HashSet<AudioDevice> newAudioDevices = new HashSet<AudioDevice>();
        if (this.bluetoothManager.getState() == AppRTCBluetoothManager.State.SCO_CONNECTED || this.bluetoothManager.getState() == AppRTCBluetoothManager.State.SCO_CONNECTING || this.bluetoothManager.getState() == AppRTCBluetoothManager.State.HEADSET_AVAILABLE) {
            newAudioDevices.add(AudioDevice.BLUETOOTH);
        }
        if (this.hasWiredHeadset) {
            newAudioDevices.add(AudioDevice.WIRED_HEADSET);
        } else {
            newAudioDevices.add(AudioDevice.SPEAKER_PHONE);
            if (this.hasEarpiece()) {
                newAudioDevices.add(AudioDevice.EARPIECE);
            }
        }
        boolean audioDeviceSetUpdated = !this.audioDevices.equals(newAudioDevices);
        this.audioDevices = newAudioDevices;
        if (this.bluetoothManager.getState() == AppRTCBluetoothManager.State.HEADSET_UNAVAILABLE && this.userSelectedAudioDevice == AudioDevice.BLUETOOTH) {
            this.userSelectedAudioDevice = AudioDevice.NONE;
        }
        if (this.hasWiredHeadset && this.userSelectedAudioDevice == AudioDevice.SPEAKER_PHONE) {
            this.userSelectedAudioDevice = AudioDevice.WIRED_HEADSET;
        }
        if (!this.hasWiredHeadset && this.userSelectedAudioDevice == AudioDevice.WIRED_HEADSET) {
            this.userSelectedAudioDevice = AudioDevice.SPEAKER_PHONE;
        }
        boolean needBluetoothAudioStart = this.bluetoothManager.getState() == AppRTCBluetoothManager.State.HEADSET_AVAILABLE && (this.userSelectedAudioDevice == AudioDevice.NONE && AppRTCAudioManager.getLastHeadsetDevice() == AudioDevice.BLUETOOTH || this.userSelectedAudioDevice == AudioDevice.BLUETOOTH);
        boolean bl = needBluetoothAudioStop = (this.bluetoothManager.getState() == AppRTCBluetoothManager.State.SCO_CONNECTED || this.bluetoothManager.getState() == AppRTCBluetoothManager.State.SCO_CONNECTING) && (this.userSelectedAudioDevice != AudioDevice.NONE && this.userSelectedAudioDevice != AudioDevice.BLUETOOTH || this.userSelectedAudioDevice == AudioDevice.NONE && AppRTCAudioManager.getLastHeadsetDevice() != AudioDevice.BLUETOOTH);
        if (this.bluetoothManager.getState() == AppRTCBluetoothManager.State.HEADSET_AVAILABLE || this.bluetoothManager.getState() == AppRTCBluetoothManager.State.SCO_CONNECTING || this.bluetoothManager.getState() == AppRTCBluetoothManager.State.SCO_CONNECTED) {
            LogManager.d(TAG, "Need BT audio: start=" + needBluetoothAudioStart + ", stop=" + needBluetoothAudioStop + ", BT state=" + (Object)((Object)this.bluetoothManager.getState()));
        }
        if (needBluetoothAudioStop) {
            this.bluetoothManager.stopScoAudio();
            this.bluetoothManager.updateDevice();
        }
        if (needBluetoothAudioStart && !needBluetoothAudioStop) {
            int result = this.audioManager.requestAudioFocus(this.audioFocusChangeListener, 0, 1);
            if (result == 1) {
                LogManager.d(TAG, "Audio focus request granted for VOICE_CALL streams");
            } else {
                LogManager.e(TAG, "Audio focus request failed");
            }
            this.setSpeakerphoneOn(false);
            if (!this.bluetoothManager.startScoAudio()) {
                this.audioDevices.remove((Object)AudioDevice.BLUETOOTH);
                audioDeviceSetUpdated = true;
            }
        }
        AudioDevice newAudioDevice = this.selectedAudioDevice;
        newAudioDevice = this.bluetoothManager.getState() == AppRTCBluetoothManager.State.SCO_CONNECTED || needBluetoothAudioStart ? AudioDevice.BLUETOOTH : (this.hasWiredHeadset ? AudioDevice.WIRED_HEADSET : this.defaultAudioDevice);
        if (newAudioDevice != this.selectedAudioDevice || audioDeviceSetUpdated) {
            this.setAudioDeviceInternal(newAudioDevice);
            LogManager.d(TAG, "New device status: available=" + this.audioDevices + ", selected=" + (Object)((Object)newAudioDevice));
            if (this.audioManagerEvents != null) {
                this.audioManagerEvents.onAudioDeviceChanged(this.selectedAudioDevice, this.audioDevices);
            }
        }
        LogManager.d(TAG, "--- updateAudioDeviceState done");
    }

    private class WiredHeadsetReceiver
    extends BroadcastReceiver {
        private static final int STATE_UNPLUGGED = 0;
        private static final int STATE_PLUGGED = 1;
        private static final int HAS_NO_MIC = 0;
        private static final int HAS_MIC = 1;

        private WiredHeadsetReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            int state = intent.getIntExtra("state", 0);
            int microphone = intent.getIntExtra("microphone", 0);
            String name = intent.getStringExtra("name");
            LogManager.d(AppRTCAudioManager.TAG, "WiredHeadsetReceiver.onReceive" + Tool.getThreadInfo() + ": a=" + intent.getAction() + ", s=" + (state == 0 ? "unplugged" : "plugged") + ", m=" + (microphone == 1 ? "mic" : "no mic") + ", n=" + name + ", sb=" + this.isInitialStickyBroadcast());
            if (state == 1) {
                AppRTCAudioManager.headsetConnected(new HeadsetDevice(AudioDevice.WIRED_HEADSET, name != null ? name : "WIRED_HEADSET"));
            } else if (state == 0) {
                AppRTCAudioManager.headsetDisconnected(name != null ? name : "WIRED_HEADSET");
            }
            AppRTCAudioManager.this.hasWiredHeadset = state == 1;
            AppRTCAudioManager.this.updateAudioDeviceState();
        }
    }

    public static class HeadsetDevice {
        private final AudioDevice type;
        private final String address;

        public HeadsetDevice(AudioDevice type, String address) {
            this.type = type;
            this.address = address;
        }

        public AudioDevice getType() {
            return this.type;
        }

        public String getAddress() {
            return this.address;
        }
    }

    public static interface AudioManagerEvents {
        public void onAudioDeviceChanged(AudioDevice var1, Set<AudioDevice> var2);
    }

    public static enum AudioManagerState {
        UNINITIALIZED,
        PREINITIALIZED,
        RUNNING;

    }

    public static enum AudioDevice {
        SPEAKER_PHONE,
        WIRED_HEADSET,
        EARPIECE,
        BLUETOOTH,
        NONE;

    }
}

