/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.vhallrtc.client;

import android.app.Activity;
import android.content.Context;
import android.util.AttributeSet;
import android.util.Log;
import android.view.GestureDetector;
import android.view.MotionEvent;
import com.vhall.vhallrtc.client.Stream;
import org.vhwebrtc.SurfaceViewRenderer;
import org.vhwebrtc.VideoFrame;

public class VHRenderView
extends SurfaceViewRenderer {
    private final String TAG = "VHRenderView";
    private Activity mActivity;
    public Stream stream;
    public VideoFrame frame = null;
    private boolean mAutoFocusEnable = true;
    private GestureDetector mGestureDetector = null;

    public VHRenderView(Context context) {
        super(context);
        if (!this.isInEditMode()) {
            this.mActivity = (Activity)context;
        }
        this.init();
    }

    public VHRenderView(Context context, AttributeSet attrs) {
        super(context, attrs);
        if (!this.isInEditMode()) {
            this.mActivity = (Activity)context;
        }
        this.init();
    }

    private void init() {
        this.mGestureDetector = new GestureDetector((Context)this.mActivity, (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

            public boolean onDown(MotionEvent e) {
                return !VHRenderView.this.mAutoFocusEnable || super.onDown(e);
            }

            public boolean onSingleTapUp(MotionEvent e) {
                Log.i((String)"VHRenderView", (String)("onSingleTapUp:X=" + e.getX() + ",Y=" + e.getY()));
                if (null != VHRenderView.this.stream) {
                    VHRenderView.this.stream.doOnAreaFocus((int)e.getX(), (int)e.getY(), VHRenderView.this.getWidth(), VHRenderView.this.getHeight());
                }
                return false;
            }
        });
    }

    public Stream getStream() {
        return this.stream;
    }

    public void onFrame(VideoFrame frame) {
        super.onFrame(frame);
        this.frame = frame;
    }

    public VideoFrame getVideoFrame() {
        if (this.frame != null) {
            return this.frame;
        }
        return null;
    }

    void changeAutoFocusEnable(boolean enable) {
        this.mAutoFocusEnable = enable;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.mAutoFocusEnable && event.getPointerCount() == 1) {
            return this.mGestureDetector.onTouchEvent(event);
        }
        return super.onTouchEvent(event);
    }
}

