/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.vhallrtc.client;

import android.content.Context;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.hardware.Camera;
import android.media.MediaRecorder;
import android.os.Handler;
import android.os.SystemClock;
import android.util.Log;
import android.view.WindowManager;
import com.vhall.vhallrtc.client.ByteBufferMemoryPool;
import com.vhall.vhallrtc.client.IFocusModeChangeListener;
import com.vhall.vhallrtc.client.VHBeautifyFilter;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.vhwebrtc.Camera1Enumerator;
import org.vhwebrtc.CameraEnumerationAndroid;
import org.vhwebrtc.CameraSession;
import org.vhwebrtc.Histogram;
import org.vhwebrtc.Logging;
import org.vhwebrtc.NV21Buffer;
import org.vhwebrtc.Size;
import org.vhwebrtc.SurfaceTextureHelper;
import org.vhwebrtc.VideoFrame;
import org.vhwebrtc.VideoSink;

public class VHCameraSession
implements CameraSession {
    private static final String TAG = "Camera1Session";
    private static final int NUMBER_OF_CAPTURE_BUFFERS = 3;
    private static final Histogram camera1StartTimeMsHistogram = Histogram.createCounts((String)"WebRTC.Android.Camera1.StartTimeMs", (int)1, (int)10000, (int)50);
    private static final Histogram camera1StopTimeMsHistogram = Histogram.createCounts((String)"WebRTC.Android.Camera1.StopTimeMs", (int)1, (int)10000, (int)50);
    private static final Histogram camera1ResolutionHistogram = Histogram.createEnumeration((String)"WebRTC.Android.Camera1.Resolution", (int)CameraEnumerationAndroid.COMMON_RESOLUTIONS.size());
    public static boolean enableBeautify = false;
    public static boolean enableCaptureCallback = false;
    private final Handler cameraThreadHandler;
    private final CameraSession.Events events;
    private final boolean captureToTexture;
    private final Context applicationContext;
    private final SurfaceTextureHelper surfaceTextureHelper;
    private final int cameraId;
    private final Camera mCamera;
    private final Camera.CameraInfo info;
    private final CameraEnumerationAndroid.CaptureFormat captureFormat;
    private final long constructionTimeNs;
    private SessionState state;
    private boolean firstFrameReported = false;
    private static VHBeautifyFilter beautifyFilter;
    private boolean isMirror = false;
    private VHBeautifyFilter.OnDataReceivedListener receivedListener = new VHBeautifyFilter.OnDataReceivedListener(){

        @Override
        public void onData(final byte[] data, final ByteBufferMemoryPool memoryPool) {
            VHCameraSession.this.cameraThreadHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (VHCameraSession.this.state == SessionState.RUNNING) {
                        VHCameraSession.this.frameCaptured(data, null, memoryPool);
                    }
                }
            });
        }
    };

    public static void setBeautifyLevel(int level) {
        if (beautifyFilter != null) {
            beautifyFilter.setBeautifyLevel(level);
        }
    }

    public static void setEnableCaptureCallback(boolean enable, VHBeautifyFilter.VideoCaptureCallback callback) {
        enableCaptureCallback = enable;
        if (beautifyFilter != null) {
            beautifyFilter.setEnableCaptureCallback(enable, callback);
        }
    }

    public void switchAutoFocusMode(boolean isAuto, IFocusModeChangeListener focusCallback) {
        if (isAuto) {
            if (this.checkIfSupportAutoFocus()) {
                try {
                    this.turnOnAutoFocus();
                    focusCallback.onComplete(true, null);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    focusCallback.onComplete(false, "\u5f53\u524d\u6444\u50cf\u5934\u4e0d\u652f\u6301\u81ea\u52a8\u5bf9\u7126");
                }
            } else {
                focusCallback.onComplete(false, "\u5f53\u524d\u6444\u50cf\u5934\u4e0d\u652f\u6301\u81ea\u52a8\u5bf9\u7126");
            }
        } else if (this.checkIfSupportAreaFocus()) {
            focusCallback.onComplete(true, null);
            this.tryFocusOnCenter();
        } else {
            focusCallback.onComplete(false, "\u5f53\u524d\u6444\u50cf\u5934\u4e0d\u652f\u6301\u624b\u52a8\u5bf9\u7126");
        }
    }

    public void doOnAreaFocus(int x, int y, int surfaceWidth, int surfaceHeight) {
        this.focusOnTouch(x, y, surfaceWidth, surfaceHeight);
    }

    public void setMirror(boolean mirror) {
        this.isMirror = mirror;
    }

    public static void create(CameraSession.CreateSessionCallback callback, CameraSession.Events events, boolean captureToTexture, Context applicationContext, SurfaceTextureHelper surfaceTextureHelper, MediaRecorder mediaRecorder, int cameraId, int width, int height, int framerate) {
        Camera camera;
        long constructionTimeNs = System.nanoTime();
        Logging.d((String)TAG, (String)("Open camera " + cameraId));
        events.onCameraOpening();
        try {
            camera = Camera.open((int)cameraId);
        }
        catch (RuntimeException e) {
            callback.onFailure(CameraSession.FailureType.ERROR, e.getMessage());
            return;
        }
        if (camera == null) {
            callback.onFailure(CameraSession.FailureType.ERROR, "android.hardware.Camera.open returned null for camera id = " + cameraId);
            return;
        }
        try {
            camera.setPreviewTexture(surfaceTextureHelper.getSurfaceTexture());
        }
        catch (IOException | RuntimeException e) {
            camera.release();
            callback.onFailure(CameraSession.FailureType.ERROR, e.getMessage());
            return;
        }
        Camera.CameraInfo info = new Camera.CameraInfo();
        Camera.getCameraInfo((int)cameraId, (Camera.CameraInfo)info);
        Camera.Parameters parameters = camera.getParameters();
        CameraEnumerationAndroid.CaptureFormat captureFormat = VHCameraSession.findClosestCaptureFormatVhall(parameters, width, height, framerate);
        Size pictureSize = VHCameraSession.findClosestPictureSize(parameters, width, height);
        try {
            VHCameraSession.updateCameraParameters(camera, parameters, captureFormat, pictureSize, captureToTexture);
        }
        catch (Exception e) {
            e.printStackTrace();
            captureFormat = VHCameraSession.findClosestCaptureFormat(parameters, width, height, framerate);
            VHCameraSession.updateCameraParameters(camera, parameters, captureFormat, pictureSize, captureToTexture);
        }
        if (!captureToTexture) {
            int frameSize = captureFormat.frameSize();
            for (int i = 0; i < 3; ++i) {
                ByteBuffer buffer = ByteBuffer.allocateDirect(frameSize);
                camera.addCallbackBuffer(buffer.array());
            }
        }
        camera.setDisplayOrientation(0);
        callback.onDone((CameraSession)new VHCameraSession(events, captureToTexture, applicationContext, surfaceTextureHelper, mediaRecorder, cameraId, camera, info, captureFormat, constructionTimeNs));
    }

    private static void updateCameraParameters(Camera camera, Camera.Parameters parameters, CameraEnumerationAndroid.CaptureFormat captureFormat, Size pictureSize, boolean captureToTexture) {
        List focusModes = parameters.getSupportedFocusModes();
        parameters.setPreviewFpsRange(captureFormat.framerate.min, captureFormat.framerate.max);
        parameters.setPreviewSize(captureFormat.width, captureFormat.height);
        parameters.setPictureSize(pictureSize.width, pictureSize.height);
        if (!captureToTexture) {
            Objects.requireNonNull(captureFormat);
            parameters.setPreviewFormat(17);
        }
        if (parameters.isVideoStabilizationSupported()) {
            parameters.setVideoStabilization(true);
        }
        if (null != focusModes && focusModes.contains("continuous-video")) {
            parameters.setFocusMode("continuous-video");
        }
        camera.setParameters(parameters);
    }

    private static CameraEnumerationAndroid.CaptureFormat findClosestCaptureFormatVhall(Camera.Parameters parameters, int width, int height, int framerate) {
        List supportedFramerates = Camera1Enumerator.convertFramerates((List)parameters.getSupportedPreviewFpsRange());
        Logging.d((String)TAG, (String)("Available fps ranges: " + supportedFramerates));
        CameraEnumerationAndroid.CaptureFormat.FramerateRange fpsRange = CameraEnumerationAndroid.getClosestSupportedFramerateRange((List)supportedFramerates, (int)framerate);
        int framerateDuration = framerate * 1000;
        if (framerateDuration > fpsRange.min && framerateDuration < fpsRange.max) {
            fpsRange.max = framerateDuration;
        }
        Size previewSize = CameraEnumerationAndroid.getClosestSupportedSize((List)Camera1Enumerator.convertSizes((List)parameters.getSupportedPreviewSizes()), (int)width, (int)height);
        CameraEnumerationAndroid.reportCameraResolution((Histogram)camera1ResolutionHistogram, (Size)previewSize);
        return new CameraEnumerationAndroid.CaptureFormat(previewSize.width, previewSize.height, fpsRange);
    }

    private static CameraEnumerationAndroid.CaptureFormat findClosestCaptureFormat(Camera.Parameters parameters, int width, int height, int framerate) {
        List supportedFramerates = Camera1Enumerator.convertFramerates((List)parameters.getSupportedPreviewFpsRange());
        Logging.d((String)TAG, (String)("Available fps ranges: " + supportedFramerates));
        CameraEnumerationAndroid.CaptureFormat.FramerateRange fpsRange = CameraEnumerationAndroid.getClosestSupportedFramerateRange((List)supportedFramerates, (int)framerate);
        Size previewSize = CameraEnumerationAndroid.getClosestSupportedSize((List)Camera1Enumerator.convertSizes((List)parameters.getSupportedPreviewSizes()), (int)width, (int)height);
        CameraEnumerationAndroid.reportCameraResolution((Histogram)camera1ResolutionHistogram, (Size)previewSize);
        return new CameraEnumerationAndroid.CaptureFormat(previewSize.width, previewSize.height, fpsRange);
    }

    private static Size findClosestPictureSize(Camera.Parameters parameters, int width, int height) {
        return CameraEnumerationAndroid.getClosestSupportedSize((List)Camera1Enumerator.convertSizes((List)parameters.getSupportedPictureSizes()), (int)width, (int)height);
    }

    private VHCameraSession(CameraSession.Events events, boolean captureToTexture, Context applicationContext, SurfaceTextureHelper surfaceTextureHelper, MediaRecorder mediaRecorder, int cameraId, Camera camera, Camera.CameraInfo info, CameraEnumerationAndroid.CaptureFormat captureFormat, long constructionTimeNs) {
        Logging.d((String)TAG, (String)("Create new camera1 session on camera " + cameraId));
        this.cameraThreadHandler = new Handler();
        this.events = events;
        this.captureToTexture = captureToTexture;
        this.applicationContext = applicationContext;
        this.surfaceTextureHelper = surfaceTextureHelper;
        this.cameraId = cameraId;
        this.mCamera = camera;
        this.info = info;
        this.captureFormat = captureFormat;
        this.constructionTimeNs = constructionTimeNs;
        this.startCapturing();
        if (mediaRecorder != null) {
            camera.unlock();
            mediaRecorder.setCamera(camera);
        }
    }

    public void stop() {
        Logging.d((String)TAG, (String)("Stop camera1 session on camera " + this.cameraId));
        this.checkIsOnCameraThread();
        if (this.state != SessionState.STOPPED) {
            long stopStartTime = System.nanoTime();
            this.stopInternal();
            int stopTimeMs = (int)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - stopStartTime);
            camera1StopTimeMsHistogram.addSample(stopTimeMs);
        }
    }

    private void startCapturing() {
        Logging.d((String)TAG, (String)"Start capturing");
        this.checkIsOnCameraThread();
        this.state = SessionState.RUNNING;
        beautifyFilter = new VHBeautifyFilter(this.captureFormat.width, this.captureFormat.height);
        beautifyFilter.setReceivedListener(this.receivedListener);
        beautifyFilter.prepare();
        beautifyFilter.setBeautifyLevel(2);
        beautifyFilter.setFilterEnable(enableBeautify);
        this.mCamera.setErrorCallback(new Camera.ErrorCallback(){

            public void onError(int error, Camera camera) {
                String errorMessage = error == 100 ? "Camera server died!" : "Camera error: " + error;
                Logging.e((String)VHCameraSession.TAG, (String)errorMessage);
                VHCameraSession.this.stopInternal();
                if (error == 2) {
                    VHCameraSession.this.events.onCameraDisconnected((CameraSession)VHCameraSession.this);
                } else {
                    VHCameraSession.this.events.onCameraError((CameraSession)VHCameraSession.this, errorMessage);
                }
            }
        });
        if (this.captureToTexture) {
            this.listenForTextureFrames();
        } else {
            this.listenForBytebufferFrames();
        }
        try {
            this.mCamera.startPreview();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            this.stopInternal();
            this.events.onCameraError((CameraSession)this, e.getMessage());
        }
    }

    private void stopInternal() {
        Logging.d((String)TAG, (String)"Stop internal");
        this.checkIsOnCameraThread();
        if (this.state == SessionState.STOPPED) {
            Logging.d((String)TAG, (String)"Camera is already stopped");
            return;
        }
        this.state = SessionState.STOPPED;
        this.surfaceTextureHelper.stopListening();
        this.mCamera.stopPreview();
        this.mCamera.release();
        this.events.onCameraClosed((CameraSession)this);
        beautifyFilter.release();
        Logging.d((String)TAG, (String)"Stop done");
    }

    private void listenForTextureFrames() {
        this.surfaceTextureHelper.startListening(new VideoSink(){

            public void onFrame(VideoFrame videoFrame) {
                VHCameraSession.this.events.onFrameCaptured((CameraSession)VHCameraSession.this, videoFrame);
                videoFrame.release();
            }
        });
    }

    void horizontalMirrorNv21(byte[] nv21, byte[] mirrorNv21, int width, int height) {
        int yLineStartIndex = 0;
        int uvLineStartIndex = width * height;
        for (int h = 0; h < height; ++h) {
            for (int w = 0; w < width; w += 2) {
                mirrorNv21[yLineStartIndex + w] = nv21[yLineStartIndex + width - 1 - w];
                mirrorNv21[yLineStartIndex + w + 1] = nv21[yLineStartIndex + width - 1 - w - 1];
                if ((h & 1) != 0) continue;
                mirrorNv21[uvLineStartIndex + w] = nv21[uvLineStartIndex + width - w];
                mirrorNv21[uvLineStartIndex + w + 1] = nv21[uvLineStartIndex + width - w - 1];
            }
            yLineStartIndex += width;
            if ((h & 1) != 0) continue;
            uvLineStartIndex += width;
        }
    }

    void verticalMirrorNv21(byte[] nv21, byte[] mirrorNv21, int width, int height) {
        int yLineDataSize = width;
        int nv21Index = 0;
        int mirrorNv21Index = 0;
        nv21Index = width * height - yLineDataSize;
        for (int h = 0; h < height; ++h) {
            System.arraycopy(nv21, nv21Index, mirrorNv21, mirrorNv21Index, yLineDataSize);
            mirrorNv21Index += yLineDataSize;
            nv21Index -= yLineDataSize;
        }
        int uvLineDataSize = width;
        int uvHeight = height / 2;
        nv21Index = width * height * 3 / 2 - uvLineDataSize;
        for (int h = 0; h < uvHeight; ++h) {
            System.arraycopy(nv21, nv21Index, mirrorNv21, mirrorNv21Index, yLineDataSize);
            mirrorNv21Index += uvLineDataSize;
            nv21Index -= uvLineDataSize;
        }
    }

    private void listenForBytebufferFrames() {
        this.mCamera.setPreviewCallbackWithBuffer(new Camera.PreviewCallback(){

            public void onPreviewFrame(byte[] data, Camera callbackCamera) {
                VHCameraSession.this.checkIsOnCameraThread();
                if (callbackCamera != VHCameraSession.this.mCamera) {
                    Logging.e((String)VHCameraSession.TAG, (String)"Callback from a different camera. This should never happen.");
                    return;
                }
                if (VHCameraSession.this.state != SessionState.RUNNING) {
                    Logging.d((String)VHCameraSession.TAG, (String)"Bytebuffer frame captured but camera is no longer running.");
                    return;
                }
                if (!VHCameraSession.this.firstFrameReported) {
                    int startTimeMs = (int)TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - VHCameraSession.this.constructionTimeNs);
                    camera1StartTimeMsHistogram.addSample(startTimeMs);
                    VHCameraSession.this.firstFrameReported = true;
                }
                if (VHCameraSession.this.isMirror) {
                    int width = ((VHCameraSession)VHCameraSession.this).captureFormat.width;
                    int height = ((VHCameraSession)VHCameraSession.this).captureFormat.height;
                    byte[] mirroredData = new byte[data.length];
                    Log.e((String)"========", (String)(VHCameraSession.this.getFrameOrientation() + ""));
                    if (VHCameraSession.this.getFrameOrientation() == 90 || VHCameraSession.this.getFrameOrientation() == 270) {
                        VHCameraSession.this.verticalMirrorNv21(data, mirroredData, width, height);
                    } else {
                        VHCameraSession.this.horizontalMirrorNv21(data, mirroredData, width, height);
                    }
                    if (enableBeautify || enableCaptureCallback) {
                        if (beautifyFilter != null) {
                            beautifyFilter.processVideoFrame(mirroredData, ((VHCameraSession)VHCameraSession.this).captureFormat.width, ((VHCameraSession)VHCameraSession.this).captureFormat.height);
                            VHCameraSession.this.mCamera.addCallbackBuffer(mirroredData);
                        }
                    } else {
                        VHCameraSession.this.frameCaptured(mirroredData, callbackCamera, null);
                    }
                } else if (enableBeautify || enableCaptureCallback) {
                    if (beautifyFilter != null) {
                        beautifyFilter.processVideoFrame(data, ((VHCameraSession)VHCameraSession.this).captureFormat.width, ((VHCameraSession)VHCameraSession.this).captureFormat.height);
                        VHCameraSession.this.mCamera.addCallbackBuffer(data);
                    }
                } else {
                    VHCameraSession.this.frameCaptured(data, callbackCamera, null);
                }
            }
        });
    }

    private void frameCaptured(final byte[] data, final Camera callbackCamera, final ByteBufferMemoryPool memoryPool) {
        long captureTimeNs = TimeUnit.MILLISECONDS.toNanos(SystemClock.elapsedRealtime());
        NV21Buffer frameBuffer = new NV21Buffer(data, this.captureFormat.width, this.captureFormat.height, new Runnable(){

            @Override
            public void run() {
                VHCameraSession.this.cameraThreadHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        if (VHCameraSession.this.state == SessionState.RUNNING) {
                            if (callbackCamera != null) {
                                callbackCamera.addCallbackBuffer(data);
                            } else if (memoryPool != null) {
                                memoryPool.releaseBuffer(data);
                            }
                        }
                    }
                });
            }
        });
        VideoFrame frame = new VideoFrame((VideoFrame.Buffer)frameBuffer, this.getFrameOrientation(), captureTimeNs);
        this.events.onFrameCaptured((CameraSession)this, frame);
        frame.release();
    }

    private int getDeviceOrientation() {
        int orientation = 0;
        WindowManager wm = (WindowManager)this.applicationContext.getSystemService("window");
        switch (wm.getDefaultDisplay().getRotation()) {
            case 1: {
                orientation = 90;
                break;
            }
            case 2: {
                orientation = 180;
                break;
            }
            case 3: {
                orientation = 270;
                break;
            }
            default: {
                orientation = 0;
            }
        }
        return orientation;
    }

    private int getFrameOrientation() {
        int rotation = this.getDeviceOrientation();
        if (this.info.facing == 0) {
            rotation = 360 - rotation;
        }
        return (this.info.orientation + rotation) % 360;
    }

    private void checkIsOnCameraThread() {
        if (Thread.currentThread() != this.cameraThreadHandler.getLooper().getThread()) {
            throw new IllegalStateException("Wrong thread");
        }
    }

    private boolean checkIfSupportAutoFocus() {
        if (null != this.mCamera) {
            List supportedModes = null;
            try {
                supportedModes = this.mCamera.getParameters().getSupportedFocusModes();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (null != supportedModes && supportedModes.contains("continuous-video")) {
                return true;
            }
        }
        return false;
    }

    private boolean checkIfSupportAreaFocus() {
        if (null != this.mCamera) {
            List supportedModes = null;
            int maxNumFocusAreas = 0;
            try {
                supportedModes = this.mCamera.getParameters().getSupportedFocusModes();
                maxNumFocusAreas = this.mCamera.getParameters().getMaxNumFocusAreas();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (null != supportedModes && supportedModes.contains("auto") && maxNumFocusAreas > 0) {
                return true;
            }
        }
        return false;
    }

    private void turnOnAutoFocus() {
        if (null != this.mCamera) {
            this.focusOnRect(this.makeCenterRect(), (success, camera) -> {
                if (success) {
                    this.mCamera.cancelAutoFocus();
                    Camera.Parameters parameters = this.mCamera.getParameters();
                    parameters.setFocusMode("continuous-video");
                    this.mCamera.setParameters(parameters);
                } else {
                    Log.e((String)TAG, (String)"autofocus failed");
                }
            });
        }
    }

    private void tryFocusOnCenter() {
        if (null != this.mCamera) {
            this.focusOnRect(this.makeCenterRect(), (success, camera) -> {
                if (success) {
                    Log.i((String)TAG, (String)"focusing center area");
                } else {
                    Log.e((String)TAG, (String)"focus failed");
                }
            });
        }
    }

    private void focusOnTouch(int x, int y, int surfaceWidth, int surfaceHeight) {
        Camera.CameraInfo camInfo = new Camera.CameraInfo();
        Camera.getCameraInfo((int)0, (Camera.CameraInfo)camInfo);
        int displayOrientation = camInfo.orientation;
        Log.d((String)TAG, (String)("---> focusOnTouch#displayOrientation = " + displayOrientation));
        this.focusOnRect(this.calculateTapArea(x, y, 1.0f, surfaceWidth, surfaceHeight, false, displayOrientation), null);
    }

    private Rect calculateTapArea(float x, float y, float coefficient, int width, int height, boolean mirror, int displayOrientation) {
        Rect resultRect = null;
        try {
            float focusAreaSize = 300.0f;
            int areaSize = Float.valueOf(focusAreaSize * coefficient).intValue();
            int centerX = (int)(x / (float)width * 2000.0f - 1000.0f);
            int centerY = (int)(y / (float)height * 2000.0f - 1000.0f);
            int halfAreaSize = areaSize / 2;
            RectF rectF = new RectF((float)this.clamp(centerX - halfAreaSize, -1000, 1000), (float)this.clamp(centerY - halfAreaSize, -1000, 1000), (float)this.clamp(centerX + halfAreaSize, -1000, 1000), (float)this.clamp(centerY + halfAreaSize, -1000, 1000));
            Matrix matrix = new Matrix();
            this.prepareMatrix(matrix, mirror, displayOrientation);
            matrix.mapRect(rectF);
            resultRect = new Rect(Math.round(rectF.left), Math.round(rectF.top), Math.round(rectF.right), Math.round(rectF.bottom));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resultRect;
    }

    private Rect makeCenterRect() {
        return new Rect(-150, -150, 150, 150);
    }

    private int clamp(int x, int min, int max) {
        if (x > max) {
            return max;
        }
        if (x < min) {
            return min;
        }
        return x;
    }

    private void prepareMatrix(Matrix matrix, boolean mirror, int displayOrientation) {
        if (matrix == null) {
            return;
        }
        Matrix _matrix = new Matrix();
        matrix.reset();
        _matrix.setScale(mirror ? -1.0f : 1.0f, 1.0f);
        _matrix.postRotate((float)displayOrientation);
        _matrix.invert(matrix);
    }

    private void focusOnRect(Rect rect, Camera.AutoFocusCallback autoFocusCallback) {
        if (null == rect) {
            Log.i((String)TAG, (String)">>> focusOnRect rect calculate error");
            return;
        }
        if (this.mCamera != null) {
            Camera.Parameters parameters = null;
            try {
                parameters = this.mCamera.getParameters();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (null != parameters) {
                parameters.setFocusMode("auto");
                if (parameters.getMaxNumFocusAreas() > 0) {
                    ArrayList<Camera.Area> focusAreas = new ArrayList<Camera.Area>();
                    focusAreas.add(new Camera.Area(rect, 1000));
                    parameters.setFocusAreas(focusAreas);
                }
                this.mCamera.cancelAutoFocus();
                try {
                    this.mCamera.setParameters(parameters);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                this.mCamera.autoFocus(autoFocusCallback != null ? autoFocusCallback : (success, camera) -> Log.i((String)TAG, (String)(">>> onAutoFocus " + (success ? "\u533a\u57df\u805a\u7126\u6210\u529f" : "\u533a\u57df\u805a\u7126\u5931\u8d25"))));
            }
        } else {
            Log.i((String)TAG, (String)">>> focusOnRect Camera is null");
        }
    }

    private static enum SessionState {
        RUNNING,
        STOPPED;

    }
}

