/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.vhallrtc.client;

import android.support.annotation.Nullable;
import com.vhall.vhallrtc.client.FinishCallback;
import com.vhall.vhallrtc.client.SignalingChannel;
import com.vhall.vhallrtc.common.LogManager;
import com.vhall.vhallrtc.message.ICECandidateMessage;
import com.vhall.vhallrtc.message.SessionDescriptionMessage;
import com.vhall.vhallrtc.message.SignalingMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.json.JSONArray;
import org.json.JSONObject;
import org.vhwebrtc.DataChannel;
import org.vhwebrtc.IceCandidate;
import org.vhwebrtc.MediaConstraints;
import org.vhwebrtc.MediaStream;
import org.vhwebrtc.MediaStreamTrack;
import org.vhwebrtc.PeerConnection;
import org.vhwebrtc.PeerConnectionFactory;
import org.vhwebrtc.RtpReceiver;
import org.vhwebrtc.SdpObserver;
import org.vhwebrtc.SessionDescription;
import org.vhwebrtc.StatsObserver;

class Client
extends SignalingChannel.VHSignalingChannelDelegate {
    private static final String mTag = "Client";
    private static final String VideoTrackKind = "video";
    private static final String AudioTrackKind = "audio";
    private static final int kKbpsMultiplier = 1000;
    private PeerConnectionFactory mFactory = null;
    private PeerConnection mPeerConnection = null;
    private MediaStream mLocalStream = null;
    private String mStreamId = null;
    private String mPeerSocketId = null;
    private ClientDelegate mDelegate;
    private VhallClientState mState;
    private List<PeerConnection.IceServer> mIceServers;
    private SignalingChannel mSignalingChannel = null;
    private boolean mHasReceivedSdp = false;
    private boolean mIsInitiator = false;
    private ArrayList<SignalingMessage> mMessageQueue = new ArrayList();
    ExecutorService mClientThread = Executors.newSingleThreadExecutor();
    private int mMaxBitrateKbps = 200;
    private int mCurrentBitrateKbps = 180;
    private int mMinBitrateKbps = 100;
    private int mSimulcastLayers = 1;
    private boolean mCpuoveruseDetection;
    private PeerConnection.Observer peerConnectionObserver = new PeerConnection.Observer(){

        public void onSignalingChange(PeerConnection.SignalingState signalingState) {
            Client.this.mClientThread.execute(new Runnable(){

                @Override
                public void run() {
                }
            });
        }

        public void onIceConnectionChange(final PeerConnection.IceConnectionState iceConnectionState) {
            Client.this.mClientThread.execute(new Runnable(){

                @Override
                public void run() {
                    if (Client.this.mDelegate != null) {
                        Client.this.mDelegate.onDidChangeConnectionState(Client.this, iceConnectionState);
                    }
                    switch (iceConnectionState) {
                        case NEW: 
                        case COMPLETED: {
                            break;
                        }
                        case CHECKING: {
                            break;
                        }
                        case CONNECTED: {
                            Client.this.setState(VhallClientState.VHClientStateConnected);
                            break;
                        }
                        case DISCONNECTED: 
                        case CLOSED: {
                            break;
                        }
                        case FAILED: {
                            Client.this.setState(VhallClientState.VHClientStateDisconnected);
                            Client.this.disconnect();
                            break;
                        }
                    }
                }
            });
        }

        public void onIceConnectionReceivingChange(boolean b) {
            Client.this.mClientThread.execute(new Runnable(){

                @Override
                public void run() {
                }
            });
        }

        public void onIceGatheringChange(final PeerConnection.IceGatheringState iceGatheringState) {
            Client.this.mClientThread.execute(new Runnable(){

                @Override
                public void run() {
                    if (iceGatheringState == PeerConnection.IceGatheringState.COMPLETE) {
                        ICECandidateMessage.VHIceCandidate candidate = new ICECandidateMessage.VHIceCandidate("end", -1, "end");
                        ICECandidateMessage iceMsg = new ICECandidateMessage(candidate, Client.this.streamId, Client.this.peerSocketId);
                        Client.this.mSignalingChannel.enqueueSignalingMessage(iceMsg);
                        Client.this.mSignalingChannel.drainMessageQueue(Client.this.streamId, Client.this.peerSocketId);
                        if (Client.this.mDelegate != null) {
                            Client.this.mDelegate.onSendCandidate(Client.this, Client.this.streamId, iceMsg.getIceCandidate().sdpMid);
                        }
                    }
                }
            });
        }

        public void onIceCandidate(IceCandidate iceCandidate) {
            final ICECandidateMessage.VHIceCandidate candidate = new ICECandidateMessage.VHIceCandidate(iceCandidate.sdpMid, iceCandidate.sdpMLineIndex, iceCandidate.sdp);
            Client.this.mClientThread.execute(new Runnable(){

                @Override
                public void run() {
                    ICECandidateMessage iceMsg = new ICECandidateMessage(candidate, Client.this.streamId, Client.this.peerSocketId);
                    Client.this.mSignalingChannel.enqueueSignalingMessage(iceMsg);
                }
            });
        }

        public void onIceCandidatesRemoved(IceCandidate[] iceCandidates) {
            Client.this.mClientThread.execute(new Runnable(){

                @Override
                public void run() {
                }
            });
        }

        public void onAddStream(final MediaStream mediaStream) {
            Client.this.mClientThread.execute(new Runnable(){

                @Override
                public void run() {
                    if (Client.this.mDelegate != null) {
                        Client.this.mDelegate.onDidReceiveRemoteStream(Client.this, mediaStream, Client.this.streamId);
                    }
                }
            });
        }

        public void onRemoveStream(MediaStream mediaStream) {
            Client.this.mClientThread.execute(new Runnable(){

                @Override
                public void run() {
                }
            });
        }

        public void onDataChannel(DataChannel dataChannel) {
            Client.this.mClientThread.execute(new Runnable(){

                @Override
                public void run() {
                }
            });
        }

        public void onRenegotiationNeeded() {
            Client.this.mClientThread.execute(new Runnable(){

                @Override
                public void run() {
                }
            });
        }

        public void onAddTrack(RtpReceiver rtpReceiver, MediaStream[] mediaStreams) {
        }
    };

    public Client(ClientDelegate delegate, PeerConnectionFactory factory) {
        this.mFactory = factory;
        this.mDelegate = delegate;
    }

    public void setMaxBitrateKbps(int kbps) {
        this.mMaxBitrateKbps = kbps;
    }

    public void setCpuoveruseDetection(boolean cpuoverusecetection) {
        this.mCpuoveruseDetection = cpuoverusecetection;
    }

    public void setMinBitrateKbps(int kbps) {
        this.mMinBitrateKbps = kbps;
    }

    public void setSimulcastLayers(int num) {
        this.mSimulcastLayers = num;
    }

    public void setCurrentBitrateKbps(int kbps) {
        this.mCurrentBitrateKbps = kbps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getStats(StatsObserver observer, MediaStreamTrack track) {
        Client client = this;
        synchronized (client) {
            if (this.mState == VhallClientState.VHClientStateConnected) {
                return this.mPeerConnection.getStats(observer, track);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        Client client = this;
        synchronized (client) {
            this.mState = VhallClientState.VHClientStateDisconnected;
            this.mHasReceivedSdp = false;
            this.mIsInitiator = false;
            this.mDelegate = null;
            if (this.mPeerConnection != null) {
                if (this.mLocalStream != null) {
                    this.mPeerConnection.removeStream(this.mLocalStream);
                }
                this.mPeerConnection.dispose();
                this.mPeerConnection = null;
            }
            LogManager.d(mTag, "client disconnect!");
        }
    }

    private MediaConstraints defaultPeerConnectionConstraints() {
        MediaConstraints constraints = new MediaConstraints();
        constraints.optional.add(new MediaConstraints.KeyValuePair("DtlsSrtpKeyAgreement", "true"));
        return constraints;
    }

    private MediaConstraints defaultOfferConstraints() {
        MediaConstraints constraints = new MediaConstraints();
        constraints.mandatory.add(new MediaConstraints.KeyValuePair("OfferToReceiveAudio", "true"));
        constraints.mandatory.add(new MediaConstraints.KeyValuePair("OfferToReceiveVideo", "true"));
        return constraints;
    }

    private MediaConstraints defaultAnswerConstraints() {
        return this.defaultOfferConstraints();
    }

    private void startPublishSignaling() {
        if (this.mPeerSocketId != null) {
            LogManager.i(mTag, "Start publish P2P signaling.");
        } else {
            LogManager.i(mTag, "Start publish signaling.");
        }
        this.mState = VhallClientState.VHClientStateConnecting;
        MediaConstraints constraints = this.defaultPeerConnectionConstraints();
        PeerConnection.RTCConfiguration rtcConfig = new PeerConnection.RTCConfiguration(this.mIceServers);
        rtcConfig.tcpCandidatePolicy = PeerConnection.TcpCandidatePolicy.ENABLED;
        rtcConfig.enableCpuOveruseDetection = this.mCpuoveruseDetection;
        this.mPeerConnection = this.mFactory.createPeerConnection(rtcConfig, constraints, this.peerConnectionObserver);
        if (this.mDelegate != null) {
            this.mDelegate.onDidCreatePeerConnection(this, this.mPeerConnection, this.streamId);
        }
        LogManager.i(mTag, "Adding local media stream to PeerConnection.");
        if (null != this.mDelegate) {
            this.mLocalStream = this.mDelegate.streamToPublishByAppClient(this);
        }
        this.mPeerConnection.addStream(this.mLocalStream);
        this.mPeerConnection.createOffer(new SdpObserver(){

            public void onCreateSuccess(SessionDescription sessionDescription) {
                LogManager.d(Client.mTag, "Publish SessionDescription Success");
                SessionDescriptionMessage.VHSessionDescription vhSessionDescription = new SessionDescriptionMessage.VHSessionDescription(sessionDescription.type, sessionDescription.description, Client.this.mSimulcastLayers);
                Client.this.didCreateSessionDescription(vhSessionDescription, null);
            }

            public void onSetSuccess() {
                LogManager.d(Client.mTag, "onSetSuccess");
            }

            public void onCreateFailure(String s) {
                LogManager.d(Client.mTag, "onCreateFailure");
                Client.this.didCreateSessionDescription(null, s);
            }

            public void onSetFailure(String s) {
                LogManager.d(Client.mTag, "onSetFailure");
            }
        }, this.defaultOfferConstraints());
    }

    private void startSubscribeSignaling() {
        this.mState = VhallClientState.VHClientStateConnecting;
        MediaConstraints constraints = this.defaultPeerConnectionConstraints();
        PeerConnection.RTCConfiguration rtcConfig = new PeerConnection.RTCConfiguration(this.mIceServers);
        rtcConfig.tcpCandidatePolicy = PeerConnection.TcpCandidatePolicy.ENABLED;
        boolean peerConnectionCreated = true;
        try {
            this.mPeerConnection = this.mFactory.createPeerConnection(rtcConfig, constraints, this.peerConnectionObserver);
        }
        catch (Exception e) {
            peerConnectionCreated = false;
            e.printStackTrace();
        }
        if (peerConnectionCreated) {
            if (this.mDelegate != null) {
                this.mDelegate.onDidCreatePeerConnection(this, this.mPeerConnection, this.streamId);
            }
            if (this.mPeerSocketId != null) {
                this.drainMessageQueueIfReady();
            } else {
                this.mPeerConnection.createOffer(new SdpObserver(){

                    public void onCreateSuccess(SessionDescription sessionDescription) {
                        LogManager.d(Client.mTag, "Subscribe SessionDescription Success");
                        SessionDescriptionMessage.VHSessionDescription vhSessionDescription = new SessionDescriptionMessage.VHSessionDescription(sessionDescription.type, sessionDescription.description, 1);
                        Client.this.didCreateSessionDescription(vhSessionDescription, null);
                    }

                    public void onSetSuccess() {
                        LogManager.d(Client.mTag, "onSetSuccess");
                    }

                    public void onCreateFailure(String s) {
                        LogManager.d(Client.mTag, "onCreateFailure");
                        Client.this.didCreateSessionDescription(null, s);
                    }

                    public void onSetFailure(String s) {
                        LogManager.d(Client.mTag, "onSetFailure");
                    }
                }, this.defaultOfferConstraints());
            }
        } else {
            LogManager.e(mTag, "creation of PeerConnection was failed");
        }
    }

    private void didCreateSessionDescription(final SessionDescription sessionDescription, final String error) {
        this.mClientThread.execute(new Runnable(){

            @Override
            public void run() {
                if (sessionDescription == null || error != null) {
                    Client.this.disconnect();
                    if (Client.this.mDelegate != null) {
                        Client.this.mDelegate.onDidError(Client.this, error);
                    }
                    return;
                }
                LogManager.d(Client.mTag, "did create a session description.");
                Client.this.mPeerConnection.setLocalDescription(new SdpObserver(){

                    public void onCreateSuccess(SessionDescription sessionDescription) {
                    }

                    public void onSetSuccess() {
                        LogManager.d(Client.mTag, "setLocalDescription success.");
                        if (Client.this.mDelegate != null) {
                            Client.this.mDelegate.onSendOffer(Client.this, Client.this.streamId, sessionDescription.description);
                        }
                        SessionDescriptionMessage message = new SessionDescriptionMessage(sessionDescription, Client.this.streamId, Client.this.peerSocketId);
                        Client.this.mSignalingChannel.sendSignalingMessage(message, new FinishCallback(){

                            @Override
                            public void onFinish(int code, @Nullable String message) {
                                if (code != 200) {
                                    Client.this.setState(VhallClientState.VHClientStateDisconnected);
                                    Client.this.disconnect();
                                    LogManager.e(Client.mTag, "send sdp error code:" + code);
                                }
                            }
                        });
                        Client.this.mPeerConnection.setBitrate(Integer.valueOf(Client.this.mMinBitrateKbps * 1000), Integer.valueOf(Client.this.mCurrentBitrateKbps * 1000), Integer.valueOf(Client.this.mMaxBitrateKbps * 1000));
                    }

                    public void onCreateFailure(String s) {
                    }

                    public void onSetFailure(String s) {
                        LogManager.e(Client.mTag, "setLocalDescription failure.");
                        if (Client.this.mDelegate != null) {
                            Client.this.mDelegate.onDidError(Client.this, s);
                        }
                    }
                }, sessionDescription);
            }
        });
    }

    private void drainMessageQueueIfReady() {
        if (this.mPeerConnection == null || !this.mHasReceivedSdp) {
            return;
        }
        for (SignalingMessage message : this.mMessageQueue) {
            this.processSignalingMessage(message);
        }
        this.mMessageQueue.clear();
    }

    private void processSignalingMessage(SignalingMessage message) {
        switch (message.type) {
            case kVHSignalingMessageTypeStarted: {
                break;
            }
            case kVHSignalingMessageTypeReady: {
                if (this.mDelegate == null) break;
                this.mDelegate.recvReadySignaling(this, this.streamId, "peerSocketId:" + message.peerSocketId);
                break;
            }
            case kVHSignalingMessageTypeOffer: 
            case kVHSignalingMessageTypeAnswer: {
                SessionDescriptionMessage sdpMessage = (SessionDescriptionMessage)message;
                if (this.mDelegate != null) {
                    this.mDelegate.onRecvAnswer(this, this.streamId, sdpMessage.getSessionDescription().description);
                }
                this.mPeerConnection.setRemoteDescription(new SdpObserver(){

                    public void onCreateSuccess(SessionDescription sessionDescription) {
                    }

                    public void onSetSuccess() {
                        LogManager.d(Client.mTag, "onSetSuccess");
                    }

                    public void onCreateFailure(String s) {
                    }

                    public void onSetFailure(String s) {
                        if (Client.this.mDelegate != null) {
                            Client.this.mDelegate.onDidError(Client.this, s);
                        }
                    }
                }, sdpMessage.getSessionDescription());
                break;
            }
            case kVHSignalingMessageTypeCandidate: {
                this.mPeerConnection.addIceCandidate(((ICECandidateMessage)message).getIceCandidate());
                break;
            }
            case kVHSignalingMessageTypeBye: {
                this.disconnect();
                break;
            }
        }
    }

    private void setupICEServers(JSONArray iceServersConfiguration) {
        this.mIceServers = new ArrayList<PeerConnection.IceServer>();
        for (int i = 0; i < iceServersConfiguration.length(); ++i) {
            JSONObject job = iceServersConfiguration.optJSONObject(i);
            String usename = job.optString("username") != null ? job.optString("username") : null;
            String password = job.optString("credential") != null ? job.optString("credential") : null;
            String url = job.optString("url");
            PeerConnection.IceServer iceServer = null;
            iceServer = usename == null && password == null ? new PeerConnection.IceServer(url) : new PeerConnection.IceServer(url, usename, password);
            this.mIceServers.add(iceServer);
        }
    }

    private void setState(VhallClientState state) {
        if (this.mState == state) {
            return;
        }
        this.mState = state;
        if (this.mDelegate != null) {
            this.mDelegate.onDidChangeState(this, this.mState);
        }
    }

    @Override
    public void onDidOpenChannel(SignalingChannel channel) {
        this.mSignalingChannel = channel;
        if (this.mDelegate != null) {
            JSONArray iceServers = this.mDelegate.onAppClientRequestICEServers(this);
            this.setupICEServers(iceServers);
        }
        this.setState(VhallClientState.VHClientStateReady);
    }

    @Override
    public void onPublishFailed(SignalingChannel channel) {
        if (this.mDelegate != null) {
            this.mDelegate.onDidError(this, "publis failed.");
        }
    }

    @Override
    public void onReadyToPublish(String streamId, String peerSocketId) {
        this.mStreamId = streamId;
        this.mPeerSocketId = peerSocketId;
        this.mIsInitiator = this.mPeerSocketId != null;
        this.startPublishSignaling();
    }

    @Override
    public void onReadyToSubscribe(String streamId, String peerSocketId) {
        this.mStreamId = streamId;
        this.mPeerSocketId = peerSocketId;
        this.startSubscribeSignaling();
    }

    @Override
    public void onDidReceiveMessage(SignalingMessage message) {
        switch (message.type) {
            case kVHSignalingMessageTypeOffer: 
            case kVHSignalingMessageTypeAnswer: {
                LogManager.d(mTag, "receive answer message.");
                this.mHasReceivedSdp = true;
                this.mMessageQueue.add(0, message);
                break;
            }
            case kVHSignalingMessageTypeCandidate: {
                this.mMessageQueue.add(message);
                break;
            }
            case kVHSignalingMessageTypeStarted: 
            case kVHSignalingMessageTypeReady: 
            case kVHSignalingMessageTypeBye: {
                this.processSignalingMessage(message);
                break;
            }
        }
        this.drainMessageQueueIfReady();
    }

    @Override
    public void onClosePeerConnection(SignalingChannel channel, String streamId) {
        try {
            this.disconnect();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static interface ClientDelegate {
        public void onDidCreatePeerConnection(Client var1, PeerConnection var2, String var3);

        public void onDidChangeState(Client var1, VhallClientState var2);

        public void onDidChangeConnectionState(Client var1, PeerConnection.IceConnectionState var2);

        public void onDidError(Client var1, String var2);

        public void onDidReceiveRemoteStream(Client var1, MediaStream var2, String var3);

        public MediaStream streamToPublishByAppClient(Client var1);

        public JSONArray onAppClientRequestICEServers(Client var1);

        public void onSendOffer(Client var1, String var2, String var3);

        public void onRecvAnswer(Client var1, String var2, String var3);

        public void onSendCandidate(Client var1, String var2, String var3);

        public void recvReadySignaling(Client var1, String var2, String var3);
    }

    public static enum VhallClientState {
        VHClientStateDisconnected,
        VHClientStateReady,
        VHClientStateConnecting,
        VHClientStateConnected;

    }
}

