/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.jni;

import com.vhall.jni.JniObject;
import com.vhall.jni.VhallLiveConfig;

public class VhallLiveApi
extends JniObject {
    public static final int FRAME_TYPE_HEAD = 0;
    public static final int FRAME_TYPE_I = 3;
    public static final int FRAME_TYPE_P = 4;
    public static final int FRAME_TYPE_B = 5;
    private static VhallLiveApi mNativeLivePush;
    private static VhallLiveApi mNativeLivePlayer;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static VhallLiveApi getPushInstance() {
        if (mNativeLivePush != null) return mNativeLivePush;
        Class<VhallLiveApi> clazz = VhallLiveApi.class;
        synchronized (VhallLiveApi.class) {
            if (mNativeLivePush != null) return mNativeLivePush;
            mNativeLivePush = new VhallLiveApi(LiveCreateType.kLivePublish.getValue());
            // ** MonitorExit[var0] (shouldn't be in output)
            return mNativeLivePush;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static VhallLiveApi getPlayInstance() {
        if (mNativeLivePlayer != null) return mNativeLivePlayer;
        Class<VhallLiveApi> clazz = VhallLiveApi.class;
        synchronized (VhallLiveApi.class) {
            if (mNativeLivePlayer != null) return mNativeLivePlayer;
            mNativeLivePlayer = new VhallLiveApi(LiveCreateType.kLivePlayer.getValue());
            // ** MonitorExit[var0] (shouldn't be in output)
            return mNativeLivePlayer;
        }
    }

    public VhallLiveApi(int livetype) {
        this.CreateVinnyLive(livetype);
    }

    private VhallLiveApi() {
    }

    protected void finalize() throws Throwable {
        this.DestoryVinnyLive();
        super.finalize();
    }

    private native void CreateVinnyLive(int var1);

    public native int AddPushObs(Object var1);

    public native int AddPlayerObs(Object var1);

    public native int SetParam(String var1, int var2);

    public native int SetMonitorLogParam(String var1);

    public native int StartPublish(String var1);

    public native int StopPublish();

    public native int StartRecv(String var1);

    public native int StopRecv();

    public native int PushVideoData(byte[] var1, int var2);

    public native int PushAudioData(byte[] var1, int var2);

    public native int PushVideoDataMs(byte[] var1, int var2, long var3);

    public native int PushAudioDataMs(byte[] var1, int var2, long var3);

    public native int PushH264Data(byte[] var1, int var2, int var3, long var4);

    public native int PushAACData(byte[] var1, int var2, long var3);

    public native int PushH264DataTs(byte[] var1, int var2, int var3, long var4);

    public native int PushAACDataTs(byte[] var1, int var2, int var3, long var4);

    public native void DestoryVinnyLive();

    public native int GetRealityBufferTime();

    public native int SetVolumeAmplificateSize(float var1);

    public native int OpenNoiseCancelling(boolean var1);

    public static native String TokenTransition(String var0);

    public static native String GetMCSDKVersion();

    public static native void EnableDebug(boolean var0);

    public static native void SwapYV122YuvPlanar(byte[] var0, byte[] var1, int var2, int var3);

    public static native void SwapYV122SemiPlanar(byte[] var0, byte[] var1, int var2, int var3);

    public static native void SwapNV212YuvPlanar(byte[] var0, byte[] var1, int var2, int var3);

    public static native void SwapNV212SemiPlanar(byte[] var0, byte[] var1, int var2, int var3);

    public static native void ConvertARGB8888ToYUV420SP(byte[] var0, byte[] var1, int var2, int var3);

    public static native void ConvertRGBA8888ToYUV420SP(byte[] var0, byte[] var1, int var2, int var3);

    public static native void ConvertABGR8888ToYUV420SP(byte[] var0, byte[] var1, int var2, int var3);

    public static native void RGBARotate(byte[] var0, byte[] var1, int var2, int var3, int var4);

    public static native void ConvertABGRPlaneToData(byte[] var0, byte[] var1, int var2, int var3, int var4, int var5);

    public static native void YUV420spRotate90(byte[] var0, byte[] var1, int var2, int var3, int var4);

    public static native void YUV420spToRBGA(byte[] var0, byte[] var1, int var2, int var3);

    public static native void GLReadPixels(int var0, int var1, int var2, int var3, int var4, int var5);

    static {
        if (VhallLiveConfig.canLoadNativeSo) {
            System.loadLibrary("vhffmpeg");
            System.loadLibrary("VhallLiveApi");
        }
        mNativeLivePush = null;
        mNativeLivePlayer = null;
    }

    public static enum LiveCreateType {
        kLivePublish(0),
        kLivePlayer(1);

        private int _value;

        private LiveCreateType(int value) {
            this._value = value;
        }

        public int getValue() {
            return this._value;
        }
    }
}

