package com.vhall.beautify;

import android.util.Log;

import com.faceunity.core.controller.facebeauty.FaceBeautyParam;
import com.faceunity.core.model.facebeauty.FaceBeauty;

import java.util.HashMap;

/**
 * @author：jooper Email：jooperge@163.com
 * 描述：
 * 修改历史:
 * <p>
 * 创建于： 2021/12/30
 */
public class DefaultFaceBeautyDataFactory {
    private final String TAG = "FaceBeautyDataFactory";
    /*美颜缓存数据模型 用于调整美颜参数的模型 在使用外界传入的FaceBeauty时，美颜参数独立调整不生效*/
    public static final FaceBeauty defaultFaceBeauty = DefaultFaceBeautySource.getDefaultFaceBeauty();
    /*当前生效美颜数据模型，若需要调用FURenderKit.getInstance().setFaceBeauty，建议同时更新currentBeauty，避免状态混乱*/
    public static FaceBeauty currentBeauty = defaultFaceBeauty;

    public void updateParamIntensity(String key, double value) {
        if (faceBeautySetMapping.containsKey(key)) {
            faceBeautySetMapping.get(key).setValue(value);
            Log.e(TAG, ">>>update " + key + " = " + value);
        } else {
            Log.e(TAG, ">>>" + key + " do not exits");
        }
    }

    public double getParamIntensity(String key) {
        if (faceBeautyGetMapping.containsKey(key)) {
            return faceBeautyGetMapping.get(key).getValue();
        }
        return 0.0;
    }

    interface FaceBeautySetParamInterface {
        /**
         * 设置属性值
         *
         * @param value
         */
        void setValue(double value);
    }

    interface FaceBeautyGetParamInterface {
        /**
         * 获取属性值
         *
         * @return
         */
        double getValue();
    }

//    private FaceBeauty getBindedFaceBeautyOrDefault() {
//        FaceBeauty result = FURenderKit.getInstance().getFaceBeauty();
//        return null == result ? getDefaultFaceBeauty() : result;
//    }

    /*模型映射设置模型值*/
    private final HashMap<String, FaceBeautySetParamInterface> faceBeautySetMapping = new HashMap<String, FaceBeautySetParamInterface>() {{
        put(FaceBeautyParam.COLOR_INTENSITY_M2, defaultFaceBeauty::setColorIntensity);
        put(FaceBeautyParam.BLUR_INTENSITY, defaultFaceBeauty::setBlurIntensity);
        put(FaceBeautyParam.RED_INTENSITY, defaultFaceBeauty::setRedIntensity);
        put(FaceBeautyParam.SHARPEN_INTENSITY, defaultFaceBeauty::setSharpenIntensity);
        put(FaceBeautyParam.EYE_BRIGHT_INTENSITY, defaultFaceBeauty::setEyeBrightIntensity);
        put(FaceBeautyParam.TOOTH_WHITEN_INTENSITY, defaultFaceBeauty::setToothIntensity);
        put(FaceBeautyParam.REMOVE_POUCH_INTENSITY_M2, defaultFaceBeauty::setRemovePouchIntensity);
        put(FaceBeautyParam.REMOVE_NASOLABIAL_FOLDS_INTENSITY_M2, defaultFaceBeauty::setRemoveLawPatternIntensity);
        put(FaceBeautyParam.CLARITY, defaultFaceBeauty::setClarityIntensity);
        put(FaceBeautyParam.DELSPOT, defaultFaceBeauty::setDelspotIntensity);
        /*美型*/
        put(FaceBeautyParam.FACE_SHAPE_INTENSITY, defaultFaceBeauty::setSharpenIntensity);
        put(FaceBeautyParam.CHEEK_THINNING_INTENSITY_M2, defaultFaceBeauty::setCheekThinningIntensity);
        put(FaceBeautyParam.CHEEK_V_INTENSITY, defaultFaceBeauty::setCheekVIntensity);
        put(FaceBeautyParam.CHEEK_LONG_INTENSITY, defaultFaceBeauty::setCheekLongIntensity);
        put(FaceBeautyParam.CHEEK_CIRCLE_INTENSITY, defaultFaceBeauty::setCheekCircleIntensity);
        put(FaceBeautyParam.CHEEK_NARROW_INTENSITY_M2, defaultFaceBeauty::setCheekNarrowIntensityV2);
        put(FaceBeautyParam.CHEEK_SHORT_INTENSITY, defaultFaceBeauty::setCheekShortIntensity);
        put(FaceBeautyParam.CHEEK_SMALL_INTENSITY_M2, defaultFaceBeauty::setCheekSmallIntensityV2);
        put(FaceBeautyParam.INTENSITY_CHEEKBONES_INTENSITY, defaultFaceBeauty::setCheekBonesIntensity);
        put(FaceBeautyParam.INTENSITY_LOW_JAW_INTENSITY, defaultFaceBeauty::setLowerJawIntensity);
        put(FaceBeautyParam.EYE_ENLARGING_INTENSITY_M3, defaultFaceBeauty::setEyeEnlargingIntensity);
        put(FaceBeautyParam.EYE_CIRCLE_INTENSITY, defaultFaceBeauty::setEyeCircleIntensity);
        put(FaceBeautyParam.CHIN_INTENSITY_M2, defaultFaceBeauty::setChinIntensity);
        put(FaceBeautyParam.FOREHEAD_INTENSITY_M2, defaultFaceBeauty::setForHeadIntensityV2);
        put(FaceBeautyParam.NOSE_INTENSITY_M2, defaultFaceBeauty::setNoseIntensityV2);
        put(FaceBeautyParam.MOUTH_INTENSITY_M3, defaultFaceBeauty::setMouthIntensity);
        put(FaceBeautyParam.CANTHUS_INTENSITY, defaultFaceBeauty::setCanthusIntensity);
        put(FaceBeautyParam.EYE_SPACE_INTENSITY, defaultFaceBeauty::setEyeSpaceIntensity);
        put(FaceBeautyParam.EYE_ROTATE_INTENSITY, defaultFaceBeauty::setEyeRotateIntensity);
        put(FaceBeautyParam.LONG_NOSE_INTENSITY, defaultFaceBeauty::setLongNoseIntensity);
        put(FaceBeautyParam.PHILTRUM_INTENSITY, defaultFaceBeauty::setPhiltrumIntensity);
        put(FaceBeautyParam.SMILE_INTENSITY, defaultFaceBeauty::setSmileIntensity);
        put(FaceBeautyParam.BROW_HEIGHT_INTENSITY, defaultFaceBeauty::setBrowHeightIntensity);
        put(FaceBeautyParam.BROW_SPACE_INTENSITY, defaultFaceBeauty::setBrowSpaceIntensity);
        put(FaceBeautyParam.INTENSITY_EYE_LID, defaultFaceBeauty::setEyeLidIntensity);
        put(FaceBeautyParam.INTENSITY_EYE_HEIGHT, defaultFaceBeauty::setEyeHeightIntensity);
        put(FaceBeautyParam.INTENSITY_BROW_THICK, defaultFaceBeauty::setBrowThickIntensity);
        put(FaceBeautyParam.INTENSITY_LIP_THICK, defaultFaceBeauty::setLipThickIntensity);
        put(FaceBeautyParam.FACE_THREED, defaultFaceBeauty::setFaceThreeIntensity);
    }};

    /*模型映射获取模型值*/
    private HashMap<String, FaceBeautyGetParamInterface> faceBeautyGetMapping = new HashMap<String, FaceBeautyGetParamInterface>() {
        {
            put(FaceBeautyParam.COLOR_INTENSITY_M2, defaultFaceBeauty::getColorIntensity);
            put(FaceBeautyParam.BLUR_INTENSITY, defaultFaceBeauty::getBlurIntensity);
            put(FaceBeautyParam.RED_INTENSITY, defaultFaceBeauty::getRedIntensity);
            put(FaceBeautyParam.SHARPEN_INTENSITY, defaultFaceBeauty::getSharpenIntensity);
            put(FaceBeautyParam.EYE_BRIGHT_INTENSITY, defaultFaceBeauty::getEyeBrightIntensity);
            put(FaceBeautyParam.TOOTH_WHITEN_INTENSITY, defaultFaceBeauty::getToothIntensity);
            put(FaceBeautyParam.REMOVE_POUCH_INTENSITY_M2, defaultFaceBeauty::getRemovePouchIntensity);
            put(FaceBeautyParam.REMOVE_NASOLABIAL_FOLDS_INTENSITY_M2, defaultFaceBeauty::getRemoveLawPatternIntensity);
            put(FaceBeautyParam.CLARITY, defaultFaceBeauty::getClarityIntensity);
            put(FaceBeautyParam.DELSPOT, defaultFaceBeauty::getDelspotIntensity);
            /*美型*/
            put(FaceBeautyParam.FACE_SHAPE_INTENSITY, defaultFaceBeauty::getSharpenIntensity);
            put(FaceBeautyParam.CHEEK_THINNING_INTENSITY_M2, defaultFaceBeauty::getCheekThinningIntensity);
            put(FaceBeautyParam.CHEEK_V_INTENSITY, defaultFaceBeauty::getCheekVIntensity);
            put(FaceBeautyParam.CHEEK_LONG_INTENSITY, defaultFaceBeauty::getCheekLongIntensity);
            put(FaceBeautyParam.CHEEK_CIRCLE_INTENSITY, defaultFaceBeauty::getCheekCircleIntensity);
            put(FaceBeautyParam.CHEEK_NARROW_INTENSITY_M2, defaultFaceBeauty::getCheekNarrowIntensityV2);
            put(FaceBeautyParam.CHEEK_SHORT_INTENSITY, defaultFaceBeauty::getCheekShortIntensity);
            put(FaceBeautyParam.CHEEK_SMALL_INTENSITY_M2, defaultFaceBeauty::getCheekSmallIntensityV2);
            put(FaceBeautyParam.INTENSITY_CHEEKBONES_INTENSITY, defaultFaceBeauty::getCheekBonesIntensity);
            put(FaceBeautyParam.INTENSITY_LOW_JAW_INTENSITY, defaultFaceBeauty::getLowerJawIntensity);
            put(FaceBeautyParam.EYE_ENLARGING_INTENSITY_M3, defaultFaceBeauty::getEyeEnlargingIntensity);
            put(FaceBeautyParam.EYE_CIRCLE_INTENSITY, defaultFaceBeauty::getEyeCircleIntensity);
            put(FaceBeautyParam.CHIN_INTENSITY_M2, defaultFaceBeauty::getChinIntensity);
            put(FaceBeautyParam.FOREHEAD_INTENSITY_M2, defaultFaceBeauty::getForHeadIntensityV2);
            put(FaceBeautyParam.NOSE_INTENSITY_M2, defaultFaceBeauty::getNoseIntensityV2);
            put(FaceBeautyParam.MOUTH_INTENSITY_M3, defaultFaceBeauty::getMouthIntensity);
            put(FaceBeautyParam.CANTHUS_INTENSITY, defaultFaceBeauty::getCanthusIntensity);
            put(FaceBeautyParam.EYE_SPACE_INTENSITY, defaultFaceBeauty::getEyeSpaceIntensity);
            put(FaceBeautyParam.EYE_ROTATE_INTENSITY, defaultFaceBeauty::getEyeRotateIntensity);
            put(FaceBeautyParam.LONG_NOSE_INTENSITY, defaultFaceBeauty::getLongNoseIntensity);
            put(FaceBeautyParam.PHILTRUM_INTENSITY, defaultFaceBeauty::getPhiltrumIntensity);
            put(FaceBeautyParam.SMILE_INTENSITY, defaultFaceBeauty::getSmileIntensity);
            put(FaceBeautyParam.BROW_HEIGHT_INTENSITY, defaultFaceBeauty::getBrowHeightIntensity);
            put(FaceBeautyParam.BROW_SPACE_INTENSITY, defaultFaceBeauty::getBrowSpaceIntensity);
            put(FaceBeautyParam.INTENSITY_EYE_LID, defaultFaceBeauty::getEyeLidIntensity);
            put(FaceBeautyParam.INTENSITY_EYE_HEIGHT, defaultFaceBeauty::getEyeHeightIntensity);
            put(FaceBeautyParam.INTENSITY_BROW_THICK, defaultFaceBeauty::getBrowThickIntensity);
            put(FaceBeautyParam.INTENSITY_LIP_THICK, defaultFaceBeauty::getLipThickIntensity);
            put(FaceBeautyParam.FACE_THREED, defaultFaceBeauty::getFaceThreeIntensity);
        }
    };
}