/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.logmanager.locallog;

import android.os.Environment;
import android.os.Process;
import com.vhall.logmanager.locallog.LogHtml;
import com.vhall.logmanager.locallog.LogMsg;
import java.io.File;
import java.io.FileOutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.concurrent.BlockingQueue;

public class LogExecutor
extends Thread {
    private final BlockingQueue<LogMsg> mQueue;
    private volatile boolean mQuit = false;
    private static DateFormat mDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private static DateFormat mTimeFormat = new SimpleDateFormat("MM-dd HH:mm:ss SSS");

    public LogExecutor(BlockingQueue<LogMsg> mQueue) {
        this.mQueue = mQueue;
    }

    @Override
    public void run() {
        Process.setThreadPriority((int)10);
        while (true) {
            LogMsg logMsg;
            try {
                logMsg = this.mQueue.take();
            }
            catch (InterruptedException e) {
                if (!this.mQuit) continue;
                return;
            }
            String date = mDateFormat.format(Calendar.getInstance(Locale.CHINA).getTime());
            String fileName = date + "log.html";
            StringBuilder builder = new StringBuilder();
            switch (logMsg.getPriority()) {
                case 1: {
                    builder.append("<font color=\"black\">");
                    break;
                }
                case 2: {
                    builder.append("<font color=\"green\">");
                    break;
                }
                case 3: {
                    builder.append("<font color=\"red\">");
                }
            }
            Calendar calendar = Calendar.getInstance();
            builder.append("[ " + mTimeFormat.format(calendar.getTime()) + " ] ");
            builder.append("[ " + logMsg.getTag() + " ] :");
            builder.append(logMsg.getMsg());
            builder.append("</font><br> ");
            try {
                File file = LogExecutor.getLogFile(fileName);
                if (file == null) {
                    return;
                }
                FileOutputStream outputStream = new FileOutputStream(file, true);
                outputStream.write(builder.toString().getBytes());
                outputStream.close();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public void quit() {
        this.mQuit = true;
        this.interrupt();
    }

    private static boolean checkSDCard() {
        try {
            if (Environment.getExternalStorageState().equals("mounted")) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private static File getLogFile(String fileName) {
        if (!LogExecutor.checkSDCard()) {
            return null;
        }
        File storageRoot = Environment.getExternalStorageDirectory();
        String path = LogHtml.getRootPath() + File.separator + "log";
        File tmpFile = new File(storageRoot.getAbsolutePath().concat(File.separator).concat(path));
        if (!tmpFile.exists()) {
            boolean result = tmpFile.mkdirs();
            if (result) {
                return new File(tmpFile, fileName);
            }
            return null;
        }
        return new File(tmpFile, fileName);
    }
}

