/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.logmanager;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.os.Environment;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.UUID;

public class VhallDeviceId {
    private static final String SHARED_PREFERENCES_NAME = "VhallDeviceId";
    private static final String SP_KEY_DEVICEID = "vhall_deviceid";
    private static final String fileName = Environment.getExternalStorageDirectory().getAbsolutePath() + "/.vvcatchnum";
    private static String vhallDeviceId = "";
    private static boolean systemReader = false;
    private static boolean fileSaveEnable = false;
    private static boolean isFileSaved = false;

    public static void setSystemReader(boolean systemReader) {
        VhallDeviceId.systemReader = systemReader;
    }

    public static void setFileSaveEnable(boolean fileSaveEnable) {
        VhallDeviceId.fileSaveEnable = fileSaveEnable;
    }

    public static String getVhallDeviceId(Context context, boolean mock) {
        systemReader = !mock;
        return VhallDeviceId.getVhallDeviceId(context);
    }

    public static String getVhallDeviceId(Context context) {
        String tempImei;
        if (!TextUtils.isEmpty((CharSequence)vhallDeviceId)) {
            if (!isFileSaved) {
                VhallDeviceId.setIdToFile(context, vhallDeviceId);
            }
            return vhallDeviceId;
        }
        if (context == null) {
            return "";
        }
        if (!TextUtils.isEmpty((CharSequence)VhallDeviceId.getIdFromSp(context))) {
            vhallDeviceId = VhallDeviceId.getIdFromSp(context);
            if (!isFileSaved) {
                VhallDeviceId.setIdToFile(context, vhallDeviceId);
            }
            return vhallDeviceId;
        }
        if (!TextUtils.isEmpty((CharSequence)VhallDeviceId.getIdFromFile(context))) {
            vhallDeviceId = VhallDeviceId.getIdFromFile(context);
            VhallDeviceId.setIdToSp(context, vhallDeviceId);
            return vhallDeviceId;
        }
        if (systemReader && !TextUtils.isEmpty((CharSequence)(tempImei = VhallDeviceId.getIMEI(context)))) {
            vhallDeviceId = tempImei;
            VhallDeviceId.setIdToSp(context, vhallDeviceId);
            VhallDeviceId.setIdToFile(context, vhallDeviceId);
            return vhallDeviceId;
        }
        vhallDeviceId = UUID.randomUUID().toString();
        VhallDeviceId.setIdToFile(context, vhallDeviceId);
        VhallDeviceId.setIdToSp(context, vhallDeviceId);
        return vhallDeviceId;
    }

    private boolean judgeData(String num) {
        if (TextUtils.isEmpty((CharSequence)num)) {
            return false;
        }
        return num.length() == 15 || num.length() == 16;
    }

    @SuppressLint(value={"MissingPermission"})
    private static String getIMEI(Context context) {
        try {
            TelephonyManager telephonyManager = (TelephonyManager)context.getSystemService("phone");
            String deviceId = Build.VERSION.SDK_INT >= 26 ? telephonyManager.getDeviceId() : telephonyManager.getDeviceId();
            return deviceId;
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    private static String getIdFromSp(Context context) {
        SharedPreferences sp = context.getSharedPreferences(SHARED_PREFERENCES_NAME, 4);
        String vhall_id = sp.getString(SP_KEY_DEVICEID, "");
        return vhall_id;
    }

    private static void setIdToSp(Context context, String vhall_id) {
        SharedPreferences sp = context.getSharedPreferences(SHARED_PREFERENCES_NAME, 4);
        SharedPreferences.Editor editor = sp.edit();
        editor.putString(SP_KEY_DEVICEID, vhall_id);
        editor.apply();
    }

    private static boolean lacksStoragePermissions(Context mContexts) {
        if (Build.VERSION.SDK_INT >= 23) {
            return mContexts.checkSelfPermission("android.permission.READ_EXTERNAL_STORAGE") == 0 && mContexts.checkSelfPermission("android.permission.WRITE_EXTERNAL_STORAGE") == 0;
        }
        return true;
    }

    private static String getIdFromFile(Context context) {
        if (!fileSaveEnable) {
            return "";
        }
        String content = "";
        if (VhallDeviceId.lacksStoragePermissions(context)) {
            File file = new File(fileName);
            try {
                if (file.exists()) {
                    FileInputStream fis = new FileInputStream(file);
                    content = VhallDeviceId.readStringFromInputStream(fis);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return content;
    }

    private static String readStringFromInputStream(FileInputStream fis) {
        if (fis == null) {
            return "";
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        try {
            int len;
            while ((len = fis.read(buffer)) != -1) {
                baos.write(buffer, 0, len);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return baos.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setIdToFile(Context context, String id) {
        if (!fileSaveEnable) {
            return;
        }
        if (VhallDeviceId.lacksStoragePermissions(context)) {
            File file = new File(fileName);
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(file);
                fos.write(id.getBytes("UTF-8"));
                isFileSaved = true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }
}

