/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.httpclient.impl.interceptor;

import android.text.TextUtils;
import com.vhall.httpclient.utils.OKHttpUtils;
import java.io.IOException;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.Buffer;
import okio.BufferedSink;
import org.json.JSONObject;

public class JsonInterceptor
implements Interceptor {
    public Response intercept(Interceptor.Chain chain) throws IOException {
        JSONObject pubJson = OKHttpUtils.getConfig().getPubJson();
        String pubJsonKey = OKHttpUtils.getConfig().getPubJsonKey();
        Request request = chain.request();
        try {
            RequestBody body = request.body();
            Buffer buffer = new Buffer();
            if (body != null) {
                body.writeTo((BufferedSink)buffer);
                String parameterStr = buffer.readUtf8();
                if (request.body().contentType().subtype().equalsIgnoreCase("json")) {
                    JSONObject jsonObject = new JSONObject(parameterStr);
                    if (!TextUtils.isEmpty((CharSequence)pubJsonKey)) {
                        jsonObject.put(pubJsonKey, (Object)pubJson);
                        RequestBody requestBody = RequestBody.create((MediaType)OKHttpUtils.JSON, (String)jsonObject.toString());
                        request = request.newBuilder().patch(requestBody).build();
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Response response = chain.proceed(request);
        return response;
    }
}

