/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.httpclient.impl;

import com.vhall.httpclient.core.BaseHttpConnection;
import com.vhall.httpclient.core.IVHNetRequestConfig;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;

public class VHHttpsConnection
extends BaseHttpConnection {
    private HttpsURLConnection httpsURLConnection;

    public VHHttpsConnection(String url, IVHNetRequestConfig config) {
        super(url, config);
        try {
            Map<String, String> headers;
            this.httpsURLConnection = config.getProxy() != null ? (HttpsURLConnection)new URL(url).openConnection(config.getProxy()) : (HttpsURLConnection)new URL(url).openConnection();
            this.httpsURLConnection.setReadTimeout(config.getReadTimeOut());
            this.httpsURLConnection.setConnectTimeout(config.getReadTimeOut());
            if (config.getSslSocketFactory() != null) {
                this.httpsURLConnection.setSSLSocketFactory(config.getSslSocketFactory());
            }
            if (config.getHostnameVerifier() != null) {
                this.httpsURLConnection.setHostnameVerifier(config.getHostnameVerifier());
            }
            if ((headers = config.getHeaders()) != null) {
                for (String key : headers.keySet()) {
                    String value = headers.get(key);
                    this.httpsURLConnection.setRequestProperty(key, value);
                    this.printLog(String.format("header :%s  value :%s ", key, value));
                }
            }
            this.httpsURLConnection.setRequestProperty("Content-Type", config.getContentType());
            this.httpsURLConnection.setRequestProperty("Charset", config.getCharset());
            this.httpsURLConnection.setRequestProperty("accept", config.getAccept());
            this.httpsURLConnection.setRequestMethod(config.getMethod());
        }
        catch (IOException e) {
            String message = "\u672a\u6355\u83b7\u5f02\u5e38";
            if (e != null) {
                message = e.getMessage();
            }
            this.printLog(String.format("exception %s", message));
        }
    }

    @Override
    public HttpURLConnection getHttpConnection() {
        return this.httpsURLConnection;
    }
}

