/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.httpclient.impl;

import com.vhall.httpclient.core.BaseHttpConnection;
import com.vhall.httpclient.core.IVHNetRequestConfig;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;

public class VHHttpConnection
extends BaseHttpConnection {
    private HttpURLConnection httpsURLConnection;

    public VHHttpConnection(String url, IVHNetRequestConfig config) {
        super(url, config);
        try {
            this.httpsURLConnection = config.getProxy() != null ? (HttpURLConnection)new URL(url).openConnection(config.getProxy()) : (HttpURLConnection)new URL(url).openConnection();
            this.httpsURLConnection.setReadTimeout(config.getReadTimeOut());
            this.httpsURLConnection.setConnectTimeout(config.getReadTimeOut());
            Map<String, String> headers = config.getHeaders();
            if (headers != null) {
                for (String key : headers.keySet()) {
                    String value = headers.get(key);
                    this.httpsURLConnection.setRequestProperty(key, value);
                    this.printLog(String.format("header :%s  value :%s ", key, value));
                }
            }
            this.httpsURLConnection.setRequestMethod(config.getMethod());
        }
        catch (IOException e) {
            String message = "\u672a\u6355\u83b7\u5f02\u5e38";
            if (e != null) {
                message = e.getMessage();
            }
            this.printLog(String.format("exception %s", message));
        }
    }

    @Override
    public HttpURLConnection getHttpConnection() {
        return this.httpsURLConnection;
    }
}

