/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.httpclient.core;

public interface VHNetResponse {
    public String getResult();

    public int getResponseCode();

    public String getErrorMessage();

    public boolean isOk();

    public static class Builder {
        String result;
        int code;
        String errorMsg;

        public Builder setResult(String result) {
            this.result = result;
            return this;
        }

        public Builder setResponseCode(int code) {
            this.code = code;
            return this;
        }

        public Builder setErrorMessage(String errorMessage) {
            this.errorMsg = errorMessage;
            return this;
        }

        public VHNetResponse build() {
            return new VHNetResponse(){

                @Override
                public String getResult() {
                    return result;
                }

                @Override
                public int getResponseCode() {
                    return code;
                }

                @Override
                public String getErrorMessage() {
                    return null;
                }

                @Override
                public boolean isOk() {
                    return code == 200;
                }
            };
        }
    }
}

