/*
 * Decompiled with CFR 0.152.
 */
package com.vhall.httpclient.core;

import com.vhall.httpclient.core.IVHNetLogCallback;
import java.net.Proxy;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.X509TrustManager;

public interface IVHNetRequestConfig {
    public static final int DEFAULT_TIMEOUT = 60000;

    public Map<String, String> getHeaders();

    public Map<String, String> getCookies();

    public String getContentType();

    public String getAccept();

    public String getCharset();

    public int getConnectTimeOut();

    public int getReadTimeOut();

    public int getWriteTimeOut();

    public Proxy getProxy();

    public HostnameVerifier getHostnameVerifier();

    public IVHNetLogCallback getLogReporter();

    public String getMethod();

    public SSLSocketFactory getSslSocketFactory();

    public X509TrustManager getTrustManager();

    public static class Builder {
        private Map<String, String> mHeaders = new HashMap<String, String>();
        private int mConnectTimeOut = 60000;
        private int mReadTimeOut = 60000;
        private int mWriteTimeOut = 60000;
        private Proxy mProxy;
        private HostnameVerifier mHostnameVerifier;
        private IVHNetLogCallback mLogCallback = new IVHNetLogCallback(){

            @Override
            public void log(String url, String message) {
            }
        };
        private String mMethod = Method.POST.name();
        private String mContentType = "application/json; charset=UTF-8";
        private String mCharset = "UTF_8";
        private String mAccept = "application/json";
        private SSLSocketFactory mSslSocketFactory;
        private X509TrustManager mTrustManager;

        public Builder addHeader(String name, String value) {
            this.mHeaders.put(name, value);
            return this;
        }

        public Builder addCookies(String name, String value) {
            return this;
        }

        public Builder setmConnectTimeOut(int timeOut) {
            this.mConnectTimeOut = timeOut;
            return this;
        }

        public Builder setmReadTimeOut(int timeOut) {
            this.mReadTimeOut = timeOut;
            return this;
        }

        public Builder setmWriteTimeOut(int timeOut) {
            this.mWriteTimeOut = timeOut;
            return this;
        }

        public Builder setProxy(Proxy proxy) {
            this.mProxy = proxy;
            return this;
        }

        public Builder hostnameVerifier(HostnameVerifier hostnameVerifier) {
            this.mHostnameVerifier = hostnameVerifier;
            return this;
        }

        public Builder setLogReporter(IVHNetLogCallback callback) {
            this.mLogCallback = callback;
            return this;
        }

        public Builder setMethod(String method) {
            this.mMethod = method;
            return this;
        }

        public Builder setMethod(Method method) {
            this.mMethod = method.name();
            return this;
        }

        public Builder setContentType(String contentType) {
            this.mContentType = contentType;
            return this;
        }

        public Builder setCharset(String charset) {
            this.mCharset = charset;
            return this;
        }

        public Builder setAccept(String accept) {
            this.mAccept = accept;
            return this;
        }

        public Builder sslSocketFactory(SSLSocketFactory sslSocketFactory, X509TrustManager trustManager) {
            this.mSslSocketFactory = sslSocketFactory;
            this.mTrustManager = trustManager;
            return this;
        }

        public IVHNetRequestConfig build() {
            return new IVHNetRequestConfig(){

                @Override
                public String getContentType() {
                    return mContentType;
                }

                @Override
                public String getCharset() {
                    return mCharset;
                }

                @Override
                public String getAccept() {
                    return mAccept;
                }

                @Override
                public Map<String, String> getHeaders() {
                    return mHeaders;
                }

                @Override
                public Map<String, String> getCookies() {
                    return null;
                }

                @Override
                public int getConnectTimeOut() {
                    return mConnectTimeOut;
                }

                @Override
                public int getReadTimeOut() {
                    return mReadTimeOut;
                }

                @Override
                public int getWriteTimeOut() {
                    return mWriteTimeOut;
                }

                @Override
                public Proxy getProxy() {
                    return mProxy;
                }

                @Override
                public HostnameVerifier getHostnameVerifier() {
                    return mHostnameVerifier;
                }

                @Override
                public IVHNetLogCallback getLogReporter() {
                    return mLogCallback;
                }

                @Override
                public String getMethod() {
                    return mMethod;
                }

                @Override
                public SSLSocketFactory getSslSocketFactory() {
                    return mSslSocketFactory;
                }

                @Override
                public X509TrustManager getTrustManager() {
                    return mTrustManager;
                }
            };
        }
    }

    public static enum Method {
        GET,
        POST;

    }
}

