/*
 * Decompiled with CFR 0.152.
 */
package contacts.debug;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.provider.ContactsContract;
import contacts.debug.LogKt;
import contacts.debug.LogPermissionsKt;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001c\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u000e\b\u0002\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0007\u001a\"\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0000\u00a8\u0006\b"}, d2={"logDataTable", "", "Landroid/content/Context;", "mimeTypesFilter", "", "", "contentUri", "Landroid/net/Uri;", "debug_release"})
public final class LogDataTableKt {
    @JvmOverloads
    public static final void logDataTable(@NotNull Context $this$logDataTable, @NotNull Set<String> mimeTypesFilter) {
        Intrinsics.checkNotNullParameter((Object)$this$logDataTable, (String)"<this>");
        Intrinsics.checkNotNullParameter(mimeTypesFilter, (String)"mimeTypesFilter");
        if (!LogPermissionsKt.hasReadPermission($this$logDataTable)) {
            LogKt.log("#### Data table - read contacts permission not granted");
            return;
        }
        LogKt.log("#### Data table");
        Uri uri = ContactsContract.Data.CONTENT_URI;
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"CONTENT_URI");
        LogDataTableKt.logDataTable($this$logDataTable, uri, mimeTypesFilter);
    }

    public static /* synthetic */ void logDataTable$default(Context context, Set set, int n, Object object) {
        if ((n & 1) != 0) {
            set = SetsKt.emptySet();
        }
        LogDataTableKt.logDataTable(context, set);
    }

    public static final void logDataTable(@NotNull Context $this$logDataTable, @NotNull Uri contentUri, @NotNull Set<String> mimeTypesFilter) {
        Intrinsics.checkNotNullParameter((Object)$this$logDataTable, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)contentUri, (String)"contentUri");
        Intrinsics.checkNotNullParameter(mimeTypesFilter, (String)"mimeTypesFilter");
        String[] stringArray = new String[]{"_id", "raw_contact_id", "contact_id", "mimetype", "is_primary", "is_super_primary", "data1", "data2", "data3", "data4", "data5", "data6", "data7", "data8", "data9", "data10", "data11", "data12", "data13", "data14"};
        Cursor cursor = $this$logDataTable.getContentResolver().query(contentUri, stringArray, null, null, null);
        if (cursor == null) {
            return;
        }
        while (cursor.moveToNext()) {
            String id = cursor.getString(0);
            String rawContactId = cursor.getString(1);
            String contactId = cursor.getString(2);
            String mimeType = cursor.getString(3);
            String isPrimary = cursor.getString(4);
            String isSuperPrimary = cursor.getString(5);
            if (!((Collection)mimeTypesFilter).isEmpty() && !mimeTypesFilter.contains(mimeType)) continue;
            String data1 = cursor.getString(6);
            String data2 = cursor.getString(7);
            String data3 = cursor.getString(8);
            String data4 = cursor.getString(9);
            String data5 = cursor.getString(10);
            String data6 = cursor.getString(11);
            String data7 = cursor.getString(12);
            String data8 = cursor.getString(13);
            String data9 = cursor.getString(14);
            String data10 = cursor.getString(15);
            String data11 = cursor.getString(16);
            String data12 = cursor.getString(17);
            String data13 = cursor.getString(18);
            String data14 = cursor.getString(19);
            LogKt.log(StringsKt.replace$default((String)StringsKt.trimIndent((String)("\n                Data id: " + id + ", rawContactId: " + rawContactId + ", contactId: " + contactId + ",\n                 mimeType: " + mimeType + ", isPrimary: " + isPrimary + ", isSuperPrimary: " + isSuperPrimary + ",\n                 data1: " + data1 + ", data2: " + data2 + ", data3: " + data3 + ", data4: " + data4 + ", data5: " + data5 + ",\n                 data6: " + data6 + ", data7: " + data7 + ", data8: " + data8 + ", data9: " + data9 + ", data10: " + data10 + ",\n                 data11: " + data11 + ", data12: " + data12 + ", data13: " + data13 + ", data14: " + data14 + "\n            ")), (String)"\n", (String)"", (boolean)false, (int)4, null));
        }
        cursor.close();
    }

    @JvmOverloads
    public static final void logDataTable(@NotNull Context $this$logDataTable) {
        Intrinsics.checkNotNullParameter((Object)$this$logDataTable, (String)"<this>");
        LogDataTableKt.logDataTable$default($this$logDataTable, null, 1, null);
    }
}

