/*
 * Decompiled with CFR 0.152.
 */
package contacts.debug;

import android.content.Context;
import android.database.Cursor;
import android.os.Build;
import android.provider.BlockedNumberContract;
import android.provider.Telephony;
import android.telecom.TelecomManager;
import contacts.debug.LogKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000\u0012\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\f\u0010\u0003\u001a\u00020\u0004*\u00020\u0002H\u0002\u00a8\u0006\u0005"}, d2={"logBlockedNumbersTable", "", "Landroid/content/Context;", "canReadWriteBlockedNumbers", "", "debug_release"})
public final class LogBlockedNumbersKt {
    public static final void logBlockedNumbersTable(@NotNull Context $this$logBlockedNumbersTable) {
        Intrinsics.checkNotNullParameter((Object)$this$logBlockedNumbersTable, (String)"<this>");
        if (Build.VERSION.SDK_INT < 24) {
            LogKt.log("#### Blocked numbers table - not available prior to Android 7.0 (N / API 24)");
        } else if (!LogBlockedNumbersKt.canReadWriteBlockedNumbers($this$logBlockedNumbersTable)) {
            LogKt.log("#### Blocked numbers table - only available for system, default dialer, or default SMS app");
        } else {
            LogKt.log("#### Blocked numbers table");
            try {
                String[] stringArray = new String[]{"_id", "original_number", "e164_number"};
                Cursor cursor = $this$logBlockedNumbersTable.getContentResolver().query(BlockedNumberContract.BlockedNumbers.CONTENT_URI, stringArray, null, null, null);
                if (cursor != null) {
                    while (cursor.moveToNext()) {
                        String id = cursor.getString(0);
                        String originalNumber = cursor.getString(1);
                        String e164Number = cursor.getString(2);
                        LogKt.log("Blocked number id: " + id + ", originalNumber: " + originalNumber + ", e164Number: " + e164Number);
                    }
                    cursor.close();
                }
            }
            catch (SecurityException se) {
                LogKt.log("#### Blocked numbers table - error");
                LogKt.log(se.toString());
            }
        }
    }

    private static final boolean canReadWriteBlockedNumbers(Context $this$canReadWriteBlockedNumbers) {
        if (Build.VERSION.SDK_INT < 24) {
            return false;
        }
        Object object = $this$canReadWriteBlockedNumbers.getSystemService("telecom");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.telecom.TelecomManager");
        String defaultDialerPackage = ((TelecomManager)object).getDefaultDialerPackage();
        String defaultSmsPackage = Telephony.Sms.getDefaultSmsPackage((Context)$this$canReadWriteBlockedNumbers);
        boolean canCurrentUserBlockNumbers = BlockedNumberContract.canCurrentUserBlockNumbers((Context)$this$canReadWriteBlockedNumbers);
        boolean isDefaultDialer = Intrinsics.areEqual((Object)$this$canReadWriteBlockedNumbers.getPackageName(), (Object)defaultDialerPackage);
        boolean isDefaultSms = Intrinsics.areEqual((Object)$this$canReadWriteBlockedNumbers.getPackageName(), (Object)defaultSmsPackage);
        return canCurrentUserBlockNumbers && (isDefaultDialer || isDefaultSms);
    }
}

