/*
 * Decompiled with CFR 0.152.
 */
package com.github.vertical_blank.sqlformatter.core;

import java.util.Stack;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class Indentation {
    private final String indent;
    private final Stack<IndentTypes> indentTypes;

    Indentation(String indent) {
        this.indent = indent;
        this.indentTypes = new Stack();
    }

    public String getIndent() {
        return IntStream.range(0, this.indentTypes.size()).mapToObj(i -> this.indent).collect(Collectors.joining());
    }

    void increaseToplevel() {
        this.indentTypes.push(IndentTypes.INDENT_TYPE_TOP_LEVEL);
    }

    void increaseBlockLevel() {
        this.indentTypes.push(IndentTypes.INDENT_TYPE_BLOCK_LEVEL);
    }

    void decreaseTopLevel() {
        if (!this.indentTypes.isEmpty() && this.indentTypes.peek() == IndentTypes.INDENT_TYPE_TOP_LEVEL) {
            this.indentTypes.pop();
        }
    }

    void decreaseBlockLevel() {
        IndentTypes type;
        while (this.indentTypes.size() > 0 && (type = this.indentTypes.pop()) == IndentTypes.INDENT_TYPE_TOP_LEVEL) {
        }
    }

    void resetIndentation() {
        this.indentTypes.clear();
    }

    static enum IndentTypes {
        INDENT_TYPE_TOP_LEVEL,
        INDENT_TYPE_BLOCK_LEVEL;

    }
}

