/*
 * Decompiled with CFR 0.152.
 */
package com.github.vertical_blank.sqlformatter.core;

import com.github.vertical_blank.sqlformatter.core.DialectConfig;
import com.github.vertical_blank.sqlformatter.core.Token;
import com.github.vertical_blank.sqlformatter.core.TokenTypes;
import com.github.vertical_blank.sqlformatter.core.util.JSLikeList;
import com.github.vertical_blank.sqlformatter.core.util.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Tokenizer {
    private final Pattern WHITESPACE_PATTERN = Pattern.compile("^(\\s+)");
    private final Pattern NUMBER_PATTERN = Pattern.compile("^((-\\s*)?[0-9]+(\\.[0-9]+)?|0x[0-9a-fA-F]+|0b[01]+)\\b");
    private final Pattern OPERATOR_PATTERN = Pattern.compile("^(!=|<>|==|<=|>=|!<|!>|\\|\\||::|->>|=>|->|~~\\*|~~|!~~\\*|!~~|~\\*|!~\\*|!~|.)");
    private final Pattern BLOCK_COMMENT_PATTERN = Pattern.compile("^(/\\*(?s).*?(?:\\*/|$))");
    private final Pattern LINE_COMMENT_PATTERN;
    private final Pattern RESERVED_TOPLEVEL_PATTERN;
    private final Pattern RESERVED_NEWLINE_PATTERN;
    private final Pattern RESERVED_PLAIN_PATTERN;
    private final Pattern WORD_PATTERN;
    private final Pattern STRING_PATTERN;
    private final Pattern OPEN_PAREN_PATTERN;
    private final Pattern CLOSE_PAREN_PATTERN;
    private final Pattern INDEXED_PLACEHOLDER_PATTERN;
    private final Pattern IDENT_NAMED_PLACEHOLDER_PATTERN;
    private final Pattern STRING_NAMED_PLACEHOLDER_PATTERN;

    public Tokenizer(DialectConfig cfg) {
        this.LINE_COMMENT_PATTERN = Pattern.compile(this.createLineCommentRegex(new JSLikeList<String>(cfg.lineCommentTypes)));
        this.RESERVED_TOPLEVEL_PATTERN = Pattern.compile(this.createReservedWordRegex(new JSLikeList<String>(cfg.reservedToplevelWords)));
        this.RESERVED_NEWLINE_PATTERN = Pattern.compile(this.createReservedWordRegex(new JSLikeList<String>(cfg.reservedNewlineWords)));
        this.RESERVED_PLAIN_PATTERN = Pattern.compile(this.createReservedWordRegex(new JSLikeList<String>(cfg.reservedWords)));
        this.WORD_PATTERN = Pattern.compile(this.createWordRegex(new JSLikeList<String>(cfg.specialWordChars)));
        this.STRING_PATTERN = Pattern.compile(this.createStringRegex(new JSLikeList<String>(cfg.stringTypes)));
        this.OPEN_PAREN_PATTERN = Pattern.compile(this.createParenRegex(new JSLikeList<String>(cfg.openParens)));
        this.CLOSE_PAREN_PATTERN = Pattern.compile(this.createParenRegex(new JSLikeList<String>(cfg.closeParens)));
        this.INDEXED_PLACEHOLDER_PATTERN = Tokenizer.createPlaceholderRegexPattern(new JSLikeList<String>(cfg.indexedPlaceholderTypes), "[0-9]*");
        this.IDENT_NAMED_PLACEHOLDER_PATTERN = Tokenizer.createPlaceholderRegexPattern(new JSLikeList<String>(cfg.namedPlaceholderTypes), "[a-zA-Z0-9._$]+");
        this.STRING_NAMED_PLACEHOLDER_PATTERN = Tokenizer.createPlaceholderRegexPattern(new JSLikeList<String>(cfg.namedPlaceholderTypes), this.createStringPattern(new JSLikeList<String>(cfg.stringTypes)));
    }

    private String createLineCommentRegex(JSLikeList<String> lineCommentTypes) {
        return String.format("^((?:%s).*?(?:\n|$))", lineCommentTypes.map(Util::escapeRegExp).join("|"));
    }

    private String createReservedWordRegex(JSLikeList<String> reservedWords) {
        String reservedWordsPattern = reservedWords.join("|").replaceAll(" ", "\\\\s+");
        return "(?i)^(" + reservedWordsPattern + ")\\b";
    }

    private String createWordRegex(JSLikeList<String> specialChars) {
        return "^([\\w" + specialChars.join("") + "]+)";
    }

    private String createStringRegex(JSLikeList<String> stringTypes) {
        return "^(" + this.createStringPattern(stringTypes) + ")";
    }

    private String createStringPattern(JSLikeList<String> stringTypes) {
        HashMap<String, String> patterns = new HashMap<String, String>();
        patterns.put("``", "((`[^`]*($|`))+)");
        patterns.put("[]", "((\\[[^\\]]*($|\\]))(\\][^\\]]*($|\\]))*)");
        patterns.put("\"\"", "((\"[^\"\\\\]*(?:\\\\.[^\"\\\\]*)*(\"|$))+)");
        patterns.put("''", "(('[^'\\\\]*(?:\\\\.[^'\\\\]*)*('|$))+)");
        patterns.put("N''", "((N'[^N'\\\\]*(?:\\\\.[^N'\\\\]*)*('|$))+)");
        return stringTypes.map(patterns::get).join("|");
    }

    private String createParenRegex(JSLikeList<String> parens) {
        return "(?i)^(" + parens.map(Tokenizer::escapeParen).join("|") + ")";
    }

    private static String escapeParen(String paren) {
        if (paren.length() == 1) {
            return Util.escapeRegExp(paren);
        }
        return "\\b" + paren + "\\b";
    }

    private static Pattern createPlaceholderRegexPattern(JSLikeList<String> types, String pattern) {
        if (types.isEmpty()) {
            return null;
        }
        String typesRegex = types.map(Util::escapeRegExp).join("|");
        return Pattern.compile(String.format("^((?:%s)(?:%s))", typesRegex, pattern));
    }

    List<Token> tokenize(String input) {
        ArrayList<Token> tokens = new ArrayList<Token>();
        Token token = null;
        while (input.length() != 0) {
            token = this.getNextToken(input, token);
            input = input.substring(token.value.length());
            tokens.add(token);
        }
        return tokens;
    }

    private Token getNextToken(String input, Token previousToken) {
        return (Token)Util.firstNotnull(() -> this.getWhitespaceToken(input), () -> this.getCommentToken(input), () -> this.getStringToken(input), () -> this.getOpenParenToken(input), () -> this.getCloseParenToken(input), () -> this.getPlaceholderToken(input), () -> this.getNumberToken(input), () -> this.getReservedWordToken(input, previousToken), () -> this.getWordToken(input), () -> this.getOperatorToken(input));
    }

    private Token getWhitespaceToken(String input) {
        return this.getTokenOnFirstMatch(input, TokenTypes.WHITESPACE, this.WHITESPACE_PATTERN);
    }

    private Token getCommentToken(String input) {
        return (Token)Util.firstNotnull(() -> this.getLineCommentToken(input), () -> this.getBlockCommentToken(input));
    }

    private Token getLineCommentToken(String input) {
        return this.getTokenOnFirstMatch(input, TokenTypes.LINE_COMMENT, this.LINE_COMMENT_PATTERN);
    }

    private Token getBlockCommentToken(String input) {
        return this.getTokenOnFirstMatch(input, TokenTypes.BLOCK_COMMENT, this.BLOCK_COMMENT_PATTERN);
    }

    private Token getStringToken(String input) {
        return this.getTokenOnFirstMatch(input, TokenTypes.STRING, this.STRING_PATTERN);
    }

    private Token getOpenParenToken(String input) {
        return this.getTokenOnFirstMatch(input, TokenTypes.OPEN_PAREN, this.OPEN_PAREN_PATTERN);
    }

    private Token getCloseParenToken(String input) {
        return this.getTokenOnFirstMatch(input, TokenTypes.CLOSE_PAREN, this.CLOSE_PAREN_PATTERN);
    }

    private Token getPlaceholderToken(String input) {
        return (Token)Util.firstNotnull(() -> this.getIdentNamedPlaceholderToken(input), () -> this.getStringNamedPlaceholderToken(input), () -> this.getIndexedPlaceholderToken(input));
    }

    private Token getIdentNamedPlaceholderToken(String input) {
        return this.getPlaceholderTokenWithKey(input, this.IDENT_NAMED_PLACEHOLDER_PATTERN, v -> v.substring(1));
    }

    private Token getStringNamedPlaceholderToken(String input) {
        return this.getPlaceholderTokenWithKey(input, this.STRING_NAMED_PLACEHOLDER_PATTERN, v -> this.getEscapedPlaceholderKey(v.substring(2, v.length() - 1), v.substring(v.length() - 1)));
    }

    private Token getIndexedPlaceholderToken(String input) {
        return this.getPlaceholderTokenWithKey(input, this.INDEXED_PLACEHOLDER_PATTERN, v -> v.substring(1));
    }

    private Token getPlaceholderTokenWithKey(String input, Pattern regex, Function<String, String> parseKey) {
        Token token = this.getTokenOnFirstMatch(input, TokenTypes.PLACEHOLDER, regex);
        if (token != null) {
            token.key = parseKey.apply(token.value);
        }
        return token;
    }

    private String getEscapedPlaceholderKey(String key, String quoteChar) {
        return key.replaceAll(Util.escapeRegExp("\\") + quoteChar, quoteChar);
    }

    private Token getNumberToken(String input) {
        return this.getTokenOnFirstMatch(input, TokenTypes.NUMBER, this.NUMBER_PATTERN);
    }

    private Token getOperatorToken(String input) {
        return this.getTokenOnFirstMatch(input, TokenTypes.OPERATOR, this.OPERATOR_PATTERN);
    }

    private Token getReservedWordToken(String input, Token previousToken) {
        if (previousToken != null && previousToken.value != null && previousToken.value.equals(".")) {
            return null;
        }
        return (Token)Util.firstNotnull(() -> this.getToplevelReservedToken(input), () -> this.getNewlineReservedToken(input), () -> this.getPlainReservedToken(input));
    }

    private Token getToplevelReservedToken(String input) {
        return this.getTokenOnFirstMatch(input, TokenTypes.RESERVED_TOPLEVEL, this.RESERVED_TOPLEVEL_PATTERN);
    }

    private Token getNewlineReservedToken(String input) {
        return this.getTokenOnFirstMatch(input, TokenTypes.RESERVED_NEWLINE, this.RESERVED_NEWLINE_PATTERN);
    }

    private Token getPlainReservedToken(String input) {
        return this.getTokenOnFirstMatch(input, TokenTypes.RESERVED, this.RESERVED_PLAIN_PATTERN);
    }

    private Token getWordToken(String input) {
        return this.getTokenOnFirstMatch(input, TokenTypes.WORD, this.WORD_PATTERN);
    }

    private String getFirstMatch(String input, Pattern regex) {
        if (regex == null) {
            return null;
        }
        Matcher matcher = regex.matcher(input);
        if (matcher.find()) {
            return matcher.group();
        }
        return null;
    }

    private Token getTokenOnFirstMatch(String input, TokenTypes type, Pattern regex) {
        String matches = this.getFirstMatch(input, regex);
        if (matches != null) {
            return new Token(type, matches);
        }
        return null;
    }
}

