/*
 * Decompiled with CFR 0.152.
 */
package com.github.veithen.cosmos.osgi.runtime;

import com.github.veithen.cosmos.osgi.runtime.CosmosRuntime;
import com.github.veithen.cosmos.osgi.runtime.ResourceProcessor;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import org.osgi.framework.BundleException;

final class ResourceUtil {
    private ResourceUtil() {
    }

    static void processResources(String resourceName, ResourceProcessor processor) throws BundleException {
        Enumeration<URL> e;
        try {
            e = CosmosRuntime.class.getClassLoader().getResources(resourceName);
        }
        catch (IOException ex) {
            throw new BundleException(String.format("Failed to load %s resources", resourceName), (Throwable)ex);
        }
        while (e.hasMoreElements()) {
            URL url = e.nextElement();
            try {
                InputStream in = url.openStream();
                try {
                    processor.process(url, in);
                }
                finally {
                    if (in == null) continue;
                    in.close();
                }
            }
            catch (IOException ex) {
                throw new BundleException(String.format("Failed to load %s", url), (Throwable)ex);
            }
        }
    }
}

