/*
 * Decompiled with CFR 0.152.
 */
package com.github.veithen.cosmos.osgi.runtime;

import com.github.veithen.cosmos.osgi.runtime.ParseException;
import com.github.veithen.cosmos.osgi.runtime.Tokenizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.osgi.framework.BundleException;

final class Element {
    private String[] values;
    private Map<String, String> attributes;
    private Map<String, String> directives;

    private Element(String[] values, Map<String, String> attributes, Map<String, String> directives) {
        this.values = values;
        this.attributes = attributes;
        this.directives = directives;
    }

    static Element[] parseHeaderValue(String value) throws ParseException {
        int c;
        Tokenizer tokenizer = new Tokenizer(value);
        ArrayList<Element> elements = new ArrayList<Element>();
        do {
            ArrayList<String> values = new ArrayList<String>();
            HashMap<String, String> attributes = new HashMap<String, String>();
            HashMap<String, String> directives = new HashMap<String, String>();
            do {
                String token = tokenizer.getToken(";,=:");
                c = tokenizer.getChar();
                switch (c) {
                    case 61: {
                        attributes.put(token, tokenizer.getString(";,"));
                        c = tokenizer.getChar();
                        break;
                    }
                    case 58: {
                        if (tokenizer.skipIf('=')) {
                            directives.put(token, tokenizer.getString(";,"));
                        } else {
                            values.add(token + ":" + tokenizer.getToken(";,"));
                        }
                        c = tokenizer.getChar();
                        break;
                    }
                    default: {
                        values.add(token);
                    }
                }
            } while (c == 59);
            elements.add(new Element(values.toArray(new String[values.size()]), attributes, directives));
        } while (c != -1);
        return elements.toArray(new Element[elements.size()]);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        for (String value : this.values) {
            if (buffer.length() > 0) {
                buffer.append("; ");
            }
            buffer.append(value);
        }
        for (Map.Entry entry : this.attributes.entrySet()) {
            if (buffer.length() > 0) {
                buffer.append("; ");
            }
            buffer.append((String)entry.getKey());
            buffer.append("=");
            buffer.append((String)entry.getValue());
        }
        for (Map.Entry entry : this.directives.entrySet()) {
            if (buffer.length() > 0) {
                buffer.append("; ");
            }
            buffer.append((String)entry.getKey());
            buffer.append(":=");
            buffer.append((String)entry.getValue());
        }
        return buffer.toString();
    }

    String getValue() throws BundleException {
        if (this.values.length == 1) {
            return this.values[0];
        }
        throw new BundleException("Expected only a single header value");
    }

    boolean hasAttributes() {
        return !this.attributes.isEmpty();
    }

    boolean hasDirectives() {
        return !this.directives.isEmpty();
    }

    String getAttribute(String name) {
        return this.attributes.get(name);
    }

    String getDirective(String name) {
        return this.directives.get(name);
    }
}

